/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.discovery.PeerFinder;
import org.elasticsearch.discovery.SeedHostsProvider;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class SeedHostsResolver
extends AbstractLifecycleComponent
implements PeerFinder.ConfiguredHostsResolver {
    public static final Setting<Integer> LEGACY_DISCOVERY_ZEN_PING_UNICAST_CONCURRENT_CONNECTS_SETTING = Setting.intSetting("discovery.zen.ping.unicast.concurrent_connects", 10, 0, Setting.Property.NodeScope, Setting.Property.Deprecated);
    public static final Setting<TimeValue> LEGACY_DISCOVERY_ZEN_PING_UNICAST_HOSTS_RESOLVE_TIMEOUT = Setting.positiveTimeSetting("discovery.zen.ping.unicast.hosts.resolve_timeout", TimeValue.timeValueSeconds((long)5L), Setting.Property.NodeScope, Setting.Property.Deprecated);
    public static final Setting<Integer> DISCOVERY_SEED_RESOLVER_MAX_CONCURRENT_RESOLVERS_SETTING = Setting.intSetting("discovery.seed_resolver.max_concurrent_resolvers", 10, 0, Setting.Property.NodeScope);
    public static final Setting<TimeValue> DISCOVERY_SEED_RESOLVER_TIMEOUT_SETTING = Setting.positiveTimeSetting("discovery.seed_resolver.timeout", TimeValue.timeValueSeconds((long)5L), Setting.Property.NodeScope);
    private static final Logger logger = LogManager.getLogger(SeedHostsResolver.class);
    private final Settings settings;
    private final AtomicBoolean resolveInProgress = new AtomicBoolean();
    private final TransportService transportService;
    private final SeedHostsProvider hostsProvider;
    private final SetOnce<ExecutorService> executorService = new SetOnce();
    private final TimeValue resolveTimeout;
    private final String nodeName;
    private final int concurrentConnects;

    public SeedHostsResolver(String nodeName, Settings settings, TransportService transportService, SeedHostsProvider seedProvider) {
        this.settings = settings;
        this.nodeName = nodeName;
        this.transportService = transportService;
        this.hostsProvider = seedProvider;
        this.resolveTimeout = SeedHostsResolver.getResolveTimeout(settings);
        this.concurrentConnects = SeedHostsResolver.getMaxConcurrentResolvers(settings);
    }

    public static int getMaxConcurrentResolvers(Settings settings) {
        if (LEGACY_DISCOVERY_ZEN_PING_UNICAST_CONCURRENT_CONNECTS_SETTING.exists(settings)) {
            if (DISCOVERY_SEED_RESOLVER_MAX_CONCURRENT_RESOLVERS_SETTING.exists(settings)) {
                throw new IllegalArgumentException("it is forbidden to set both [" + DISCOVERY_SEED_RESOLVER_MAX_CONCURRENT_RESOLVERS_SETTING.getKey() + "] and [" + LEGACY_DISCOVERY_ZEN_PING_UNICAST_CONCURRENT_CONNECTS_SETTING.getKey() + "]");
            }
            return LEGACY_DISCOVERY_ZEN_PING_UNICAST_CONCURRENT_CONNECTS_SETTING.get(settings);
        }
        return DISCOVERY_SEED_RESOLVER_MAX_CONCURRENT_RESOLVERS_SETTING.get(settings);
    }

    public static TimeValue getResolveTimeout(Settings settings) {
        if (LEGACY_DISCOVERY_ZEN_PING_UNICAST_HOSTS_RESOLVE_TIMEOUT.exists(settings)) {
            if (DISCOVERY_SEED_RESOLVER_TIMEOUT_SETTING.exists(settings)) {
                throw new IllegalArgumentException("it is forbidden to set both [" + DISCOVERY_SEED_RESOLVER_TIMEOUT_SETTING.getKey() + "] and [" + LEGACY_DISCOVERY_ZEN_PING_UNICAST_HOSTS_RESOLVE_TIMEOUT.getKey() + "]");
            }
            return LEGACY_DISCOVERY_ZEN_PING_UNICAST_HOSTS_RESOLVE_TIMEOUT.get(settings);
        }
        return DISCOVERY_SEED_RESOLVER_TIMEOUT_SETTING.get(settings);
    }

    public static List<TransportAddress> resolveHostsLists(ExecutorService executorService, Logger logger, List<String> hosts, int limitPortCounts, TransportService transportService, TimeValue resolveTimeout) {
        List futures;
        Objects.requireNonNull(executorService);
        Objects.requireNonNull(logger);
        Objects.requireNonNull(hosts);
        Objects.requireNonNull(transportService);
        Objects.requireNonNull(resolveTimeout);
        if (resolveTimeout.nanos() < 0L) {
            throw new IllegalArgumentException("resolve timeout must be non-negative but was [" + resolveTimeout + "]");
        }
        List callables = hosts.stream().map(hn -> () -> transportService.addressesFromString((String)hn, limitPortCounts)).collect(Collectors.toList());
        try {
            futures = executorService.invokeAll(callables, resolveTimeout.nanos(), TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Collections.emptyList();
        }
        ArrayList<TransportAddress> transportAddresses = new ArrayList<TransportAddress>();
        HashSet<TransportAddress> localAddresses = new HashSet<TransportAddress>();
        localAddresses.add(transportService.boundAddress().publishAddress());
        localAddresses.addAll(Arrays.asList(transportService.boundAddress().boundAddresses()));
        Iterator<String> it = hosts.iterator();
        for (Future future : futures) {
            String hostname = it.next();
            if (!future.isCancelled()) {
                assert (future.isDone());
                try {
                    TransportAddress[] addresses = (TransportAddress[])future.get();
                    logger.trace("resolved host [{}] to {}", (Object)hostname, (Object)addresses);
                    for (int addressId = 0; addressId < addresses.length; ++addressId) {
                        TransportAddress address = addresses[addressId];
                        if (localAddresses.contains(address)) continue;
                        transportAddresses.add(address);
                    }
                    continue;
                }
                catch (ExecutionException e) {
                    assert (e.getCause() != null);
                    String message = "failed to resolve host [" + hostname + "]";
                    logger.warn(message, e.getCause());
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue;
                }
            }
            logger.warn("timed out after [{}] resolving host [{}]", (Object)resolveTimeout, (Object)hostname);
        }
        return Collections.unmodifiableList(transportAddresses);
    }

    @Override
    protected void doStart() {
        logger.debug("using max_concurrent_resolvers [{}], resolver timeout [{}]", (Object)this.concurrentConnects, (Object)this.resolveTimeout);
        ThreadFactory threadFactory = EsExecutors.daemonThreadFactory(this.settings, "[unicast_configured_hosts_resolver]");
        this.executorService.set((Object)EsExecutors.newScaling(this.nodeName + "/unicast_configured_hosts_resolver", 0, this.concurrentConnects, 60L, TimeUnit.SECONDS, threadFactory, this.transportService.getThreadPool().getThreadContext()));
    }

    @Override
    protected void doStop() {
        ThreadPool.terminate((ExecutorService)this.executorService.get(), 10L, TimeUnit.SECONDS);
    }

    @Override
    protected void doClose() {
    }

    @Override
    public void resolveConfiguredHosts(final Consumer<List<TransportAddress>> consumer) {
        if (!this.lifecycle.started()) {
            logger.debug("resolveConfiguredHosts: lifecycle is {}, not proceeding", (Object)this.lifecycle);
            return;
        }
        if (this.resolveInProgress.compareAndSet(false, true)) {
            this.transportService.getThreadPool().generic().execute(new AbstractRunnable(){

                @Override
                public void onFailure(Exception e) {
                    logger.debug("failure when resolving unicast hosts list", (Throwable)e);
                }

                @Override
                protected void doRun() {
                    if (!SeedHostsResolver.this.lifecycle.started()) {
                        logger.debug("resolveConfiguredHosts.doRun: lifecycle is {}, not proceeding", (Object)SeedHostsResolver.this.lifecycle);
                        return;
                    }
                    List<TransportAddress> providedAddresses = SeedHostsResolver.this.hostsProvider.getSeedAddresses((hosts, limitPortCounts) -> SeedHostsResolver.resolveHostsLists((ExecutorService)SeedHostsResolver.this.executorService.get(), logger, hosts, limitPortCounts, SeedHostsResolver.this.transportService, SeedHostsResolver.this.resolveTimeout));
                    consumer.accept(providedAddresses);
                }

                @Override
                public void onAfter() {
                    SeedHostsResolver.this.resolveInProgress.set(false);
                }

                public String toString() {
                    return "SeedHostsResolver resolving unicast hosts list";
                }
            });
        }
    }
}

