/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.V3;
import org.jmol.symmetry.CIPChirality;
import org.jmol.util.BSUtil;
import org.jmol.util.Logger;
import org.jmol.util.SimpleEdge;
import org.jmol.util.SimpleNode;
import org.jmol.viewer.Viewer;

public class CIPData {
    static final float TRIGONALITY_MIN = 0.2f;
    public boolean testRule6Full;
    Viewer vwr;
    SimpleNode[] atoms;
    BS bsAtoms;
    BS bsMolecule;
    BS bsAromatic;
    BS bsXAromatic = new BS();
    BS bsNegativeAromatic = new BS();
    BS bsAzacyclic;
    BS bsAtropisomeric = new BS();
    BS bsHelixM;
    BS bsHelixP;
    BS[] lstSmallRings;
    BS bsKekuleAmbiguous = new BS();
    BS bsEnes = new BS();
    protected V3 vNorm = new V3();
    protected V3 vTemp = new V3();

    protected boolean isTracker() {
        return false;
    }

    boolean isSmiles() {
        return false;
    }

    public CIPData set(Viewer viewer, BS bS) {
        this.vwr = viewer;
        this.atoms = viewer.ms.at;
        this.bsAtoms = bS;
        this.bsMolecule = viewer.ms.getMoleculeBitSet(bS);
        this.init();
        return this;
    }

    protected void init() {
        try {
            BS bS = this.match("[r]");
            this.lstSmallRings = bS.isEmpty() ? new BS[0] : this.getList("*1**1||*1***1||*1****1||*1*****1||*1******1");
            this.bsAromatic = this.match("a");
            if (!this.bsAromatic.isEmpty()) {
                this.bsAtropisomeric = this.match("[!H](.t1:-20,20)a{a(.t2:-20,20)-a}a[!H]");
                this.bsHelixM = this.match("A{a}(.t:-10,-40)a(.t:-10,-40)aaa");
                this.bsHelixP = this.match("A{a}(.t:10,40)a(.t:10,40)aaa");
                this.bsXAromatic = this.match("[r5v3n+0,r5v2o+0]");
                this.bsNegativeAromatic = this.match("[a-]");
                if (!this.match("[n+1,o+1]").isEmpty() && !this.bsXAromatic.isEmpty()) {
                    this.bsKekuleAmbiguous.or(this.match("a1[n+,o+]a[n,o]a1"));
                    this.bsKekuleAmbiguous.or(this.match("a1[n+,o+][n,o]aa1"));
                }
                if (!this.bsNegativeAromatic.isEmpty()) {
                    this.bsKekuleAmbiguous.or(this.match("a1=a[a-]a=a1"));
                }
                BS[] bSArray = this.getList("a1aaaaa1");
                int n = bSArray.length;
                while (--n >= 0) {
                    this.bsKekuleAmbiguous.or(bSArray[n]);
                }
            }
            this.getAzacyclic();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected BS[] getList(String string) throws Exception {
        int n = Logger.getLogLevel();
        Logger.setLogLevel(Math.min(n, 4));
        BS[] bSArray = this.vwr.getSubstructureSetArray(string, this.bsMolecule, 2);
        Logger.setLogLevel(n);
        return bSArray;
    }

    protected BS match(String string) throws Exception {
        int n = Logger.getLogLevel();
        Logger.setLogLevel(Math.min(n, 4));
        BS bS = this.vwr.getSmartsMatch(string, this.bsMolecule);
        Logger.setLogLevel(n);
        return bS;
    }

    void getEneKekule() {
        if (this.bsEnes.cardinality() < 8) {
            return;
        }
        BS bS = (BS)this.bsEnes.clone();
        BS bS2 = new BS();
        this.bsEnes.andNot(this.bsKekuleAmbiguous);
        BS bS3 = new BS();
        int n = this.bsEnes.nextSetBit(0);
        while (n >= 0) {
            bS2.clearAll();
            bS3.clearAll();
            this.checkEne(bS, bS2, -1, n, 2, bS3);
            n = this.bsEnes.nextSetBit(n + 1);
        }
    }

    private int checkEne(BS bS, BS bS2, int n, int n2, int n3, BS bS3) {
        if (bS2.get(n2)) {
            return bS3.get(n2) == (n3 == 2) ? n2 : -1;
        }
        bS2.set(n2);
        SimpleNode simpleNode = this.atoms[n2];
        int n4 = -1;
        SimpleEdge[] simpleEdgeArray = simpleNode.getEdges();
        if (n3 == 2) {
            bS3.set(n2);
        }
        int n5 = simpleNode.getBondCount();
        while (--n5 >= 0) {
            SimpleNode simpleNode2;
            int n6;
            if (this.getBondOrder(simpleEdgeArray[n5]) != n3 || (n6 = (simpleNode2 = simpleEdgeArray[n5].getOtherNode(simpleNode)).getIndex()) == n || !bS.get(n6)) continue;
            n4 = this.checkEne(bS, bS2, n2, n6, 3 - n3, bS3);
        }
        if (n4 >= 0) {
            this.bsKekuleAmbiguous.set(n2);
            this.bsEnes.clear(n2);
        }
        return n4 == n2 ? -1 : n4;
    }

    private void getAzacyclic() {
        int n = this.bsAtoms.nextSetBit(0);
        while (n >= 0) {
            block11: {
                SimpleNode simpleNode = this.atoms[n];
                if (simpleNode.getElementNumber() == 7 && simpleNode.getCovalentBondCount() == 3 && !this.bsKekuleAmbiguous.get(n)) {
                    BS bS;
                    SimpleEdge[] simpleEdgeArray = simpleNode.getEdges();
                    int n2 = simpleEdgeArray.length;
                    while (--n2 >= 0) {
                        if (simpleEdgeArray[n2].getOtherNode(simpleNode).getElementNumber() != 1) {
                            continue;
                        }
                        break block11;
                    }
                    Lst<BS> lst = new Lst<BS>();
                    int n3 = this.lstSmallRings.length;
                    while (--n3 >= 0) {
                        bS = this.lstSmallRings[n3];
                        if (!bS.get(n)) continue;
                        lst.addLast(bS);
                        if (n3 != 0) continue;
                        this.addAzacyclicN(n);
                        break block11;
                    }
                    n3 = lst.size();
                    if (n3 >= 2) {
                        bS = new BS();
                        SimpleEdge[] simpleEdgeArray2 = simpleNode.getEdges();
                        int n4 = simpleEdgeArray2.length;
                        while (--n4 >= 0) {
                            if (!simpleEdgeArray2[n4].isCovalent()) continue;
                            bS.set(simpleEdgeArray2[n4].getOtherNode(simpleNode).getIndex());
                        }
                        BS bS2 = new BS();
                        BS bS3 = new BS();
                        int n5 = 0;
                        block4: while (n5 < n3 - 1) {
                            BS bS4 = (BS)lst.get(n5);
                            int n6 = n5 + 1;
                            while (n6 < n3) {
                                BS bS5 = (BS)lst.get(n6);
                                BSUtil.copy2(bS4, bS2);
                                bS2.and(bS5);
                                if (bS2.cardinality() > 2) {
                                    BSUtil.copy2(bS4, bS3);
                                    bS3.or(bS5);
                                    bS3.and(bS);
                                    if (bS3.cardinality() == 3) {
                                        this.addAzacyclicN(n);
                                        break block4;
                                    }
                                }
                                ++n6;
                            }
                            ++n5;
                        }
                    }
                }
            }
            n = this.bsAtoms.nextSetBit(n + 1);
        }
    }

    private void addAzacyclicN(int n) {
        if (this.bsAzacyclic == null) {
            this.bsAzacyclic = new BS();
        }
        this.bsAzacyclic.set(n);
    }

    boolean couldBeChiralAtom(SimpleNode simpleNode) {
        boolean bl = false;
        block0 : switch (simpleNode.getCovalentBondCount()) {
            default: {
                System.out.println("?? too many bonds! " + simpleNode);
                return false;
            }
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                return simpleNode.getElementNumber() == 7;
            }
            case 3: {
                switch (simpleNode.getElementNumber()) {
                    case 7: {
                        if (this.bsAzacyclic != null && this.bsAzacyclic.get(simpleNode.getIndex())) break block0;
                        return false;
                    }
                    case 6: {
                        bl = true;
                        break block0;
                    }
                    case 15: 
                    case 16: 
                    case 33: 
                    case 34: 
                    case 51: 
                    case 52: 
                    case 83: 
                    case 84: {
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                    default: {
                        return false;
                    }
                }
            }
            case 4: 
        }
        SimpleEdge[] simpleEdgeArray = simpleNode.getEdges();
        int n = 0;
        boolean bl2 = false;
        int n2 = simpleEdgeArray.length;
        while (--n2 >= 0) {
            if (bl && simpleEdgeArray[n2].getCovalentOrder() == 2) {
                bl2 = true;
            }
            if (simpleEdgeArray[n2].getOtherNode(simpleNode).getIsotopeNumber() != 1) continue;
            ++n;
        }
        return n < 2 && (bl2 || this.isSmiles() || bl == Math.abs(this.getTrigonality(simpleNode, this.vNorm)) < 0.2f);
    }

    int couldBeChiralAlkene(SimpleNode simpleNode, SimpleEdge simpleEdge) {
        SimpleNode simpleNode2 = simpleEdge == null ? null : simpleEdge.getOtherNode(simpleNode);
        switch (simpleNode.getCovalentBondCount()) {
            default: {
                return -1;
            }
            case 2: {
                if (simpleNode.getElementNumber() == 7) break;
                return -1;
            }
            case 3: {
                if (CIPChirality.isFirstRow(simpleNode)) break;
                return -1;
            }
        }
        SimpleEdge[] simpleEdgeArray = simpleNode.getEdges();
        int n = 0;
        int n2 = simpleEdgeArray.length;
        while (--n2 >= 0) {
            if (this.getBondOrder(simpleEdgeArray[n2]) != 2) continue;
            if (++n > 1) {
                return 17;
            }
            SimpleNode simpleNode3 = simpleEdgeArray[n2].getOtherNode(simpleNode);
            if (!CIPChirality.isFirstRow(simpleNode3)) {
                return -1;
            }
            if (simpleNode2 == null || simpleNode3 == simpleNode2 && simpleNode2.getCovalentBondCount() != 1) continue;
            return -1;
        }
        return 13;
    }

    float getTrigonality(SimpleNode simpleNode, V3 v3) {
        int n;
        P3[] p3Array = new P3[4];
        SimpleEdge[] simpleEdgeArray = simpleNode.getEdges();
        int n2 = n = simpleEdgeArray.length;
        int n3 = 0;
        while (--n2 >= 0 && n3 < 4) {
            if (!simpleEdgeArray[n2].isCovalent()) continue;
            p3Array[n3++] = simpleEdgeArray[n2].getOtherNode(simpleNode).getXYZ();
        }
        P4 p4 = Measure.getPlaneThroughPoints(p3Array[0], p3Array[1], p3Array[2], v3, this.vTemp, new P4());
        return Measure.distanceToPlane(p4, p3Array[3] == null ? simpleNode.getXYZ() : p3Array[3]);
    }

    int isCis(CIPChirality.CIPAtom cIPAtom, CIPChirality.CIPAtom cIPAtom2, CIPChirality.CIPAtom cIPAtom3, CIPChirality.CIPAtom cIPAtom4) {
        Measure.getNormalThroughPoints(cIPAtom.atom.getXYZ(), cIPAtom2.atom.getXYZ(), cIPAtom3.atom.getXYZ(), this.vNorm, this.vTemp);
        V3 v3 = new V3();
        Measure.getNormalThroughPoints(cIPAtom2.atom.getXYZ(), cIPAtom3.atom.getXYZ(), cIPAtom4.atom.getXYZ(), v3, this.vTemp);
        return this.vNorm.dot(v3) > 0.0f ? 13 : 14;
    }

    int isPositiveTorsion(CIPChirality.CIPAtom cIPAtom, CIPChirality.CIPAtom cIPAtom2, CIPChirality.CIPAtom cIPAtom3, CIPChirality.CIPAtom cIPAtom4) {
        float f = Measure.computeTorsion(cIPAtom.atom.getXYZ(), cIPAtom2.atom.getXYZ(), cIPAtom3.atom.getXYZ(), cIPAtom4.atom.getXYZ(), true);
        return f > 0.0f ? 18 : 17;
    }

    int getBondOrder(SimpleEdge simpleEdge) {
        return simpleEdge.getCovalentOrder();
    }

    boolean setCoord(SimpleNode simpleNode, CIPChirality.CIPAtom[] cIPAtomArray) {
        return true;
    }

    int checkHandedness(CIPChirality.CIPAtom cIPAtom) {
        CIPChirality.CIPAtom[] cIPAtomArray = cIPAtom.atoms;
        if (!this.setCoord(cIPAtom.atom, cIPAtomArray)) {
            return 0;
        }
        P3 p3 = (cIPAtomArray[3].atom == null ? cIPAtom.atom : cIPAtomArray[3].atom).getXYZ();
        P3 p32 = cIPAtomArray[0].atom.getXYZ();
        P3 p33 = cIPAtomArray[1].atom.getXYZ();
        P3 p34 = cIPAtomArray[2].atom.getXYZ();
        Measure.getNormalThroughPoints(p32, p33, p34, this.vNorm, this.vTemp);
        this.vTemp.setT(p3);
        this.vTemp.sub(p32);
        return this.vTemp.dot(this.vNorm) > 0.0f ? 1 : 2;
    }

    void track(CIPChirality cIPChirality, CIPChirality.CIPAtom cIPAtom, CIPChirality.CIPAtom cIPAtom2, int n, int n2, boolean bl) {
    }

    String getRootTrackerResult(CIPChirality.CIPAtom cIPAtom) {
        return null;
    }

    public void setRule6Full(boolean bl) {
        this.testRule6Full = bl;
    }
}

