/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericImageEncoder;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.api.Interface;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

abstract class OutputManager {
    protected Viewer vwr;
    protected double privateKey;
    protected static final String SCENE_TAG = "###scene.spt###";

    OutputManager() {
    }

    protected abstract String getLogPath(String var1);

    abstract String clipImageOrPasteText(String var1);

    abstract String getClipboardText();

    abstract OC openOutputChannel(double var1, String var3, boolean var4, boolean var5) throws IOException;

    protected abstract String createSceneSet(String var1, String var2, int var3, int var4);

    OutputManager setViewer(Viewer viewer, double d) {
        this.vwr = viewer;
        this.privateKey = d;
        return this;
    }

    private String writeToOutputChannel(Map<String, Object> map) {
        String string;
        int n;
        int n2;
        String string2;
        String string3;
        block16: {
            string3 = (String)map.get("type");
            string2 = (String)map.get("fileName");
            String string4 = (String)map.get("text");
            byte[] byArray = (byte[])map.get("bytes");
            n2 = OutputManager.getInt(map, "quality", Integer.MIN_VALUE);
            OC oC = (OC)map.get("outputChannel");
            boolean bl = oC == null;
            n = -1;
            string = null;
            try {
                if (!this.vwr.checkPrivateKey(this.privateKey)) {
                    return "ERROR: SECURITY";
                }
                if (byArray != null) {
                    if (oC == null) {
                        oC = this.openOutputChannel(this.privateKey, string2, false, false);
                    }
                    oC.write(byArray, 0, byArray.length);
                    break block16;
                }
                if (string4 != null && !string3.equals("ZIPDATA") && !string3.equals("BINARY")) {
                    if (oC == null) {
                        oC = this.openOutputChannel(this.privateKey, string2, true, false);
                    }
                    oC.append(string4);
                    break block16;
                }
                String string5 = (String)this.getOrSaveImage(map);
                if (string5 != null) {
                    String string6 = string5;
                    return string6;
                }
                try {
                    n = (Integer)map.get("byteCount");
                }
                catch (Exception exception) {
                    Logger.errorEx("IO Exception", exception);
                    String string7 = exception.toString();
                    return string7;
                }
            }
            finally {
                if (oC != null) {
                    if (bl) {
                        string = oC.closeChannel();
                    }
                    n = oC.getByteCount();
                }
            }
        }
        int n3 = string2.indexOf("?POST?");
        if (n3 >= 0) {
            string2 = string2.substring(0, n3);
        }
        return n < 0 ? "Creation of " + string2 + " failed: " + (string == null ? this.vwr.getErrorMessageUn() : string) : "OK " + string3 + " " + (n > 0 ? String.valueOf(n) + " " : "") + string2 + (n2 == Integer.MIN_VALUE ? "" : "; quality=" + n2);
    }

    /*
     * Unable to fully structure code
     */
    private Object getOrSaveImage(Map<String, Object> var1_1) throws Exception {
        block40: {
            block41: {
                block43: {
                    block42: {
                        block38: {
                            block39: {
                                block36: {
                                    block37: {
                                        block34: {
                                            block35: {
                                                var2_2 = null;
                                                var3_3 = null;
                                                var4_4 = ((String)var1_1.get("type")).toUpperCase();
                                                var5_5 = (String)var1_1.get("fileName");
                                                var6_6 = (String[])var1_1.get("scripts");
                                                var7_7 = var1_1.get("image");
                                                var8_8 = (int[])var1_1.get("rgbbuf");
                                                var9_9 = (OC)var1_1.get("outputChannel");
                                                var10_10 = var9_9 == null && var5_5 == null;
                                                var11_11 = var9_9 == null && var5_5 != null;
                                                v0 = var12_12 = var7_7 == null;
                                                var13_13 = var4_4.equals("BINARY") != false || var4_4.equals("ZIPDATA") != false ? "" : (var8_8 != null ? (Object)var8_8 : (var7_7 != null ? var7_7 : this.vwr.getScreenImageBuffer(null, true)));
                                                var14_14 = false;
                                                try {
                                                    if (var13_13 != null) break block34;
                                                    var20_15 = var3_3 = this.vwr.getErrorMessage();
                                                    if (var12_12) {
                                                        this.vwr.releaseScreenImage();
                                                    }
                                                    if (var2_2 == null && var9_9 == null) break block35;
                                                    var1_1.put("byteCount", var2_2 != null ? var2_2.length : (var14_14 != false ? var9_9.getByteCount() : -1));
                                                }
                                                catch (Throwable var19_24) {
                                                    if (var12_12) {
                                                        this.vwr.releaseScreenImage();
                                                    }
                                                    if (var2_2 != null || var9_9 != null) {
                                                        var1_1.put("byteCount", var2_2 != null ? var2_2.length : (var14_14 != false ? var9_9.getByteCount() : -1));
                                                    }
                                                    if (var7_7 != null) {
                                                        return var5_5;
                                                    }
                                                    throw var19_24;
                                                }
                                            }
                                            if (var7_7 != null) {
                                                return var5_5;
                                            }
                                            return var20_15;
                                        }
                                        if (var5_5 == null || !var5_5.startsWith("\u0001")) break block36;
                                        var14_14 = true;
                                        var15_19 = new Hashtable<String, String>();
                                        var15_19.put("_IMAGE_", var13_13);
                                        this.vwr.fm.loadImage(var15_19, var5_5, false);
                                        var20_16 = var3_3 = "OK - viewing " + var5_5.substring(1);
                                        if (var12_12) {
                                            this.vwr.releaseScreenImage();
                                        }
                                        if (var2_2 == null && var9_9 == null) break block37;
                                        var1_1.put("byteCount", var2_2 != null ? var2_2.length : (var14_14 != false ? var9_9.getByteCount() : -1));
                                    }
                                    if (var7_7 != null) {
                                        return var5_5;
                                    }
                                    return var20_16;
                                }
                                var15_20 = var4_4.equals("PNGJ");
                                if (var15_20) ** GOTO lbl73
                                if (var9_9 != null || (var9_9 = this.openOutputChannel(this.privateKey, var5_5, false, false)) != null) break block38;
                                var3_3 = "ERROR: canceled";
                                var20_17 = "ERROR: canceled";
                                if (var12_12) {
                                    this.vwr.releaseScreenImage();
                                }
                                if (var2_2 == null && var9_9 == null) break block39;
                                var1_1.put("byteCount", var2_2 != null ? var2_2.length : (var14_14 != false ? var9_9.getByteCount() : -1));
                            }
                            if (var7_7 != null) {
                                return var5_5;
                            }
                            return var20_17;
                        }
                        var5_5 = var9_9.getFileName();
lbl73:
                        // 2 sources

                        var16_21 = null;
                        var17_22 = null;
                        var1_1.put("date", this.vwr.apiPlatform.getDateFormat("8601"));
                        if (!var4_4.startsWith("JP")) break block42;
                        if ((var4_4 = PT.rep(var4_4, "E", "")).equals("JPG64")) {
                            var1_1.put("outputChannelTemp", this.getOutputChannel(null, null));
                            var16_21 = "";
                        } else {
                            var16_21 = var10_10 == false ? (String)this.getWrappedState(null, null, var13_13, null) : "";
                        }
                        var1_1.put("jpgAppTag", " #Jmol...\u0000");
                        ** GOTO lbl120
                    }
                    if (!var4_4.equals("PDF")) break block43;
                    var16_21 = "";
                    ** GOTO lbl120
                }
                if (!var4_4.startsWith("PNG")) ** GOTO lbl120
                var16_21 = "";
                if (!var15_20) break block40;
                var18_23 = this.getOutputChannel(null, null);
                this.getWrappedState(var5_5, var6_6, var13_13, (OC)var18_23);
                var17_22 = var18_23.toByteArray();
                if (var9_9 != null || (var9_9 = this.openOutputChannel(this.privateKey, var5_5, false, false)) != null) ** GOTO lbl115
                var3_3 = "ERROR: canceled";
                var20_18 = "ERROR: canceled";
                if (var12_12) {
                    this.vwr.releaseScreenImage();
                }
                if (var2_2 == null && var9_9 == null) break block41;
                var1_1.put("byteCount", var2_2 != null ? var2_2.length : (var14_14 != false ? var9_9.getByteCount() : -1));
            }
            if (var7_7 != null) {
                return var5_5;
            }
            return var20_18;
        }
        if (var8_8 == null && !var10_10 && !var1_1.containsKey("captureMode")) {
            var17_22 = ((String)this.getWrappedState(null, var6_6, var13_13, null)).getBytes();
        }
lbl115:
        // 4 sources

        if (var17_22 != null) {
            var1_1.put("pngAppData", var17_22);
            var1_1.put("pngAppPrefix", "Jmol Type");
        }
lbl120:
        // 6 sources

        if (var4_4.equals("PNGT") || var4_4.equals("GIFT")) {
            var1_1.put("transparentColor", this.vwr.getBackgroundArgb());
        }
        if (var4_4.length() == 4) {
            var4_4 = var4_4.substring(0, 3);
        }
        if (var16_21 != null) {
            var1_1.put("comment", var16_21.length() == 0 ? Viewer.getJmolVersion() : var16_21);
        }
        var18_23 = new String[1];
        var14_14 = this.createTheImage(var13_13, var4_4, var9_9, var1_1, var18_23);
        if (var11_11) {
            var9_9.closeChannel();
        }
        if (var14_14) {
            if (var1_1.containsKey("captureMsg") && !var1_1.containsKey("captureSilent")) {
                this.vwr.prompt((String)var1_1.get("captureMsg"), "OK", null, true);
            }
            if (var10_10) {
                var2_2 = var9_9.toByteArray();
            } else if (var1_1.containsKey("captureByteCount")) {
                var3_3 = "OK: " + var1_1.get("captureByteCount").toString() + " bytes";
            }
        } else {
            var3_3 = var18_23[0];
        }
        if (var12_12) {
            this.vwr.releaseScreenImage();
        }
        if (var2_2 != null || var9_9 != null) {
            var1_1.put("byteCount", var2_2 != null ? var2_2.length : (var14_14 != false ? var9_9.getByteCount() : -1));
        }
        if (var7_7 != null) {
            return var5_5;
        }
        return var3_3 == null ? var2_2 : (byte[])var3_3;
    }

    Object getWrappedState(String string, String[] stringArray, Object object, OC oC) {
        int n = this.vwr.apiPlatform.getImageWidth(object);
        int n2 = this.vwr.apiPlatform.getImageHeight(object);
        if (n > 0 && !this.vwr.g.imageState && oC == null || !this.vwr.g.preserveState) {
            return "";
        }
        String string2 = this.vwr.getStateInfo3(null, n, n2);
        if (oC != null) {
            return this.createZipSet(string2, stringArray, true, oC, string);
        }
        try {
            string2 = JC.embedScript(FileManager.setScriptFileReferences(string2, ".", null, null));
        }
        catch (Throwable throwable) {
            Logger.error("state could not be saved: " + throwable.toString());
            string2 = "Jmol " + Viewer.getJmolVersion();
        }
        return string2;
    }

    private boolean createTheImage(Object object, String string, OC oC, Map<String, Object> map, String[] stringArray) {
        block16: {
            Object object2;
            boolean bl = (string = String.valueOf(string.substring(0, 1)) + string.substring(1).toLowerCase()).equals("Zipdata");
            if (bl || string.equals("Binary")) {
                object2 = (Lst)map.get("imageData");
                if (((ArrayList)object2).size() >= 2 && ((ArrayList)object2).get(0).equals("_IMAGE_")) {
                    if (bl) {
                        stringArray[0] = this.writeZipFile(oC, (Lst<Object>)object2, "OK JMOL", null);
                        return true;
                    }
                    object = null;
                    ((Lst)object2).removeItemAt(0);
                    ((Lst)object2).removeItemAt(0);
                    map.put("pngImgData", ((Lst)object2).removeItemAt(0));
                    OC oC2 = this.getOutputChannel(null, null);
                    stringArray[0] = this.writeZipFile(oC2, (Lst<Object>)object2, "OK JMOL", null);
                    map.put("type", "PNGJ");
                    string = "Png";
                    map.put("pngAppPrefix", "Jmol Type");
                    map.put("pngAppData", oC2.toByteArray());
                } else {
                    if (((ArrayList)object2).size() == 1) {
                        byte[] byArray = (byte[])((Lst)object2).removeItemAt(0);
                        oC.write(byArray, 0, byArray.length);
                        return true;
                    }
                    stringArray[0] = this.writeZipFile(oC, (Lst<Object>)object2, "OK JMOL", null);
                    return true;
                }
            }
            if ((object2 = (GenericImageEncoder)Interface.getInterface("javajs.img." + string + "Encoder", this.vwr, "file")) == null) {
                stringArray[0] = "Image encoder type " + string + " not available";
                return false;
            }
            boolean bl2 = true;
            try {
                try {
                    int n;
                    if (string.equals("Gif") && this.vwr.getBoolean(603979962)) {
                        map.put("reducedColors", Boolean.TRUE);
                    }
                    int n2 = object == null ? -1 : (n = AU.isAI(object) ? ((Integer)map.get("width")).intValue() : this.vwr.apiPlatform.getImageWidth(object));
                    int n3 = object == null ? -1 : (AU.isAI(object) ? ((Integer)map.get("height")).intValue() : this.vwr.apiPlatform.getImageHeight(object));
                    map.put("imageWidth", n);
                    map.put("imageHeight", n3);
                    int[] nArray = this.encodeImage(n, n3, object);
                    if (nArray != null) {
                        map.put("imagePixels", nArray);
                    }
                    map.put("logging", Logger.debugging);
                    bl2 = object2.createImage(string, oC, map);
                }
                catch (Exception exception) {
                    stringArray[0] = exception.toString();
                    oC.cancel();
                    bl2 = true;
                    if (bl2) {
                        oC.closeChannel();
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (bl2) {
                    oC.closeChannel();
                }
                throw throwable;
            }
            if (bl2) {
                oC.closeChannel();
            }
        }
        return stringArray[0] == null;
    }

    private int[] encodeImage(int n, int n2, Object object) throws Exception {
        int[] nArray;
        if (n < 0) {
            return null;
        }
        if (AU.isAI(object)) {
            nArray = (int[])object;
        } else {
            nArray = new int[n * n2];
            nArray = this.vwr.apiPlatform.grabPixels(object, n, n2, nArray, 0, n2);
        }
        return nArray;
    }

    String outputToFile(Map<String, Object> map) {
        return this.handleOutputToFile(map, true);
    }

    OC getOutputChannel(String string, String[] stringArray) {
        boolean bl;
        if (!this.vwr.haveAccess(Viewer.ACCESS.ALL)) {
            return null;
        }
        boolean bl2 = bl = string != null && string.startsWith("cache://");
        if (string != null && !bl && (string = this.getOutputFileNameFromDialog(string, Integer.MIN_VALUE, null)) == null) {
            return null;
        }
        if (stringArray != null) {
            stringArray[0] = string;
        }
        String string2 = OC.isLocal(string) || bl ? string : null;
        try {
            return this.openOutputChannel(this.privateKey, string2, false, false);
        }
        catch (IOException iOException) {
            Logger.info(iOException.toString());
            return null;
        }
    }

    String processWriteOrCapture(Map<String, Object> map) {
        String string = (String)map.get("fileName");
        if (string == null) {
            return this.vwr.clipImageOrPasteText((String)map.get("text"));
        }
        BS bS = (BS)map.get("bsFrames");
        int n = OutputManager.getInt(map, "nVibes", 0);
        return bS != null || n != 0 ? this.processMultiFrameOutput(string, bS, n, map) : this.handleOutputToFile(map, true);
    }

    private static int getInt(Map<String, Object> map, String string, int n) {
        Integer n2 = (Integer)map.get(string);
        return n2 == null ? n : n2;
    }

    private String processMultiFrameOutput(String string, BS bS, int n, Map<String, Object> map) {
        String string2 = "";
        int n2 = 0;
        int n3 = OutputManager.getInt(map, "quality", -1);
        if ((string = this.setFullPath(map, this.getOutputFileNameFromDialog(string, n3, null))) == null) {
            return null;
        }
        String[] stringArray = new String[2];
        OutputManager.getRootExt(string, stringArray, 0);
        SB sB = new SB();
        if (bS == null) {
            this.vwr.tm.vibrationOn = true;
            sB = new SB();
            int n4 = 0;
            while (n4 < n) {
                int n5 = 0;
                while (n5 < 20) {
                    this.vwr.tm.setVibrationT((float)n5 / 20.0f + 0.2501f);
                    if (!this.writeFrame(++n2, stringArray, map, sB)) {
                        return "ERROR WRITING FILE SET: \n" + string2;
                    }
                    ++n5;
                }
                ++n4;
            }
            this.vwr.tm.setVibrationPeriod(0.0f);
        } else {
            int n6 = bS.nextSetBit(0);
            while (n6 >= 0) {
                this.vwr.setCurrentModelIndex(n6);
                if (!this.writeFrame(++n2, stringArray, map, sB)) {
                    return "ERROR WRITING FILE SET: \n" + string2;
                }
                n6 = bS.nextSetBit(n6 + 1);
            }
        }
        if (string2.length() == 0) {
            string2 = "OK\n";
        }
        return String.valueOf(string2) + "\n" + n2 + " files created";
    }

    private static Object getRootExt(String string, String[] stringArray, int n) {
        String string2;
        if (string == null) {
            string = "0000" + n;
            return String.valueOf(stringArray[0]) + string.substring(string.length() - 4) + stringArray[1];
        }
        int n2 = string.lastIndexOf(".");
        if (n2 < 0) {
            n2 = string.length();
        }
        if ((string2 = string.substring(0, n2)).endsWith("0")) {
            string2 = PT.trim(string2, "0");
        }
        stringArray[0] = string2;
        stringArray[1] = string.substring(n2);
        return stringArray;
    }

    private String setFullPath(Map<String, Object> map, String string) {
        String[] stringArray = (String[])map.get("fullPath");
        if (stringArray != null) {
            stringArray[0] = string;
        }
        if (string == null) {
            return null;
        }
        map.put("fileName", string);
        return string;
    }

    String getOutputFromExport(Map<String, Object> map) {
        int n = OutputManager.getInt(map, "width", 0);
        int n2 = OutputManager.getInt(map, "height", 0);
        String string = (String)map.get("fileName");
        if (string != null && (string = this.setFullPath(map, this.getOutputFileNameFromDialog(string, Integer.MIN_VALUE, null))) == null) {
            return null;
        }
        this.vwr.mustRender = true;
        int n3 = this.vwr.dimScreen.width;
        int n4 = this.vwr.dimScreen.height;
        this.vwr.resizeImage(n, n2, true, true, false);
        this.vwr.setModelVisibility();
        String string2 = this.vwr.rm.renderExport(this.vwr.gdata, this.vwr.ms, map);
        this.vwr.resizeImage(n3, n4, true, true, true);
        return string2;
    }

    byte[] getImageAsBytes(String string, int n, int n2, int n3, String[] stringArray) {
        int n4 = this.vwr.dimScreen.width;
        int n5 = this.vwr.dimScreen.height;
        this.vwr.mustRender = true;
        this.vwr.resizeImage(n, n2, true, false, false);
        this.vwr.setModelVisibility();
        this.vwr.creatingImage = true;
        byte[] byArray = null;
        try {
            Object object;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("type", string);
            if (n3 > 0) {
                hashtable.put("quality", n3);
            }
            if ((object = this.getOrSaveImage(hashtable)) instanceof String) {
                stringArray[0] = (String)object;
            } else {
                byArray = (byte[])object;
            }
        }
        catch (Exception exception) {
            stringArray[0] = exception.toString();
            this.vwr.setErrorMessage("Error creating image: " + exception, null);
        }
        catch (Error error) {
            this.vwr.handleError(error, false);
            this.vwr.setErrorMessage("Error creating image: " + error, null);
            stringArray[0] = this.vwr.getErrorMessage();
        }
        this.vwr.creatingImage = false;
        this.vwr.resizeImage(n4, n5, true, false, true);
        return byArray;
    }

    String writeFileData(String string, String string2, int n, Object[] objectArray) {
        boolean bl;
        String[] stringArray = new String[1];
        OC oC = this.getOutputChannel(string, stringArray);
        if (oC == null) {
            return "";
        }
        string = stringArray[0];
        String string3 = string2.equals("FILE") ? this.vwr.fm.getFullPathName(false) : null;
        boolean bl2 = string3 != null && (string3.equals("string") || string3.equals("String[]") || string3.equals("JSNode"));
        boolean bl3 = bl = string3 != null && !bl2;
        if (bl && (string3 = this.vwr.getModelSetPathName()) == null) {
            return null;
        }
        oC.setType(string2);
        String string4 = string2.startsWith("PDB") ? this.vwr.getPdbAtomData(null, oC, false, false) : (string2.startsWith("PLOT") ? this.vwr.getPdbData(n, string2.substring(5), null, objectArray, oC, true) : (bl2 ? oC.append(this.vwr.getCurrentFileAsString("write")).toString() : (String)this.vwr.fm.getFileAsBytes(string3, oC)));
        oC.closeChannel();
        if (string4 != null) {
            string4 = "OK " + string4 + " " + string;
        }
        return string4;
    }

    private boolean writeFrame(int n, String[] stringArray, Map<String, Object> map, SB sB) {
        String string = (String)OutputManager.getRootExt(null, stringArray, n);
        if ((string = this.setFullPath(map, string)) == null) {
            return false;
        }
        String string2 = this.handleOutputToFile(map, false);
        this.vwr.scriptEcho(string2);
        sB.append(string2).append("\n");
        return string2.startsWith("OK");
    }

    private String getOutputFileNameFromDialog(String string, int n, Map<String, Object> map) {
        if (string == null || this.vwr.isKiosk) {
            return null;
        }
        boolean bl = string.startsWith("?");
        if (bl) {
            string = string.substring(1);
        }
        boolean bl2 = this.vwr.isApplet && string.indexOf("http:") < 0;
        string = FileManager.getLocalPathForWritingFile(this.vwr, string);
        if (bl |= bl2) {
            string = this.vwr.dialogAsk(n == Integer.MIN_VALUE ? "Save" : "Save Image", string, map);
        }
        return string;
    }

    protected String handleOutputToFile(Map<String, Object> map, boolean bl) {
        boolean bl2;
        String string = (String)map.get("fileName");
        OC oC = (OC)map.get("outputChannel");
        if (string == null && oC == null) {
            return null;
        }
        String string2 = null;
        String string3 = (String)map.get("type");
        String string4 = (String)map.get("text");
        int n = OutputManager.getInt(map, "width", 0);
        int n2 = OutputManager.getInt(map, "height", 0);
        int n3 = 0;
        int n4 = 0;
        int n5 = OutputManager.getInt(map, "quality", Integer.MIN_VALUE);
        String string5 = (String)map.get("captureMode");
        String string6 = null;
        if (string5 != null && !this.vwr.allowCapture()) {
            return "ERROR: Cannot capture on this platform.";
        }
        boolean bl3 = bl2 = n5 != Integer.MIN_VALUE;
        if (string5 != null) {
            bl = false;
            bl2 = false;
        }
        if (oC == null) {
            if (!string.startsWith("\u0001")) {
                if (bl) {
                    string = this.getOutputFileNameFromDialog(string, n5, map);
                }
                string = this.setFullPath(map, string);
            }
            if (string == null) {
                return null;
            }
            map.put("fileName", string);
            if (OC.isLocal(string)) {
                string6 = string;
            }
            n3 = this.vwr.dimScreen.width;
            n4 = this.vwr.dimScreen.height;
            this.vwr.creatingImage = true;
            if (bl2) {
                this.vwr.mustRender = true;
                this.vwr.resizeImage(n, n2, true, false, false);
                this.vwr.setModelVisibility();
            }
        }
        try {
            try {
                if (string3.equals("JMOL")) {
                    string3 = "ZIPALL";
                }
                if (string3.equals("ZIP") || string3.equals("ZIPALL")) {
                    String[] stringArray = (String[])map.get("scripts");
                    if (stringArray != null && string3.equals("ZIP")) {
                        string3 = "ZIPALL";
                    }
                    string2 = this.createZipSet(string4, stringArray, string3.equals("ZIPALL"), oC == null ? this.getOutputChannel(string, null) : oC, null);
                } else if (string3.equals("SCENE")) {
                    string2 = this.createSceneSet(string, string4, n, n2);
                } else {
                    byte[] byArray = (byte[])map.get("bytes");
                    string2 = this.vwr.sm.createImage(string, string3, string4, byArray, n5);
                    if (string2 == null) {
                        boolean bl4 = true;
                        String string7 = null;
                        if (string5 != null) {
                            String[] stringArray;
                            int n6;
                            oC = null;
                            Map<String, Object> map2 = this.vwr.captureParams;
                            int n7 = "ad on of en ca mo ".indexOf(string5.substring(0, 2));
                            if (n7 == 15) {
                                if (map2 != null && map2.containsKey("outputChannel")) {
                                    ((OC)map2.get("outputChannel")).closeChannel();
                                }
                                if ((n6 = map.containsKey("streaming")) != 0 && (oC = this.getOutputChannel(string6, null)) == null) {
                                    string7 = "ERROR: capture canceled";
                                    string2 = "ERROR: capture canceled";
                                    this.vwr.captureParams = null;
                                } else {
                                    this.vwr.captureParams = map;
                                    if (map.containsKey("captureRootExt")) {
                                        n7 = 0;
                                    } else {
                                        if (oC != null) {
                                            string6 = oC.getFileName();
                                        }
                                        map.put("captureFileName", string6);
                                        if (n6 != 0) {
                                            string7 = String.valueOf(string3) + "_STREAM_OPEN " + string6;
                                            map.put("captureMode", "movie");
                                        } else {
                                            stringArray = new String[2];
                                            map.put("captureRootExt", OutputManager.getRootExt(string6, stringArray, 0));
                                            string6 = (String)OutputManager.getRootExt(null, stringArray, 1);
                                            n7 = -1;
                                            map2 = map;
                                            bl4 = false;
                                        }
                                    }
                                    if (!map.containsKey("captureCount")) {
                                        map.put("captureCount", 0);
                                    }
                                }
                            }
                            if (n7 >= 0 && n7 != 15) {
                                if (map2 == null) {
                                    string7 = "ERROR: capture not active";
                                    string2 = "ERROR: capture not active";
                                } else {
                                    map = map2;
                                    switch (n7) {
                                        default: {
                                            string2 = string7 = "ERROR: CAPTURE MODE=" + string5 + "?";
                                            break;
                                        }
                                        case 0: {
                                            if (Boolean.FALSE == map.get("captureEnabled")) {
                                                string7 = "capturing OFF; use CAPTURE ON/END/CANCEL to continue";
                                                string2 = "capturing OFF; use CAPTURE ON/END/CANCEL to continue";
                                                break;
                                            }
                                            n6 = OutputManager.getInt(map, "captureCount", 0);
                                            map.put("captureCount", ++n6);
                                            stringArray = (String[])map.get("captureRootExt");
                                            if (stringArray != null) {
                                                string6 = (String)OutputManager.getRootExt(null, stringArray, n6);
                                                string7 = null;
                                                bl4 = true;
                                                break;
                                            }
                                            string7 = String.valueOf(string3) + "_STREAM_ADD " + n6;
                                            break;
                                        }
                                        case 3: 
                                        case 6: {
                                            map = map2;
                                            map.put("captureEnabled", string5.equals("on") ? Boolean.TRUE : Boolean.FALSE);
                                            string2 = String.valueOf(string3) + "_STREAM_" + (string5.equals("on") ? "ON" : "OFF");
                                            map.put("captureMode", "add");
                                            break;
                                        }
                                        case 9: 
                                        case 12: {
                                            map = map2;
                                            map.put("captureMode", string5);
                                            string = (String)map.get("captureFileName");
                                            string7 = String.valueOf(string3) + "_STREAM_" + (string5.equals("end") ? "CLOSE " : "CANCEL ") + string;
                                            this.vwr.captureParams = null;
                                            map.put("captureMsg", String.valueOf(GT.$("Capture")) + ": " + (string5.equals("cancel") ? GT.$("canceled") : GT.o(GT.$("{0} saved"), string)));
                                            if (!map.containsKey("captureRootExt")) break;
                                            bl4 = false;
                                        }
                                    }
                                }
                            }
                            if (bl4 && oC != null) {
                                map.put("outputChannel", oC);
                            }
                        }
                        if (bl4) {
                            if (string6 != null) {
                                map.put("fileName", string6);
                            }
                            if (string2 == null) {
                                string2 = this.writeToOutputChannel(map);
                            }
                            this.vwr.sm.createImage(string2, string3, null, null, n5);
                            if (string5 != null) {
                                string7 = string7 == null ? string2 : String.valueOf(string7) + " (" + map.get(map.containsKey("captureByteCount") ? "captureByteCount" : "byteCount") + " bytes)";
                            }
                        }
                        if (string7 != null) {
                            this.vwr.showString(string7, false);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                string2 = "ERROR creating image??: " + throwable;
                Logger.error(this.vwr.setErrorMessage(string2, null));
                this.vwr.creatingImage = false;
                if (n5 != Integer.MIN_VALUE && n3 > 0) {
                    this.vwr.resizeImage(n3, n4, true, false, true);
                }
            }
        }
        finally {
            this.vwr.creatingImage = false;
            if (n5 != Integer.MIN_VALUE && n3 > 0) {
                this.vwr.resizeImage(n3, n4, true, false, true);
            }
        }
        return string2;
    }

    String setLogFile(String string) {
        String string2 = null;
        if (this.vwr.logFilePath == null || string.indexOf("\\") >= 0) {
            string = null;
        } else if (string.startsWith("http://") || string.startsWith("https://")) {
            string2 = string;
        } else if (string.indexOf("/") >= 0) {
            string = null;
        } else if (string.length() > 0) {
            if (!string.startsWith("JmolLog_")) {
                string = "JmolLog_" + string;
            }
            string2 = this.getLogPath(String.valueOf(this.vwr.logFilePath) + string);
        }
        if (string2 == null) {
            string = null;
        } else {
            Logger.info(GT.o(GT.$("Setting log file to {0}"), string2));
        }
        if (string == null || !this.vwr.haveAccess(Viewer.ACCESS.ALL)) {
            Logger.info(GT.$("Cannot set log file path."));
            string = null;
        } else {
            this.vwr.logFileName = string2;
            this.vwr.g.setO("_logFile", this.vwr.isApplet ? string : string2);
        }
        return string;
    }

    void logToFile(String string) {
        block7: {
            try {
                OC oC;
                boolean bl = string.equals("$CLEAR$");
                if (string.indexOf("$NOW$") >= 0) {
                    string = PT.rep(string, "$NOW$", this.vwr.apiPlatform.getDateFormat(null));
                }
                if (this.vwr.logFileName == null) {
                    Logger.info(string);
                    return;
                }
                OC oC2 = this.vwr.haveAccess(Viewer.ACCESS.ALL) ? this.openOutputChannel(this.privateKey, this.vwr.logFileName, true, !bl) : (oC = null);
                if (!bl) {
                    int n = string.indexOf(0);
                    if (n >= 0) {
                        string = string.substring(0, n);
                    }
                    oC.append(string);
                    if (n < 0) {
                        oC.append("\n");
                    }
                }
                String string2 = oC.closeChannel();
                Logger.info(string2);
            }
            catch (Exception exception) {
                if (!Logger.debugging) break block7;
                Logger.debug("cannot log " + string);
            }
        }
    }

    private String createZipSet(String string, String[] stringArray, boolean bl, OC oC, String string2) {
        byte[] byArray;
        String string3;
        int n;
        boolean bl2;
        boolean bl3;
        Lst<Object> lst = new Lst<Object>();
        FileManager fileManager = this.vwr.fm;
        Lst<String> lst2 = new Lst<String>();
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        boolean bl4 = stringArray != null && stringArray.length == 3 && stringArray[1].startsWith(SCENE_TAG);
        boolean bl5 = bl3 = bl4 && stringArray[2].equals("min");
        if (!bl3) {
            FileManager.getFileReferences(string, lst2);
            if (bl4) {
                FileManager.getFileReferences(stringArray[1], lst2);
            }
        }
        boolean bl6 = bl2 = !bl4 && stringArray != null && stringArray.length > 0;
        if (bl2) {
            string = this.wrapPathForAllFiles("script " + PT.esc(stringArray[0]), "");
            n = 0;
            while (n < stringArray.length) {
                lst2.addLast(stringArray[n]);
                ++n;
            }
        }
        n = lst2.size();
        Lst<String> lst3 = new Lst<String>();
        int n2 = 0;
        while (n2 < n) {
            string3 = (String)lst2.get(n2);
            boolean bl7 = !Viewer.isJS && OC.isLocal(string3);
            String string4 = string3;
            if (bl7 || bl) {
                boolean bl8;
                int n3 = string3.lastIndexOf("/");
                string4 = string3.indexOf("?") > 0 && string3.indexOf("|") < 0 ? PT.replaceAllCharacters(string3, "/:?\"'=&", "_") : FileManager.stripPath(string3);
                string4 = PT.replaceAllCharacters(string4, "[]", "_");
                string4 = PT.rep(string4, "#_DOCACHE_", "");
                boolean bl9 = bl8 = fileManager.spardirCache != null && fileManager.spardirCache.containsKey(string3);
                if (bl7 && string3.indexOf("|") < 0 && !bl8) {
                    lst.addLast(string3);
                    lst.addLast(string4);
                    lst.addLast((Object)null);
                } else {
                    Object object;
                    Object object2 = object = bl8 ? fileManager.spardirCache.get(string3) : (Object)fileManager.getFileAsBytes(string3, null);
                    if (!AU.isAB(object)) {
                        return "ERROR: " + (String)object;
                    }
                    string4 = this.addPngFileBytes(string3, (byte[])object, n2, hashtable, bl8, string4, n3, lst);
                }
                string3 = "$SCRIPT_PATH$" + string4;
            }
            hashtable.put(string4, string4);
            lst3.addLast(string3);
            ++n2;
        }
        if (!bl3) {
            string = PT.replaceQuotedStrings(string, lst2, lst3);
            lst.addLast("state.spt");
            lst.addLast((Object)null);
            lst.addLast(string.getBytes());
        }
        if (bl4) {
            if (stringArray[0] != null) {
                lst.addLast("animate.spt");
                lst.addLast((Object)null);
                lst.addLast(stringArray[0].getBytes());
            }
            lst.addLast("scene.spt");
            lst.addLast((Object)null);
            string = PT.replaceQuotedStrings(stringArray[1], lst2, lst3);
            lst.addLast(string.getBytes());
        }
        String string5 = bl4 ? "scene.spt" : "state.spt";
        lst.addLast("JmolManifest.txt");
        lst.addLast((Object)null);
        string3 = "# Jmol Manifest Zip Format 1.1\n# Created " + new Date() + "\n" + "# JmolVersion " + Viewer.getJmolVersion() + "\n" + string5;
        lst.addLast(string3.getBytes());
        lst.addLast("Jmol_version_" + Viewer.getJmolVersion().replace(' ', '_').replace(':', '.'));
        lst.addLast((Object)null);
        lst.addLast(new byte[0]);
        if (oC.getFileName() != null && (byArray = this.vwr.getImageAsBytes("PNG", 0, 0, -1, null)) != null) {
            lst.addLast("preview.png");
            lst.addLast((Object)null);
            lst.addLast(byArray);
        }
        return this.writeZipFile(oC, lst, "OK JMOL", string2);
    }

    private String addPngFileBytes(String string, byte[] byArray, int n, Hashtable<Object, String> hashtable, boolean bl, String string2, int n2, Lst<Object> lst) {
        Integer n3 = this.vwr.getJzt().getCrcValue(byArray);
        if (hashtable.containsKey(n3)) {
            string2 = hashtable.get(n3);
        } else {
            if (bl) {
                string2 = string2.replace('.', '_');
            }
            if (hashtable.containsKey(string2)) {
                int n4 = string2.lastIndexOf(".");
                string2 = n4 > n2 ? String.valueOf(string2.substring(0, n4)) + "[" + n + "]" + string2.substring(n4) : String.valueOf(string2) + "[" + n + "]";
            }
            lst.addLast(string);
            lst.addLast(string2);
            lst.addLast(byArray);
            hashtable.put(n3, string2);
        }
        return string2;
    }

    private String writeZipFile(OC oC, Lst<Object> lst, String string, String string2) {
        Object object;
        byte[] byArray = new byte[1024];
        long l = 0L;
        long l2 = 0L;
        String string3 = oC.getFileName();
        if (string2 != null && string2.startsWith("//")) {
            string2 = "file:" + string2.substring(1);
        }
        Logger.info("creating zip file " + (string3 == null ? "" : string3) + "...");
        String string4 = "";
        try {
            object = new BufferedOutputStream(oC);
            FileManager fileManager = this.vwr.fm;
            OutputStream outputStream = (OutputStream)this.vwr.getJzt().getZipOutputStream(object);
            int n = 0;
            while (n < lst.size()) {
                String string5 = (String)lst.get(n);
                byte[] byArray2 = null;
                Object object2 = fileManager.cacheGet(string5, false);
                if (!(object2 instanceof Map)) {
                    String string6;
                    String string7;
                    if (string5.indexOf("file:/") == 0) {
                        if ((string5 = string5.substring(5)).length() > 2 && string5.charAt(2) == ':') {
                            string5 = string5.substring(1);
                        }
                    } else if (string5.indexOf("cache://") == 0) {
                        string5 = string5.substring(8);
                    }
                    if ((string7 = (String)lst.get(n + 1)) == null) {
                        string7 = string5;
                    }
                    if (object2 != null) {
                        byte[] byArray3 = byArray2 = AU.isAB(object2) ? (byte[])object2 : ((String)object2).getBytes();
                    }
                    if (byArray2 == null) {
                        byArray2 = (byte[])lst.get(n + 2);
                    }
                    if (string4.indexOf(string6 = ";" + string7 + ";") >= 0) {
                        Logger.info("duplicate entry");
                    } else {
                        string4 = String.valueOf(string4) + string6;
                        this.vwr.getJzt().addZipEntry(outputStream, string7);
                        int n2 = 0;
                        if (byArray2 == null) {
                            int n3;
                            BufferedInputStream bufferedInputStream = this.vwr.getBufferedInputStream(string5);
                            while ((n3 = bufferedInputStream.read(byArray, 0, 1024)) > 0) {
                                outputStream.write(byArray, 0, n3);
                                n2 += n3;
                            }
                            bufferedInputStream.close();
                        } else {
                            outputStream.write(byArray2, 0, byArray2.length);
                            if (string2 != null) {
                                this.vwr.fm.recachePngjBytes(String.valueOf(string2) + "|" + string7, byArray2);
                            }
                            n2 += byArray2.length;
                        }
                        l += (long)n2;
                        this.vwr.getJzt().closeZipEntry(outputStream);
                        Logger.info("...added " + string5 + " (" + n2 + " bytes)");
                    }
                }
                n += 3;
            }
            outputStream.flush();
            outputStream.close();
            Logger.info(String.valueOf(l) + " bytes prior to compression");
            String string8 = oC.closeChannel();
            if (string8 != null) {
                if (string8.indexOf("Exception") >= 0) {
                    return string8;
                }
                string = String.valueOf(string) + " " + string8;
            }
            l2 = oC.getByteCount();
        }
        catch (IOException iOException) {
            Logger.info(iOException.toString());
            return iOException.toString();
        }
        object = oC.getFileName();
        return object == null ? null : String.valueOf(string) + " " + l2 + " " + (String)object;
    }

    protected String wrapPathForAllFiles(String string, String string2) {
        String string3 = "v__" + ("" + Math.random()).substring(3);
        return "# Jmol script\n{\n\tVar " + string3 + " = pathForAllFiles\n\tpathForAllFiles=\"$SCRIPT_PATH$\"\n\ttry{\n\t\t" + string + "\n\t}catch(e){" + string2 + "}\n\tpathForAllFiles = " + string3 + "\n}\n";
    }
}

