/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.naming.SuggestedName;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.StaticContext;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.inline.InlineOnlyKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\"\u001a\u00020\u00172\u0006\u0010 \u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020\fJ\u0014\u0010&\u001a\u00020'*\u00020\u001b2\u0006\u0010 \u001a\u00020\u0019H\u0002J\u0014\u0010(\u001a\u00020\u001e*\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/js/translate/context/DeclarationExporter;", "", "context", "Lorg/jetbrains/kotlin/js/translate/context/StaticContext;", "(Lorg/jetbrains/kotlin/js/translate/context/StaticContext;)V", "getContext", "()Lorg/jetbrains/kotlin/js/translate/context/StaticContext;", "exportedDeclarations", "", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "localPackageNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "objectLikeKinds", "", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "statements", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "getStatements", "()Ljava/util/List;", "assign", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "qualifier", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "export", "force", "", "exportObject", "declaration", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "exportProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getLocalPackageName", "packageName", "exportStatement", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpressionStatement;", "shouldBeExported", "js.translator"})
public final class DeclarationExporter {
    private final Set<ClassKind> objectLikeKinds;
    private final Set<MemberDescriptor> exportedDeclarations;
    private final Map<FqName, JsName> localPackageNames;
    @NotNull
    private final StaticContext context;

    private final List<JsStatement> getStatements() {
        List<JsStatement> list2 = this.context.getFragment().getExportBlock().getStatements();
        Intrinsics.checkExpressionValueIsNotNull(list2, "context.fragment.exportBlock.statements");
        return list2;
    }

    public final void export(@NotNull MemberDescriptor descriptor2, boolean force) {
        JsExpression qualifier;
        JsExpression jsExpression;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (this.exportedDeclarations.contains(descriptor2)) {
            return;
        }
        if (descriptor2 instanceof ConstructorDescriptor && ((ConstructorDescriptor)descriptor2).isPrimary()) {
            return;
        }
        if (AnnotationsUtils.isNativeObject(descriptor2) || AnnotationsUtils.isLibraryObject(descriptor2)) {
            return;
        }
        if (InlineOnlyKt.isEffectivelyInlineOnly(descriptor2)) {
            return;
        }
        SuggestedName suggestedName = this.context.getNameSuggestion().suggest(descriptor2);
        if (suggestedName == null) {
            return;
        }
        SuggestedName suggestedName2 = suggestedName;
        DeclarationDescriptor container2 = suggestedName2.getScope();
        if (!this.shouldBeExported(descriptor2, force)) {
            return;
        }
        this.exportedDeclarations.add(descriptor2);
        if (container2 instanceof PackageFragmentDescriptor) {
            JsNameRef jsNameRef = this.getLocalPackageName(((PackageFragmentDescriptor)container2).getFqName()).makeRef();
            Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "getLocalPackageName(container.fqName).makeRef()");
            jsExpression = jsNameRef;
        } else if (DescriptorUtils.isObject(container2)) {
            JsExpression jsExpression2 = JsAstUtils.prototypeOf(this.context.getInnerNameForDescriptor(container2).makeRef());
            jsExpression = jsExpression2;
            Intrinsics.checkExpressionValueIsNotNull(jsExpression2, "JsAstUtils.prototypeOf(c\u2026tor(container).makeRef())");
        } else {
            JsNameRef jsNameRef = this.context.getInnerNameForDescriptor(container2).makeRef();
            Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "context.getInnerNameForD\u2026ptor(container).makeRef()");
            jsExpression = qualifier = (JsExpression)jsNameRef;
        }
        if (descriptor2 instanceof ClassDescriptor && this.objectLikeKinds.contains((Object)((ClassDescriptor)descriptor2).getKind())) {
            this.exportObject((ClassDescriptor)descriptor2, qualifier);
        } else if (descriptor2 instanceof PropertyDescriptor && container2 instanceof PackageFragmentDescriptor) {
            this.exportProperty((PropertyDescriptor)descriptor2, qualifier);
        } else {
            this.assign(descriptor2, qualifier);
        }
    }

    private final void assign(DeclarationDescriptor descriptor2, JsExpression qualifier) {
        JsName jsName = this.context.getInnerNameForDescriptor(descriptor2);
        Intrinsics.checkExpressionValueIsNotNull(jsName, "context.getInnerNameForDescriptor(descriptor)");
        JsName exportedName = jsName;
        JsNameRef jsNameRef = exportedName.makeRef();
        Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "exportedName.makeRef()");
        JsNameRef expression2 = jsNameRef;
        JsName jsName2 = this.context.getNameForDescriptor(descriptor2);
        Intrinsics.checkExpressionValueIsNotNull(jsName2, "context.getNameForDescriptor(descriptor)");
        JsName propertyName = jsName2;
        if (MetadataProperties.getStaticRef(propertyName) == null && Intrinsics.areEqual(exportedName, propertyName) ^ true) {
            MetadataProperties.setStaticRef(propertyName, expression2);
        }
        Collection collection = this.getStatements();
        JsBinaryOperation jsBinaryOperation = JsAstUtils.assignment(new JsNameRef(propertyName, qualifier), expression2);
        Intrinsics.checkExpressionValueIsNotNull(jsBinaryOperation, "assignment(JsNameRef(pro\u2026, qualifier), expression)");
        JsExpressionStatement jsExpressionStatement = this.exportStatement(jsBinaryOperation, descriptor2);
        boolean bl = false;
        collection.add(jsExpressionStatement);
    }

    private final void exportObject(ClassDescriptor declaration, JsExpression qualifier) {
        JsName jsName = this.context.getNameForDescriptor(declaration);
        Intrinsics.checkExpressionValueIsNotNull(jsName, "context.getNameForDescriptor(declaration)");
        JsName name = jsName;
        JsExpression jsExpression = JsAstUtils.defineGetter(qualifier, name.getIdent(), this.context.getNameForObjectInstance(declaration).makeRef());
        Intrinsics.checkExpressionValueIsNotNull(jsExpression, "JsAstUtils.defineGetter(\u2026e(declaration).makeRef())");
        JsExpression expression2 = jsExpression;
        Collection collection = this.getStatements();
        JsExpressionStatement jsExpressionStatement = this.exportStatement(expression2, declaration);
        boolean bl = false;
        collection.add(jsExpressionStatement);
    }

    private final void exportProperty(PropertyDescriptor declaration, JsExpression qualifier) {
        JsExpression jsExpression;
        Object accessToField;
        JsObjectLiteral propertyLiteral = new JsObjectLiteral(true);
        JsName jsName = this.context.getNameForDescriptor(declaration);
        Intrinsics.checkExpressionValueIsNotNull(jsName, "context.getNameForDescriptor(declaration)");
        String string = jsName.getIdent();
        Intrinsics.checkExpressionValueIsNotNull(string, "context.getNameForDescriptor(declaration).ident");
        String name = string;
        boolean simpleProperty = JsDescriptorUtils.isSimpleFinalProperty(declaration) && !TranslationUtils.shouldAccessViaFunctions((CallableDescriptor)declaration);
        JsName exportedName = null;
        if (simpleProperty) {
            JsName jsName2 = this.context.getInnerNameForDescriptor(declaration);
            Intrinsics.checkExpressionValueIsNotNull(jsName2, "context.getInnerNameForDescriptor(declaration)");
            exportedName = jsName2;
            accessToField = new JsReturn(exportedName.makeRef());
            jsExpression = new JsFunction(this.context.getFragment().getScope(), new JsBlock((JsStatement)accessToField), declaration + " getter");
        } else {
            PropertyGetterDescriptor propertyGetterDescriptor = declaration.getGetter();
            if (propertyGetterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            JsName jsName3 = this.context.getInnerNameForDescriptor(propertyGetterDescriptor);
            Intrinsics.checkExpressionValueIsNotNull(jsName3, "context.getInnerNameForD\u2026tor(declaration.getter!!)");
            exportedName = jsName3;
            JsNameRef jsNameRef = exportedName.makeRef();
            Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "exportedName.makeRef()");
            jsExpression = jsNameRef;
        }
        JsExpression getterBody = jsExpression;
        accessToField = propertyLiteral.getPropertyInitializers();
        Object object = new JsPropertyInitializer(new JsNameRef("get"), getterBody);
        boolean bl = false;
        accessToField.add(object);
        if (declaration.isVar()) {
            JsExpression jsExpression2;
            if (simpleProperty) {
                bl = false;
                List statements = new ArrayList();
                JsFunction function2 = new JsFunction(this.context.getFragment().getScope(), new JsBlock(statements), declaration + " setter");
                SourceElement sourceElement = declaration.getSource();
                Intrinsics.checkExpressionValueIsNotNull(sourceElement, "declaration.source");
                function2.setSource(KotlinSourceElementKt.getPsi(sourceElement));
                JsName jsName4 = JsScope.declareTemporaryName("value");
                Intrinsics.checkExpressionValueIsNotNull(jsName4, "JsScope.declareTemporaryName(\"value\")");
                JsName valueName = jsName4;
                Collection collection = function2.getParameters();
                JsNode jsNode = new JsParameter(valueName);
                boolean bl2 = false;
                collection.add(jsNode);
                collection = statements;
                jsNode = JsAstUtils.assignment(this.context.getInnerNameForDescriptor(declaration).makeRef(), valueName.makeRef()).makeStmt();
                bl2 = false;
                collection.add(jsNode);
                jsExpression2 = function2;
            } else {
                PropertySetterDescriptor propertySetterDescriptor = declaration.getSetter();
                if (propertySetterDescriptor == null) {
                    Intrinsics.throwNpe();
                }
                JsNameRef jsNameRef = this.context.getInnerNameForDescriptor(propertySetterDescriptor).makeRef();
                Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "context.getInnerNameForD\u2026ation.setter!!).makeRef()");
                jsExpression2 = jsNameRef;
            }
            JsExpression setterBody = jsExpression2;
            object = propertyLiteral.getPropertyInitializers();
            JsPropertyInitializer jsPropertyInitializer = new JsPropertyInitializer(new JsNameRef("set"), setterBody);
            boolean bl3 = false;
            object.add(jsPropertyInitializer);
        }
        Collection collection = this.getStatements();
        JsInvocation jsInvocation = JsAstUtils.defineProperty(qualifier, name, propertyLiteral);
        Intrinsics.checkExpressionValueIsNotNull(jsInvocation, "JsAstUtils.definePropert\u2026r, name, propertyLiteral)");
        object = this.exportStatement(jsInvocation, declaration);
        bl = false;
        collection.add(object);
    }

    @NotNull
    public final JsName getLocalPackageName(@NotNull FqName packageName) {
        Intrinsics.checkParameterIsNotNull(packageName, "packageName");
        if (packageName.isRoot()) {
            JsName jsName = this.context.getFragment().getScope().declareName(Namer.getRootPackageName());
            Intrinsics.checkExpressionValueIsNotNull(jsName, "context.fragment.scope.d\u2026mer.getRootPackageName())");
            return jsName;
        }
        JsName name = this.localPackageNames.get(packageName);
        if (name == null) {
            name = JsScope.declareTemporaryName("package$" + packageName.shortName().asString());
            this.localPackageNames.put(packageName, name);
            Collection collection = this.getStatements();
            String string = packageName.shortName().asString();
            Intrinsics.checkExpressionValueIsNotNull(string, "packageName.shortName().asString()");
            String string2 = packageName.asString();
            Intrinsics.checkExpressionValueIsNotNull(string2, "packageName.asString()");
            FqName fqName2 = packageName.parent();
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "packageName.parent()");
            JsNameRef jsNameRef = this.getLocalPackageName(fqName2).makeRef();
            Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "getLocalPackageName(pack\u2026eName.parent()).makeRef()");
            JsStatement jsStatement = UtilsKt.definePackageAlias(string, name, string2, jsNameRef);
            boolean bl = false;
            collection.add(jsStatement);
        }
        return name;
    }

    private final JsExpressionStatement exportStatement(@NotNull JsExpression $this$exportStatement, DeclarationDescriptor declaration) {
        JsExpressionStatement jsExpressionStatement = new JsExpressionStatement($this$exportStatement);
        boolean bl = false;
        boolean bl2 = false;
        JsExpressionStatement it = jsExpressionStatement;
        boolean bl3 = false;
        MetadataProperties.setExportedTag(it, this.context.getTag(declaration));
        return jsExpressionStatement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldBeExported(@NotNull MemberDescriptor $this$shouldBeExported, boolean force) {
        if (force) return true;
        DeclarationDescriptor declarationDescriptor = $this$shouldBeExported;
        JsConfig jsConfig = this.context.getConfig();
        Intrinsics.checkExpressionValueIsNotNull(jsConfig, "context.config");
        if (!DescriptorUtilsKt.shouldBeExported(declarationDescriptor, jsConfig)) return false;
        return true;
    }

    @NotNull
    public final StaticContext getContext() {
        return this.context;
    }

    public DeclarationExporter(@NotNull StaticContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
        this.objectLikeKinds = SetsKt.setOf(ClassKind.OBJECT, ClassKind.ENUM_ENTRY);
        DeclarationExporter declarationExporter = this;
        boolean bl = false;
        Object object = new LinkedHashSet();
        declarationExporter.exportedDeclarations = object;
        declarationExporter = this;
        bl = false;
        declarationExporter.localPackageNames = object = (Map)new LinkedHashMap();
    }
}

