#ifndef _EFL_UI_FORMAT_EO_H_
#define _EFL_UI_FORMAT_EO_H_

#ifndef _EFL_UI_FORMAT_EO_CLASS_TYPE
#define _EFL_UI_FORMAT_EO_CLASS_TYPE

typedef Eo Efl_Ui_Format;

#endif

#ifndef _EFL_UI_FORMAT_EO_TYPES
#define _EFL_UI_FORMAT_EO_TYPES

/** Function pointer for format function hook
 *
 * @ingroup Efl_Ui
 */
typedef void (*Efl_Ui_Format_Func_Cb)(void *data, Eina_Strbuf *str, const Eina_Value value);


#endif
/** interface class for format_func
 *
 * @ingroup Efl_Ui_Format
 */
#define EFL_UI_FORMAT_MIXIN efl_ui_format_mixin_get()

EWAPI const Efl_Class *efl_ui_format_mixin_get(void);

/**
 * @brief Set the format function pointer to format the string.
 *
 * @param[in] obj The object.
 * @param[in] func The format function callback
 *
 * @ingroup Efl_Ui_Format
 */
EOAPI void efl_ui_format_cb_set(Eo *obj, void *func_data, Efl_Ui_Format_Func_Cb func, Eina_Free_Cb func_free_cb);

/**
 * @brief Control the format string for a given units label
 *
 * If @c NULL is passed to @c format, it will hide @c obj's units area
 * completely. If not, it'll set the <b>format string</b> for the units label
 * text. The units label is provided as a floating point value, so the units
 * text can display at most one floating point value. Note that the units label
 * is optional. Use a format string such as "%1.2f meters" for example.
 *
 * @note The default format string is an integer percentage, as in $"%.0f %%".
 *
 * @param[in] obj The object.
 * @param[in] units The format string for @c obj's units label.
 *
 * @ingroup Efl_Ui_Format
 */
EOAPI void efl_ui_format_string_set(Eo *obj, const char *units);

/**
 * @brief Control the format string for a given units label
 *
 * If @c NULL is passed to @c format, it will hide @c obj's units area
 * completely. If not, it'll set the <b>format string</b> for the units label
 * text. The units label is provided as a floating point value, so the units
 * text can display at most one floating point value. Note that the units label
 * is optional. Use a format string such as "%1.2f meters" for example.
 *
 * @note The default format string is an integer percentage, as in $"%.0f %%".
 *
 * @param[in] obj The object.
 *
 * @return The format string for @c obj's units label.
 *
 * @ingroup Efl_Ui_Format
 */
EOAPI const char *efl_ui_format_string_get(const Eo *obj);

#endif
