/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.Bundle;
import org.netbeans.modules.profiler.heapwalk.model.ChildrenComputer;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNodeFactory;
import org.netbeans.modules.profiler.heapwalk.model.InstanceNode;

public class ObjectNode
extends InstanceNode {
    public ObjectNode(Instance instance, String string, HeapWalkerNode heapWalkerNode) {
        super(instance, string, heapWalkerNode);
    }

    public ObjectNode(Instance instance, String string, HeapWalkerNode heapWalkerNode, int n) {
        super(instance, string, heapWalkerNode, n);
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    protected ChildrenComputer getChildrenComputer() {
        return new ChildrenComputer(){

            @Override
            public HeapWalkerNode[] computeChildren() {
                HeapWalkerNode[] heapWalkerNodeArray = null;
                if (ObjectNode.this.getMode() == 1) {
                    if (ObjectNode.this.hasInstance()) {
                        ArrayList arrayList = new ArrayList();
                        arrayList.addAll(ObjectNode.this.getInstance().getFieldValues());
                        arrayList.addAll(ObjectNode.this.getInstance().getStaticFieldValues());
                        if (arrayList.size() == 0) {
                            heapWalkerNodeArray = new HeapWalkerNode[]{HeapWalkerNodeFactory.createNoFieldsNode(ObjectNode.this)};
                        } else {
                            heapWalkerNodeArray = new HeapWalkerNode[arrayList.size()];
                            for (int i = 0; i < heapWalkerNodeArray.length; ++i) {
                                heapWalkerNodeArray[i] = HeapWalkerNodeFactory.createFieldNode((FieldValue)arrayList.get(i), ObjectNode.this);
                            }
                        }
                    } else {
                        heapWalkerNodeArray = new HeapWalkerNode[]{};
                    }
                } else if (ObjectNode.this.getMode() == 2) {
                    heapWalkerNodeArray = HeapWalkerNodeFactory.createReferences(ObjectNode.this);
                }
                return heapWalkerNodeArray;
            }
        };
    }

    @Override
    protected Icon computeIcon() {
        ImageIcon imageIcon = BrowserUtils.ICON_INSTANCE;
        if (this.getMode() == 2 && this.getInstance().isGCRoot()) {
            imageIcon = BrowserUtils.createGCRootIcon(imageIcon);
        }
        return this.processLoopIcon(imageIcon);
    }

    @Override
    protected String computeName() {
        GCRoot gCRoot;
        HeapWalkerNode heapWalkerNode;
        if (this.getMode() == 2 && this.getInstance().isGCRoot() && (heapWalkerNode = BrowserUtils.getRoot(this)) instanceof org.netbeans.modules.profiler.heapwalk.model.RootNode && (gCRoot = ((org.netbeans.modules.profiler.heapwalk.model.RootNode)((Object)heapWalkerNode)).getGCRoot(this.getInstance())) != null) {
            return super.computeName() + " (" + gCRoot.getKind() + ")";
        }
        return super.computeName();
    }

    public static abstract class RootNode
    extends ObjectNode
    implements org.netbeans.modules.profiler.heapwalk.model.RootNode {
        public RootNode(Instance instance, String string, HeapWalkerNode heapWalkerNode) {
            super(instance, string, heapWalkerNode);
        }

        public RootNode(Instance instance, String string, HeapWalkerNode heapWalkerNode, int n) {
            super(instance, string, heapWalkerNode, n);
        }

        @Override
        public abstract void refreshView();
    }

    public static class ArrayItem
    extends ObjectNode
    implements org.netbeans.modules.profiler.heapwalk.model.ArrayItem {
        private String ownerArrayType;
        private int itemIndex;
        private String nodeID;

        public ArrayItem(int n, Instance instance, HeapWalkerNode heapWalkerNode) {
            this(n, instance, heapWalkerNode, heapWalkerNode == null ? 1 : heapWalkerNode.getMode());
        }

        public ArrayItem(int n, Instance instance, HeapWalkerNode heapWalkerNode, int n2) {
            super(instance, null, heapWalkerNode, n2);
            this.itemIndex = n;
            this.ownerArrayType = heapWalkerNode.getType();
        }

        @Override
        public int getItemIndex() {
            return this.itemIndex;
        }

        @Override
        protected String computeName() {
            GCRoot gCRoot;
            HeapWalkerNode heapWalkerNode;
            String string = "[" + this.itemIndex + "]";
            if (this.isLoop()) {
                string = string + " " + Bundle.ObjectNode_LoopToString(BrowserUtils.getFullNodeName(this.getLoopTo()));
            }
            if (this.getMode() == 2 && this.getInstance().isGCRoot() && (heapWalkerNode = BrowserUtils.getRoot(this)) instanceof RootNode && (gCRoot = ((RootNode)heapWalkerNode).getGCRoot(this.getInstance())) != null) {
                string = string + " (" + gCRoot.getKind() + ")";
            }
            return string;
        }

        @Override
        protected String computeType() {
            if (!this.hasInstance()) {
                return "<" + BrowserUtils.getArrayItemType(this.ownerArrayType) + ">";
            }
            return super.computeType();
        }

        @Override
        public Object getNodeID() {
            if (this.nodeID == null) {
                this.nodeID = this.itemIndex + "#" + (this.hasInstance() ? Long.valueOf(this.getInstance().getInstanceId()) : "null");
            }
            return this.nodeID;
        }
    }
}

