/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineChart;

final class VerticalTimelineLayout
implements LayoutManager2 {
    private final TimelineChart chart;

    VerticalTimelineLayout(TimelineChart timelineChart) {
        this.chart = timelineChart;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, Utils.checkedInt((double)this.chart.getChartContext().getViewHeight()));
        for (int i = 0; i < container.getComponentCount(); ++i) {
            dimension.width = Math.max(dimension.width, container.getComponent((int)i).getPreferredSize().width);
        }
        return dimension;
    }

    @Override
    public void layoutContainer(Container container) {
        int n = container.getWidth();
        for (int i = 0; i < container.getComponentCount(); ++i) {
            ChartContext chartContext = this.chart.getRow(i).getContext();
            container.getComponent(i).setBounds(0, Utils.checkedInt((double)(chartContext.getViewportOffsetY() + this.chart.getOffsetY())), n, chartContext.getViewportHeight());
        }
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container container) {
    }
}

