/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.shards;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsGroup;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.internal.AliasFilter;

public class ClusterSearchShardsResponse
extends ActionResponse
implements ToXContentObject {
    private final ClusterSearchShardsGroup[] groups;
    private final DiscoveryNode[] nodes;
    private final Map<String, AliasFilter> indicesAndFilters;

    public ClusterSearchShardsResponse(StreamInput in) throws IOException {
        super(in);
        int i;
        this.groups = new ClusterSearchShardsGroup[in.readVInt()];
        for (i = 0; i < this.groups.length; ++i) {
            this.groups[i] = ClusterSearchShardsGroup.readSearchShardsGroupResponse(in);
        }
        this.nodes = new DiscoveryNode[in.readVInt()];
        for (i = 0; i < this.nodes.length; ++i) {
            this.nodes[i] = new DiscoveryNode(in);
        }
        int size = in.readVInt();
        this.indicesAndFilters = new HashMap<String, AliasFilter>();
        for (int i2 = 0; i2 < size; ++i2) {
            String index = in.readString();
            AliasFilter aliasFilter = new AliasFilter(in);
            this.indicesAndFilters.put(index, aliasFilter);
        }
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        throw new UnsupportedOperationException("usage of Streamable is to be replaced by Writeable");
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.groups.length);
        for (ClusterSearchShardsGroup response : this.groups) {
            response.writeTo(out);
        }
        out.writeVInt(this.nodes.length);
        for (DiscoveryNode node : this.nodes) {
            node.writeTo(out);
        }
        out.writeVInt(this.indicesAndFilters.size());
        for (Map.Entry entry : this.indicesAndFilters.entrySet()) {
            out.writeString((String)entry.getKey());
            ((AliasFilter)entry.getValue()).writeTo(out);
        }
    }

    public ClusterSearchShardsResponse(ClusterSearchShardsGroup[] groups, DiscoveryNode[] nodes, Map<String, AliasFilter> indicesAndFilters) {
        this.groups = groups;
        this.nodes = nodes;
        this.indicesAndFilters = indicesAndFilters;
    }

    public ClusterSearchShardsGroup[] getGroups() {
        return this.groups;
    }

    public DiscoveryNode[] getNodes() {
        return this.nodes;
    }

    public Map<String, AliasFilter> getIndicesAndFilters() {
        return this.indicesAndFilters;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("nodes");
        for (DiscoveryNode node : this.nodes) {
            node.toXContent(builder, params);
        }
        builder.endObject();
        if (this.indicesAndFilters != null) {
            builder.startObject("indices");
            for (Map.Entry entry : this.indicesAndFilters.entrySet()) {
                String index = (String)entry.getKey();
                builder.startObject(index);
                AliasFilter aliasFilter = (AliasFilter)entry.getValue();
                Object[] aliases = aliasFilter.getAliases();
                if (aliases.length > 0) {
                    Arrays.sort(aliases);
                    builder.array("aliases", (String[])aliases);
                    if (aliasFilter.getQueryBuilder() != null) {
                        builder.field("filter");
                        aliasFilter.getQueryBuilder().toXContent(builder, params);
                    }
                }
                builder.endObject();
            }
            builder.endObject();
        }
        builder.startArray("shards");
        for (ClusterSearchShardsGroup group : this.groups) {
            group.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }
}

