/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants.platform.openbsd;

import java.util.EnumMap;
import java.util.Map;
import jnr.constants.Constant;

public enum Errno implements Constant
{
    EPERM(1),
    ENOENT(2),
    ESRCH(3),
    EINTR(4),
    EIO(5),
    ENXIO(6),
    E2BIG(7),
    ENOEXEC(8),
    EBADF(9),
    ECHILD(10),
    EDEADLK(11),
    ENOMEM(12),
    EACCES(13),
    EFAULT(14),
    ENOTBLK(15),
    EBUSY(16),
    EEXIST(17),
    EXDEV(18),
    ENODEV(19),
    ENOTDIR(20),
    EISDIR(21),
    EINVAL(22),
    ENFILE(23),
    EMFILE(24),
    ENOTTY(25),
    ETXTBSY(26),
    EFBIG(27),
    ENOSPC(28),
    ESPIPE(29),
    EROFS(30),
    EMLINK(31),
    EPIPE(32),
    EDOM(33),
    ERANGE(34),
    EWOULDBLOCK(35),
    EAGAIN(35),
    EINPROGRESS(36),
    EALREADY(37),
    ENOTSOCK(38),
    EDESTADDRREQ(39),
    EMSGSIZE(40),
    EPROTOTYPE(41),
    ENOPROTOOPT(42),
    EPROTONOSUPPORT(43),
    ESOCKTNOSUPPORT(44),
    EOPNOTSUPP(45),
    EPFNOSUPPORT(46),
    EAFNOSUPPORT(47),
    EADDRINUSE(48),
    EADDRNOTAVAIL(49),
    ENETDOWN(50),
    ENETUNREACH(51),
    ENETRESET(52),
    ECONNABORTED(53),
    ECONNRESET(54),
    ENOBUFS(55),
    EISCONN(56),
    ENOTCONN(57),
    ESHUTDOWN(58),
    ETOOMANYREFS(59),
    ETIMEDOUT(60),
    ECONNREFUSED(61),
    ELOOP(62),
    ENAMETOOLONG(63),
    EHOSTDOWN(64),
    EHOSTUNREACH(65),
    ENOTEMPTY(66),
    EUSERS(68),
    EDQUOT(69),
    ESTALE(70),
    EREMOTE(71),
    ENOLCK(77),
    ENOSYS(78),
    EOVERFLOW(87),
    EIDRM(89),
    ENOMSG(90),
    EILSEQ(84);

    private final int value;
    public static final long MIN_VALUE = 1L;
    public static final long MAX_VALUE = 90L;

    private Errno(int value2) {
        this.value = value2;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    public final int value() {
        return this.value;
    }

    @Override
    public final int intValue() {
        return this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    static final class StringTable {
        public static final Map<Errno, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<Errno, String> generateTable() {
            EnumMap<Errno, String> map2 = new EnumMap<Errno, String>(Errno.class);
            map2.put(EPERM, "Operation not permitted");
            map2.put(ENOENT, "No such file or directory");
            map2.put(ESRCH, "No such process");
            map2.put(EINTR, "Interrupted system call");
            map2.put(EIO, "Input/output error");
            map2.put(ENXIO, "Device not configured");
            map2.put(E2BIG, "Argument list too long");
            map2.put(ENOEXEC, "Exec format error");
            map2.put(EBADF, "Bad file descriptor");
            map2.put(ECHILD, "No child processes");
            map2.put(EDEADLK, "Resource deadlock avoided");
            map2.put(ENOMEM, "Cannot allocate memory");
            map2.put(EACCES, "Permission denied");
            map2.put(EFAULT, "Bad address");
            map2.put(ENOTBLK, "Block device required");
            map2.put(EBUSY, "Device busy");
            map2.put(EEXIST, "File exists");
            map2.put(EXDEV, "Cross-device link");
            map2.put(ENODEV, "Operation not supported by device");
            map2.put(ENOTDIR, "Not a directory");
            map2.put(EISDIR, "Is a directory");
            map2.put(EINVAL, "Invalid argument");
            map2.put(ENFILE, "Too many open files in system");
            map2.put(EMFILE, "Too many open files");
            map2.put(ENOTTY, "Inappropriate ioctl for device");
            map2.put(ETXTBSY, "Text file busy");
            map2.put(EFBIG, "File too large");
            map2.put(ENOSPC, "No space left on device");
            map2.put(ESPIPE, "Illegal seek");
            map2.put(EROFS, "Read-only file system");
            map2.put(EMLINK, "Too many links");
            map2.put(EPIPE, "Broken pipe");
            map2.put(EDOM, "Numerical argument out of domain");
            map2.put(ERANGE, "Result too large");
            map2.put(EWOULDBLOCK, "Resource temporarily unavailable");
            map2.put(EAGAIN, "Resource temporarily unavailable");
            map2.put(EINPROGRESS, "Operation now in progress");
            map2.put(EALREADY, "Operation already in progress");
            map2.put(ENOTSOCK, "Socket operation on non-socket");
            map2.put(EDESTADDRREQ, "Destination address required");
            map2.put(EMSGSIZE, "Message too long");
            map2.put(EPROTOTYPE, "Protocol wrong type for socket");
            map2.put(ENOPROTOOPT, "Protocol not available");
            map2.put(EPROTONOSUPPORT, "Protocol not supported");
            map2.put(ESOCKTNOSUPPORT, "Socket type not supported");
            map2.put(EOPNOTSUPP, "Operation not supported");
            map2.put(EPFNOSUPPORT, "Protocol family not supported");
            map2.put(EAFNOSUPPORT, "Address family not supported by protocol family");
            map2.put(EADDRINUSE, "Address already in use");
            map2.put(EADDRNOTAVAIL, "Can't assign requested address");
            map2.put(ENETDOWN, "Network is down");
            map2.put(ENETUNREACH, "Network is unreachable");
            map2.put(ENETRESET, "Network dropped connection on reset");
            map2.put(ECONNABORTED, "Software caused connection abort");
            map2.put(ECONNRESET, "Connection reset by peer");
            map2.put(ENOBUFS, "No buffer space available");
            map2.put(EISCONN, "Socket is already connected");
            map2.put(ENOTCONN, "Socket is not connected");
            map2.put(ESHUTDOWN, "Can't send after socket shutdown");
            map2.put(ETOOMANYREFS, "Too many references: can't splice");
            map2.put(ETIMEDOUT, "Connection timed out");
            map2.put(ECONNREFUSED, "Connection refused");
            map2.put(ELOOP, "Too many levels of symbolic links");
            map2.put(ENAMETOOLONG, "File name too long");
            map2.put(EHOSTDOWN, "Host is down");
            map2.put(EHOSTUNREACH, "No route to host");
            map2.put(ENOTEMPTY, "Directory not empty");
            map2.put(EUSERS, "Too many users");
            map2.put(EDQUOT, "Disc quota exceeded");
            map2.put(ESTALE, "Stale NFS file handle");
            map2.put(EREMOTE, "Too many levels of remote in path");
            map2.put(ENOLCK, "No locks available");
            map2.put(ENOSYS, "Function not implemented");
            map2.put(EOVERFLOW, "Value too large to be stored in data type");
            map2.put(EIDRM, "Identifier removed");
            map2.put(ENOMSG, "No message of desired type");
            map2.put(EILSEQ, "Illegal byte sequence");
            return map2;
        }
    }
}

