/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.apache.tomcat.dbcp.dbcp2.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp2.DelegatingPreparedStatement;
import org.apache.tomcat.dbcp.dbcp2.PStmtKey;
import org.apache.tomcat.dbcp.dbcp2.PoolableCallableStatement;
import org.apache.tomcat.dbcp.dbcp2.PoolablePreparedStatement;
import org.apache.tomcat.dbcp.pool2.KeyedObjectPool;
import org.apache.tomcat.dbcp.pool2.KeyedPooledObjectFactory;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.impl.DefaultPooledObject;

public class PoolingConnection
extends DelegatingConnection<Connection>
implements KeyedPooledObjectFactory<PStmtKey, DelegatingPreparedStatement> {
    private KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> pstmtPool;

    public PoolingConnection(Connection connection) {
        super(connection);
    }

    @Override
    public void activateObject(PStmtKey key, PooledObject<DelegatingPreparedStatement> pooledObject) throws Exception {
        pooledObject.getObject().activate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        block11: {
            try {
                if (null == this.pstmtPool) break block11;
                KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> oldpool = this.pstmtPool;
                this.pstmtPool = null;
                try {
                    oldpool.close();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SQLException("Cannot close connection", e);
                }
            }
            finally {
                try {
                    this.getDelegateInternal().close();
                }
                finally {
                    this.setClosedInternal(true);
                }
            }
        }
    }

    protected PStmtKey createKey(String sql) {
        String catalog = null;
        try {
            catalog = this.getCatalog();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return new PStmtKey(this.normalizeSQL(sql), catalog);
    }

    protected PStmtKey createKey(String sql, int autoGeneratedKeys) {
        String catalog = null;
        try {
            catalog = this.getCatalog();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return new PStmtKey(this.normalizeSQL(sql), catalog, autoGeneratedKeys);
    }

    protected PStmtKey createKey(String sql, int[] columnIndexes) {
        String catalog = null;
        try {
            catalog = this.getCatalog();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return new PStmtKey(this.normalizeSQL(sql), catalog, columnIndexes);
    }

    protected PStmtKey createKey(String sql, int resultSetType, int resultSetConcurrency) {
        String catalog = null;
        try {
            catalog = this.getCatalog();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return new PStmtKey(this.normalizeSQL(sql), catalog, resultSetType, resultSetConcurrency);
    }

    protected PStmtKey createKey(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        String catalog = null;
        try {
            catalog = this.getCatalog();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return new PStmtKey(this.normalizeSQL(sql), catalog, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    protected PStmtKey createKey(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, StatementType stmtType) {
        String catalog = null;
        try {
            catalog = this.getCatalog();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return new PStmtKey(this.normalizeSQL(sql), catalog, resultSetType, resultSetConcurrency, resultSetHoldability, stmtType);
    }

    protected PStmtKey createKey(String sql, int resultSetType, int resultSetConcurrency, StatementType stmtType) {
        String catalog = null;
        try {
            catalog = this.getCatalog();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return new PStmtKey(this.normalizeSQL(sql), catalog, resultSetType, resultSetConcurrency, stmtType);
    }

    protected PStmtKey createKey(String sql, StatementType stmtType) {
        String catalog = null;
        try {
            catalog = this.getCatalog();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return new PStmtKey(this.normalizeSQL(sql), catalog, stmtType, null);
    }

    protected PStmtKey createKey(String sql, String[] columnNames) {
        String catalog = null;
        try {
            catalog = this.getCatalog();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return new PStmtKey(this.normalizeSQL(sql), catalog, columnNames);
    }

    @Override
    public void destroyObject(PStmtKey key, PooledObject<DelegatingPreparedStatement> pooledObject) throws Exception {
        pooledObject.getObject().getInnermostDelegate().close();
    }

    @Override
    public PooledObject<DelegatingPreparedStatement> makeObject(PStmtKey key) throws Exception {
        if (null == key) {
            throw new IllegalArgumentException("Prepared statement key is null or invalid.");
        }
        if (key.getStmtType() == StatementType.PREPARED_STATEMENT) {
            PreparedStatement statement = (PreparedStatement)key.createStatement((Connection)this.getDelegate());
            PoolablePreparedStatement<PStmtKey> pps = new PoolablePreparedStatement<PStmtKey>(statement, key, this.pstmtPool, this);
            return new DefaultPooledObject<DelegatingPreparedStatement>(pps);
        }
        CallableStatement statement = (CallableStatement)key.createStatement((Connection)this.getDelegate());
        PoolableCallableStatement pcs = new PoolableCallableStatement(statement, key, this.pstmtPool, this);
        return new DefaultPooledObject<DelegatingPreparedStatement>(pcs);
    }

    protected String normalizeSQL(String sql) {
        return sql.trim();
    }

    @Override
    public void passivateObject(PStmtKey key, PooledObject<DelegatingPreparedStatement> pooledObject) throws Exception {
        DelegatingPreparedStatement dps = pooledObject.getObject();
        dps.clearParameters();
        dps.passivate();
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        try {
            return (CallableStatement)((Object)this.pstmtPool.borrowObject(this.createKey(sql, StatementType.CALLABLE_STATEMENT)));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenCallableStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow callableStatement from pool failed", e);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return (CallableStatement)((Object)this.pstmtPool.borrowObject(this.createKey(sql, resultSetType, resultSetConcurrency, StatementType.CALLABLE_STATEMENT)));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenCallableStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow callableStatement from pool failed", e);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return (CallableStatement)((Object)this.pstmtPool.borrowObject(this.createKey(sql, resultSetType, resultSetConcurrency, resultSetHoldability, StatementType.CALLABLE_STATEMENT)));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenCallableStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow callableStatement from pool failed", e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (null == this.pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return this.pstmtPool.borrowObject(this.createKey(sql));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenPreparedStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (null == this.pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return this.pstmtPool.borrowObject(this.createKey(sql, autoGeneratedKeys));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenPreparedStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (null == this.pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return this.pstmtPool.borrowObject(this.createKey(sql, columnIndexes));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenPreparedStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (null == this.pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return this.pstmtPool.borrowObject(this.createKey(sql, resultSetType, resultSetConcurrency));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenPreparedStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (null == this.pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return this.pstmtPool.borrowObject(this.createKey(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenPreparedStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (null == this.pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return this.pstmtPool.borrowObject(this.createKey(sql, columnNames));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenPreparedStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    public void setStatementPool(KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> pool) {
        this.pstmtPool = pool;
    }

    @Override
    public String toString() {
        if (this.pstmtPool != null) {
            return "PoolingConnection: " + this.pstmtPool.toString();
        }
        return "PoolingConnection: null";
    }

    @Override
    public boolean validateObject(PStmtKey key, PooledObject<DelegatingPreparedStatement> pooledObject) {
        return true;
    }

    public static enum StatementType {
        CALLABLE_STATEMENT,
        PREPARED_STATEMENT;

    }
}

