/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.proxy;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.core.ProxySettings;
import org.netbeans.core.network.proxy.NetworkProxyResolver;
import org.netbeans.core.network.proxy.NetworkProxySettings;
import org.netbeans.core.network.proxy.ProxyAutoConfig;
import org.netbeans.core.network.proxy.fallback.FallbackNetworkProxy;
import org.netbeans.core.network.proxy.gnome.GnomeNetworkProxy;
import org.netbeans.core.network.proxy.kde.KdeNetworkProxy;
import org.netbeans.core.network.proxy.mac.MacNetworkProxy;
import org.netbeans.core.network.proxy.windows.WindowsNetworkProxy;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public class NetworkProxyReloader
extends ProxySettings.Reloader {
    private static final Logger LOGGER = Logger.getLogger(NetworkProxyReloader.class.getName());
    private static final String EMPTY_STRING = "";
    private static final String NON_PROXY_HOSTS_DELIMITER = "|";
    private static final String GNOME = "gnome";
    private static final String KDE = "kde";
    private static final String RUNNING_ENV_SYS_PROPERTY = "netbeans.running.environment";
    private static final NetworkProxyResolver NETWORK_PROXY_RESOLVER = NetworkProxyReloader.getNetworkProxyResolver();
    private static final NetworkProxyResolver FALLBACK_NETWORK_PROXY_RESOLVER = NetworkProxyReloader.getFallbackProxyResolver();

    public static void reloadNetworkProxy() {
        Object object;
        LOGGER.log(Level.FINE, "System network proxy reloading started.");
        Object object2 = NETWORK_PROXY_RESOLVER.getNetworkProxySettings();
        if (!((NetworkProxySettings)object2).isResolved()) {
            LOGGER.log(Level.INFO, "System network proxy reloading failed! Trying fallback resolver.");
            object = FALLBACK_NETWORK_PROXY_RESOLVER.getNetworkProxySettings();
            if (((NetworkProxySettings)object).isResolved()) {
                LOGGER.log(Level.INFO, "System network proxy reloading succeeded. Fallback provider was successful.");
                object2 = object;
            } else {
                LOGGER.log(Level.INFO, "System network proxy reloading failed! Fallback provider was unsuccessful.");
            }
        } else {
            LOGGER.log(Level.INFO, "System network proxy reloading succeeded.");
        }
        switch (((NetworkProxySettings)object2).getProxyMode()) {
            case AUTO: {
                String string;
                String string2;
                object = ProxyAutoConfig.get(((NetworkProxySettings)object2).getPacFileUrl());
                List<Proxy> list = null;
                try {
                    list = ((ProxyAutoConfig)object).findProxyForURL(new URI("http://netbeans.org"));
                }
                catch (URISyntaxException uRISyntaxException) {
                    LOGGER.log(Level.WARNING, "Cannot create URI from: http://netbeans.org", uRISyntaxException);
                }
                if (list != null && !list.isEmpty() && list.get(0).address() != null) {
                    string2 = ((InetSocketAddress)list.get(0).address()).getHostName();
                    string = Integer.toString(((InetSocketAddress)list.get(0).address()).getPort());
                } else {
                    string2 = EMPTY_STRING;
                    string = Integer.toString(0);
                }
                LOGGER.log(Level.INFO, "System network proxy - mode: auto");
                LOGGER.log(Level.INFO, "System network proxy - pac url: {0}", ((NetworkProxySettings)object2).getPacFileUrl());
                LOGGER.log(Level.INFO, "System network proxy TEST - http host: {0}", string2);
                LOGGER.log(Level.INFO, "System network proxy TEST - http port: {0}", string);
                NetworkProxyReloader.getPreferences().remove("systemProxyHttpHost");
                NetworkProxyReloader.getPreferences().remove("systemProxyHttpPort");
                NetworkProxyReloader.getPreferences().remove("systemProxyHttpsHost");
                NetworkProxyReloader.getPreferences().remove("systemProxyHttpsPort");
                NetworkProxyReloader.getPreferences().remove("systemProxySocksHost");
                NetworkProxyReloader.getPreferences().remove("systemProxySocksPort");
                NetworkProxyReloader.getPreferences().remove("systemProxyNonProxyHosts");
                NetworkProxyReloader.getPreferences().put("testSystemProxyHttpHost", string2);
                NetworkProxyReloader.getPreferences().put("testSystemProxyHttpPort", string);
                NetworkProxyReloader.getPreferences().put("systemPAC", ((NetworkProxySettings)object2).getPacFileUrl());
                break;
            }
            case MANUAL: {
                LOGGER.log(Level.INFO, "System network proxy - mode: manual");
                LOGGER.log(Level.INFO, "System network proxy - http host: {0}", ((NetworkProxySettings)object2).getHttpProxyHost());
                LOGGER.log(Level.INFO, "System network proxy - http port: {0}", ((NetworkProxySettings)object2).getHttpProxyPort());
                LOGGER.log(Level.INFO, "System network proxy - https host: {0}", ((NetworkProxySettings)object2).getHttpsProxyHost());
                LOGGER.log(Level.INFO, "System network proxy - https port: {0}", ((NetworkProxySettings)object2).getHttpsProxyPort());
                LOGGER.log(Level.INFO, "System network proxy - socks host: {0}", ((NetworkProxySettings)object2).getSocksProxyHost());
                LOGGER.log(Level.INFO, "System network proxy - socks port: {0}", ((NetworkProxySettings)object2).getSocksProxyPort());
                LOGGER.log(Level.INFO, "System network proxy - no proxy hosts: {0}", NetworkProxyReloader.getStringFromArray(((NetworkProxySettings)object2).getNoProxyHosts()));
                LOGGER.log(Level.INFO, "System network proxy TEST - http host: {0}", ((NetworkProxySettings)object2).getHttpProxyHost());
                LOGGER.log(Level.INFO, "System network proxy TEST - http port: {0}", ((NetworkProxySettings)object2).getHttpProxyPort());
                NetworkProxyReloader.getPreferences().put("systemProxyHttpHost", ((NetworkProxySettings)object2).getHttpProxyHost());
                NetworkProxyReloader.getPreferences().put("systemProxyHttpPort", ((NetworkProxySettings)object2).getHttpProxyPort());
                NetworkProxyReloader.getPreferences().put("systemProxyHttpsHost", ((NetworkProxySettings)object2).getHttpsProxyHost());
                NetworkProxyReloader.getPreferences().put("systemProxyHttpsPort", ((NetworkProxySettings)object2).getHttpsProxyPort());
                NetworkProxyReloader.getPreferences().put("systemProxySocksHost", ((NetworkProxySettings)object2).getSocksProxyHost());
                NetworkProxyReloader.getPreferences().put("systemProxySocksPort", ((NetworkProxySettings)object2).getSocksProxyPort());
                NetworkProxyReloader.getPreferences().put("systemProxyNonProxyHosts", NetworkProxyReloader.getStringFromArray(((NetworkProxySettings)object2).getNoProxyHosts()));
                NetworkProxyReloader.getPreferences().put("testSystemProxyHttpHost", ((NetworkProxySettings)object2).getHttpProxyHost());
                NetworkProxyReloader.getPreferences().put("testSystemProxyHttpPort", ((NetworkProxySettings)object2).getHttpProxyPort());
                NetworkProxyReloader.getPreferences().remove("systemPAC");
                break;
            }
            case DIRECT: {
                LOGGER.log(Level.INFO, "System network proxy - mode: direct");
            }
            default: {
                LOGGER.log(Level.INFO, "System network proxy: fell to default (correct if direct mode went before)");
                NetworkProxyReloader.getPreferences().remove("systemProxyHttpHost");
                NetworkProxyReloader.getPreferences().remove("systemProxyHttpPort");
                NetworkProxyReloader.getPreferences().remove("systemProxyHttpsHost");
                NetworkProxyReloader.getPreferences().remove("systemProxyHttpsPort");
                NetworkProxyReloader.getPreferences().remove("systemProxySocksHost");
                NetworkProxyReloader.getPreferences().remove("systemProxySocksPort");
                NetworkProxyReloader.getPreferences().remove("systemProxyNonProxyHosts");
                NetworkProxyReloader.getPreferences().remove("systemPAC");
                NetworkProxyReloader.getPreferences().remove("testSystemProxyHttpHost");
                NetworkProxyReloader.getPreferences().remove("testSystemProxyHttpPort");
            }
        }
        LOGGER.log(Level.FINE, "System network proxy reloading fineshed.");
    }

    private static String getStringFromArray(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append(NON_PROXY_HOSTS_DELIMITER);
        }
        return stringBuilder.toString();
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(ProxySettings.class);
    }

    private static NetworkProxyResolver getNetworkProxyResolver() {
        if (NETWORK_PROXY_RESOLVER == null) {
            String string;
            if (Utilities.isWindows()) {
                LOGGER.log(Level.INFO, "System network proxy resolver: Windows");
                return new WindowsNetworkProxy();
            }
            if (Utilities.isMac()) {
                LOGGER.log(Level.INFO, "System network proxy resolver: Mac");
                return new MacNetworkProxy();
            }
            if (Utilities.isUnix() && (string = System.getProperty(RUNNING_ENV_SYS_PROPERTY)) != null) {
                if (string.toLowerCase().equals(GNOME)) {
                    LOGGER.log(Level.INFO, "System network proxy resolver: Gnome");
                    return new GnomeNetworkProxy();
                }
                if (string.toLowerCase().equals(KDE)) {
                    LOGGER.log(Level.INFO, "System network proxy resolver: KDE");
                    return new KdeNetworkProxy();
                }
            }
            LOGGER.log(Level.INFO, "System network proxy resolver: no suitable found, using fallback.");
            return new FallbackNetworkProxy();
        }
        return NETWORK_PROXY_RESOLVER;
    }

    private static NetworkProxyResolver getFallbackProxyResolver() {
        if (FALLBACK_NETWORK_PROXY_RESOLVER == null) {
            return new FallbackNetworkProxy();
        }
        return FALLBACK_NETWORK_PROXY_RESOLVER;
    }

    public void reload() {
        NetworkProxyReloader.reloadNetworkProxy();
    }
}

