/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.openide.filesystems.AbstractFileObject;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.PathElements;
import org.openide.filesystems.RefreshRequest;
import org.openide.util.Enumerations;
import org.openide.util.NbCollections;

public abstract class AbstractFileSystem
extends FileSystem {
    private static final long serialVersionUID = -3345098214331282438L;
    private static transient PathElements lastEnum;
    private transient AbstractFileObject root;
    private transient RefreshRequest refresher;
    protected List list;
    protected Change change;
    protected Transfer transfer;
    protected Info info;
    protected Attr attr;

    @Override
    public void refresh(boolean bl) {
        for (FileObject fileObject : NbCollections.iterable(this.getAbstractRoot().existingSubFiles(true))) {
            fileObject.refresh(bl);
        }
    }

    @Override
    public abstract String getDisplayName();

    @Override
    public FileObject getRoot() {
        return this.getAbstractRoot();
    }

    @Override
    public FileObject findResource(String string) {
        if (string.length() == 0) {
            return this.getAbstractRoot();
        }
        PathElements pathElements = lastEnum;
        if (pathElements == null || !pathElements.getOriginalName().equals(string)) {
            lastEnum = pathElements = new PathElements(string);
        }
        return this.getAbstractRoot().find(pathElements.getEnumeration());
    }

    protected <T extends FileObject> Reference<T> createReference(T t) {
        return new WeakReference<T>(t);
    }

    protected final Reference<? extends FileObject> findReference(String string) {
        if (string.length() == 0) {
            return null;
        }
        Enumeration enumeration = NbCollections.checkedEnumerationByFilter((Enumeration)new StringTokenizer(string, "/"), String.class, (boolean)true);
        return this.getAbstractRoot().findRefIfExists(enumeration);
    }

    boolean isEnabledRefreshFolder() {
        return this.refresher != null;
    }

    protected final synchronized void setRefreshTime(int n) {
        if (this.refresher != null) {
            this.refresher.stop();
        }
        this.refresher = n <= 0 || System.getProperty("netbeans.debug.heap") != null ? null : new RefreshRequest(this, n);
    }

    protected final int getRefreshTime() {
        RefreshRequest refreshRequest = this.refresher;
        return refreshRequest == null ? 0 : refreshRequest.getRefreshTime();
    }

    final synchronized AbstractFileObject refreshRootImpl() {
        if (this.root != null) {
            this.root.validFlag = false;
        }
        this.root = this.createFileObject(null, "");
        return this.root;
    }

    protected final FileObject refreshRoot() {
        return this.refreshRootImpl();
    }

    protected final void refreshResource(String string, boolean bl) {
        AbstractFileObject abstractFileObject = (AbstractFileObject)this.findResourceIfExists(string);
        if (abstractFileObject != null) {
            abstractFileObject.refresh(null, null, true, bl);
        }
    }

    protected final Enumeration<? extends FileObject> existingFileObjects(FileObject fileObject) {
        return this.existingFileObjects((AbstractFolder)fileObject);
    }

    final Enumeration<? extends FileObject> existingFileObjects(AbstractFolder abstractFolder) {
        WeakReference<AbstractFolder> weakReference = new WeakReference<AbstractFolder>(abstractFolder);
        Enumeration enumeration = Enumerations.singleton(weakReference);
        class OnlyValidAndDeep
        implements Enumerations.Processor<Reference<AbstractFolder>, FileObject> {
            OnlyValidAndDeep() {
            }

            public FileObject process(Reference<AbstractFolder> reference, Collection<Reference<AbstractFolder>> collection) {
                AbstractFolder abstractFolder = reference.get();
                if (abstractFolder != null) {
                    AbstractFolder[] abstractFolderArray = abstractFolder.subfiles();
                    for (int i = 0; i < abstractFolderArray.length; ++i) {
                        collection.add(new WeakReference<AbstractFolder>(abstractFolderArray[i]));
                    }
                    return abstractFolder.isValid() ? abstractFolder : null;
                }
                return null;
            }
        }
        return Enumerations.removeNulls((Enumeration)Enumerations.queue((Enumeration)enumeration, (Enumerations.Processor)new OnlyValidAndDeep()));
    }

    boolean isLastModifiedCacheEnabled() {
        return true;
    }

    private FileObject findResourceIfExists(String string) {
        if (string.length() == 0) {
            return this.getAbstractRoot();
        }
        Enumeration enumeration = NbCollections.checkedEnumerationByFilter((Enumeration)new StringTokenizer(string, "/"), String.class, (boolean)true);
        return this.getAbstractRoot().findIfExists(enumeration);
    }

    AbstractFileObject createFileObject(AbstractFileObject abstractFileObject, String string) {
        return new AbstractFileObject(this, abstractFileObject, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final AbstractFileObject getAbstractRoot() {
        AbstractFileSystem abstractFileSystem = this;
        synchronized (abstractFileSystem) {
            if (this.root == null) {
                return this.refreshRootImpl();
            }
        }
        return this.root;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("change", this.change);
        putField.put("info", this.info);
        putField.put("attr", this.attr);
        putField.put("list", this.list);
        putField.put("transfer", this.transfer);
        objectOutputStream.writeFields();
        objectOutputStream.writeInt(this.getRefreshTime());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Object object = AbstractFileSystem.readImpl("change", getField);
        Object object2 = AbstractFileSystem.readImpl("info", getField);
        Object object3 = AbstractFileSystem.readImpl("attr", getField);
        Object object4 = AbstractFileSystem.readImpl("list", getField);
        Object object5 = AbstractFileSystem.readImpl("transfer", getField);
        this.change = (Change)object;
        this.info = (Info)object2;
        this.attr = (Attr)object3;
        this.list = (List)object4;
        this.transfer = (Transfer)object5;
        this.setRefreshTime(objectInputStream.readInt());
    }

    static Object readImpl(String string, ObjectInputStream.GetField getField) throws ClassNotFoundException, IOException {
        Object object = getField.get(string, null);
        if (object instanceof LocalFileSystem) {
            return new LocalFileSystem.Impl((LocalFileSystem)object);
        }
        if (object instanceof JarFileSystem) {
            return new JarFileSystem.Impl((JarFileSystem)object);
        }
        return object;
    }

    protected boolean checkVirtual(String string) {
        return false;
    }

    protected boolean canWrite(String string) {
        AbstractFileObject abstractFileObject = (AbstractFileObject)this.findResource(string);
        return abstractFileObject != null ? abstractFileObject.superCanWrite() : false;
    }

    protected boolean canRead(String string) {
        AbstractFileObject abstractFileObject = (AbstractFileObject)this.findResource(string);
        return abstractFileObject != null ? abstractFileObject.superCanRead() : false;
    }

    protected void markImportant(String string, boolean bl) {
        if (!bl && this.info != null) {
            this.info.markUnimportant(string);
        }
    }

    public static interface Attr
    extends Serializable {
        @Deprecated
        public static final long serialVersionUID = 5978845941846736946L;

        public Object readAttribute(String var1, String var2);

        public void writeAttribute(String var1, String var2, Object var3) throws IOException;

        public Enumeration<String> attributes(String var1);

        public void renameAttributes(String var1, String var2);

        public void deleteAttributes(String var1);
    }

    public static interface SymlinkInfo
    extends Serializable {
        public boolean isSymbolicLink(String var1) throws IOException;

        public String readSymbolicLink(String var1) throws IOException;

        public String getCanonicalName(String var1) throws IOException;
    }

    public static interface Info
    extends Serializable {
        @Deprecated
        public static final long serialVersionUID = -2438286177948307985L;

        public Date lastModified(String var1);

        public boolean folder(String var1);

        public boolean readOnly(String var1);

        public String mimeType(String var1);

        public long size(String var1);

        public InputStream inputStream(String var1) throws FileNotFoundException;

        public OutputStream outputStream(String var1) throws IOException;

        public void lock(String var1) throws IOException;

        public void unlock(String var1);

        public void markUnimportant(String var1);
    }

    public static interface Transfer
    extends Serializable {
        @Deprecated
        public static final long serialVersionUID = -8945397853892302838L;

        public boolean move(String var1, Transfer var2, String var3) throws IOException;

        public boolean copy(String var1, Transfer var2, String var3) throws IOException;
    }

    public static interface Change
    extends Serializable {
        @Deprecated
        public static final long serialVersionUID = -5841597109944924596L;

        public void createFolder(String var1) throws IOException;

        public void createData(String var1) throws IOException;

        public void rename(String var1, String var2) throws IOException;

        public void delete(String var1) throws IOException;
    }

    public static interface List
    extends Serializable {
        @Deprecated
        public static final long serialVersionUID = -6242105832891012528L;

        public String[] children(String var1);
    }
}

