#ifndef _EFL_CANVAS_VG_CONTAINER_EO_H_
#define _EFL_CANVAS_VG_CONTAINER_EO_H_

#ifndef _EFL_CANVAS_VG_CONTAINER_EO_CLASS_TYPE
#define _EFL_CANVAS_VG_CONTAINER_EO_CLASS_TYPE

typedef Eo Efl_Canvas_Vg_Container;

#endif

#ifndef _EFL_CANVAS_VG_CONTAINER_EO_TYPES
#define _EFL_CANVAS_VG_CONTAINER_EO_TYPES


#endif
/** Efl vector graphics container class
 *
 * @ingroup Efl_Canvas_Vg_Container
 */
#define EFL_CANVAS_VG_CONTAINER_CLASS efl_canvas_vg_container_class_get()

EWAPI const Efl_Class *efl_canvas_vg_container_class_get(void);

/**
 * @brief Get child of container
 *
 * @param[in] obj The object.
 * @param[in] name Child node name
 *
 * @return Child object
 *
 * @ingroup Efl_Canvas_Vg_Container
 */
EOAPI Efl_Canvas_Vg_Node *efl_canvas_vg_container_child_get(Eo *obj, const char *name);

/**
 * @brief Get all children of container
 *
 * @param[in] obj The object.
 *
 * @return Iterator to children
 *
 * @ingroup Efl_Canvas_Vg_Container
 */
EOAPI Eina_Iterator *efl_canvas_vg_container_children_get(Eo *obj) EINA_WARN_UNUSED_RESULT;

#endif
