/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.FileResolver;
import org.apache.ivy.util.StringUtils;

public class Configurator {
    private FileResolver fileResolver = FileResolver.DEFAULT;
    private Map typedefs = new HashMap();
    private Map macrodefs = new HashMap();
    private Stack objectStack = new Stack();
    private static final List TRUE_VALUES = Arrays.asList("true", "yes", "on");

    public void typeDef(String string, String string2) throws ClassNotFoundException {
        this.typeDef(string, Class.forName(string2));
    }

    public void typeDef(String string, Class clazz) {
        this.typedefs.put(string, clazz);
    }

    public void setRoot(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.objectStack.clear();
        this.setCurrent(object, null);
    }

    public void clear() {
        this.objectStack.clear();
    }

    private void setCurrent(Object object, String string) {
        this.objectStack.push(new ObjectDescriptor(object, string));
    }

    public Object startCreateChild(String string) {
        if (this.objectStack.isEmpty()) {
            throw new IllegalStateException("set root before creating child");
        }
        ObjectDescriptor objectDescriptor = (ObjectDescriptor)this.objectStack.peek();
        Object object = objectDescriptor.getObject();
        if (object instanceof MacroDef && !"attribute".equals(string) && !"element".equals(string)) {
            MacroRecord macroRecord = ((MacroDef)object).recordCreateChild(string);
            this.setCurrent(macroRecord, string);
            return macroRecord;
        }
        if (object instanceof Macro) {
            MacroRecord macroRecord = ((Macro)object).recordCreateChild(string);
            this.setCurrent(macroRecord, string);
            return macroRecord;
        }
        if (object instanceof MacroRecord) {
            MacroRecord macroRecord = ((MacroRecord)object).recordChild(string);
            this.setCurrent(macroRecord, string);
            return macroRecord;
        }
        HashMap hashMap = null;
        MacroDef macroDef = (MacroDef)this.macrodefs.get(string);
        if (macroDef != null) {
            Macro macro = macroDef.createMacro();
            this.setCurrent(macro, string);
            return macro;
        }
        Class<?> clazz = (Class<?>)this.typedefs.get(string);
        Method method = null;
        try {
            if (clazz != null) {
                return this.addChild(objectDescriptor, clazz, string, null);
            }
            method = objectDescriptor.getCreateMethod(string);
            if (method != null) {
                hashMap = method.invoke(object, new Object[0]);
                this.setCurrent(hashMap, string);
                return hashMap;
            }
            method = objectDescriptor.getAddMethod(string);
            if (method != null) {
                clazz = method.getParameterTypes()[0];
                hashMap = clazz.newInstance();
                method.invoke(object, hashMap);
                this.setCurrent(hashMap, string);
                return hashMap;
            }
            method = objectDescriptor.getAddConfiguredMethod(string);
            if (method != null) {
                clazz = method.getParameterTypes()[0];
                hashMap = Map.class == clazz ? new HashMap() : clazz.newInstance();
                this.setCurrent(hashMap, string);
                return hashMap;
            }
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("no default constructor on " + clazz + " for adding " + string + " on " + object.getClass());
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("bad method found for " + string + " on " + object.getClass());
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
        throw new IllegalArgumentException("no appropriate method found for adding " + string + " on " + object.getClass());
    }

    public void addChild(String string, Object object) {
        if (this.objectStack.isEmpty()) {
            throw new IllegalStateException("set root before creating child");
        }
        ObjectDescriptor objectDescriptor = (ObjectDescriptor)this.objectStack.peek();
        try {
            this.addChild(objectDescriptor, object.getClass(), string, object);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("no default constructor on " + object.getClass() + " for adding " + string + " on " + objectDescriptor.getObject().getClass());
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("bad method found for " + string + " on " + objectDescriptor.getObject().getClass());
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
    }

    private Object addChild(ObjectDescriptor objectDescriptor, Class clazz, String string, Object hashMap) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Object object = objectDescriptor.getObject();
        if (object instanceof MacroRecord) {
            MacroRecord macroRecord = (MacroRecord)object;
            MacroRecord macroRecord2 = macroRecord.recordChild(string, hashMap);
            this.setCurrent(macroRecord2, string);
            return macroRecord2;
        }
        Method method = objectDescriptor.getAddMethod(clazz);
        if (method != null) {
            if (hashMap == null) {
                hashMap = clazz.newInstance();
            }
            method.invoke(object, hashMap);
            this.setCurrent(hashMap, string);
            return hashMap;
        }
        method = objectDescriptor.getAddConfiguredMethod(clazz);
        if (method != null) {
            if (hashMap == null) {
                hashMap = Map.class == clazz ? new HashMap() : clazz.newInstance();
            }
            this.setCurrent(hashMap, string);
            return hashMap;
        }
        throw new IllegalArgumentException("no appropriate method found for adding " + string + " on " + object.getClass());
    }

    public boolean isTopLevelMacroRecord() {
        if (this.objectStack.isEmpty()) {
            return false;
        }
        ObjectDescriptor objectDescriptor = (ObjectDescriptor)this.objectStack.peek();
        return objectDescriptor.getObject() instanceof MacroDef;
    }

    public void setAttribute(String string, String string2) {
        if (this.objectStack.isEmpty()) {
            throw new IllegalStateException("set root before setting attribute");
        }
        ObjectDescriptor objectDescriptor = (ObjectDescriptor)this.objectStack.peek();
        if (objectDescriptor.getObject() instanceof Macro) {
            ((Macro)objectDescriptor.getObject()).defineAttribute(string, string2);
            return;
        }
        if (objectDescriptor.getObject() instanceof MacroRecord) {
            ((MacroRecord)objectDescriptor.getObject()).recordAttribute(string, string2);
            return;
        }
        Method method = objectDescriptor.getSetMethod(string);
        if (method == null) {
            if (objectDescriptor.getObject() instanceof Map) {
                ((Map)objectDescriptor.getObject()).put(string, string2);
                return;
            }
            throw new IllegalArgumentException("no set method found for " + string + " on " + objectDescriptor.getObject().getClass());
        }
        Object object = null;
        Class<?> clazz = method.getParameterTypes()[0];
        try {
            object = clazz.equals(String.class) ? string2 : (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE) ? Boolean.valueOf(TRUE_VALUES.contains(string2)) : (clazz.equals(Character.class) || clazz.equals(Character.TYPE) ? new Character(string2.length() > 0 ? string2.charAt(0) : (char)' ') : (clazz.equals(Short.class) || clazz.equals(Short.TYPE) ? Short.valueOf(string2) : (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE) ? Integer.valueOf(string2) : (clazz.equals(Long.class) || clazz.equals(Long.TYPE) ? Long.valueOf(string2) : (clazz.equals(Class.class) ? Class.forName(string2) : (clazz.equals(File.class) ? this.fileResolver.resolveFile(string2, objectDescriptor.getObjectName() + "." + string) : clazz.getConstructor(String.class).newInstance(string2))))))));
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("impossible to convert " + string2 + " to " + clazz + " for setting " + string + " on " + objectDescriptor.getObject().getClass() + ": " + exception.getMessage());
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
        try {
            method.invoke(objectDescriptor.getObject(), object);
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("impossible to set " + string + " to " + object + " on " + objectDescriptor.getObject().getClass());
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
    }

    public void addText(String string) {
        if (this.objectStack.isEmpty()) {
            throw new IllegalStateException("set root before adding text");
        }
        ObjectDescriptor objectDescriptor = (ObjectDescriptor)this.objectStack.peek();
        try {
            objectDescriptor.getObject().getClass().getMethod("addText", String.class).invoke(objectDescriptor.getObject(), string);
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("impossible to add text on " + objectDescriptor.getObject().getClass());
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
    }

    public Object endCreateChild() {
        if (this.objectStack.isEmpty()) {
            throw new IllegalStateException("set root before ending child");
        }
        ObjectDescriptor objectDescriptor = (ObjectDescriptor)this.objectStack.pop();
        if (this.objectStack.isEmpty()) {
            this.objectStack.push(objectDescriptor);
            throw new IllegalStateException("cannot end root");
        }
        if (objectDescriptor.getObject() instanceof Macro) {
            return ((Macro)objectDescriptor.getObject()).play(this);
        }
        ObjectDescriptor objectDescriptor2 = (ObjectDescriptor)this.objectStack.peek();
        String string = objectDescriptor.getObjectName();
        Class clazz = (Class)this.typedefs.get(string);
        Method method = null;
        method = clazz != null ? objectDescriptor2.getAddConfiguredMethod(clazz) : objectDescriptor2.getAddConfiguredMethod(string);
        try {
            if (method != null) {
                method.invoke(objectDescriptor2.getObject(), objectDescriptor.getObject());
            }
            return objectDescriptor.getObject();
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("impossible to add configured child for " + string + " on " + objectDescriptor2.getObject().getClass() + ": " + StringUtils.getErrorMessage(exception));
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
    }

    public Object getCurrent() {
        return this.objectStack.isEmpty() ? null : ((ObjectDescriptor)this.objectStack.peek()).getObject();
    }

    public int getDepth() {
        return this.objectStack.size();
    }

    public MacroDef startMacroDef(String string) {
        MacroDef macroDef = new MacroDef(string);
        this.setCurrent(macroDef, string);
        return macroDef;
    }

    public void addMacroAttribute(String string, String string2) {
        ((MacroDef)this.getCurrent()).addAttribute(string, string2);
    }

    public void addMacroElement(String string, boolean bl) {
        ((MacroDef)this.getCurrent()).addElement(string, bl);
    }

    public void endMacroDef() {
        this.addConfiguredMacrodef((MacroDef)this.getCurrent());
        this.objectStack.pop();
    }

    public void addConfiguredMacrodef(MacroDef macroDef) {
        this.macrodefs.put(macroDef.getName(), macroDef);
    }

    public Class getTypeDef(String string) {
        return (Class)this.typedefs.get(string);
    }

    public FileResolver getFileResolver() {
        return this.fileResolver;
    }

    public void setFileResolver(FileResolver fileResolver) {
        Checks.checkNotNull(fileResolver, "fileResolver");
        this.fileResolver = fileResolver;
    }

    private static class ObjectDescriptor {
        private Object obj;
        private String objName;
        private Map createMethods = new HashMap();
        private Map addMethods = new HashMap();
        private Map addConfiguredMethods = new HashMap();
        private Map setMethods = new HashMap();
        private Map typeAddMethods = new HashMap();
        private Map typeAddConfiguredMethods = new HashMap();

        public ObjectDescriptor(Object object, String string) {
            this.obj = object;
            this.objName = string;
            Method[] methodArray = object.getClass().getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                String string2;
                Method method = methodArray[i];
                if (method.getName().startsWith("create") && method.getParameterTypes().length == 0 && !Void.TYPE.equals(method.getReturnType())) {
                    string2 = StringUtils.uncapitalize(method.getName().substring("create".length()));
                    if (string2.length() == 0) continue;
                    this.addCreateMethod(string2, method);
                    continue;
                }
                if (method.getName().startsWith("addConfigured") && method.getParameterTypes().length == 1 && Void.TYPE.equals(method.getReturnType())) {
                    string2 = StringUtils.uncapitalize(method.getName().substring("addConfigured".length()));
                    if (string2.length() == 0) {
                        this.addAddConfiguredMethod(method);
                    }
                    this.addAddConfiguredMethod(string2, method);
                    continue;
                }
                if (method.getName().startsWith("add") && !method.getName().startsWith("addConfigured") && method.getParameterTypes().length == 1 && Void.TYPE.equals(method.getReturnType())) {
                    string2 = StringUtils.uncapitalize(method.getName().substring("add".length()));
                    if (string2.length() == 0) {
                        this.addAddMethod(method);
                    }
                    this.addAddMethod(string2, method);
                    continue;
                }
                if (!method.getName().startsWith("set") || method.getParameterTypes().length != 1 || !Void.TYPE.equals(method.getReturnType()) || (string2 = StringUtils.uncapitalize(method.getName().substring("set".length()))).length() == 0) continue;
                this.addSetMethod(string2, method);
            }
        }

        public void addCreateMethod(String string, Method method) {
            this.createMethods.put(string, method);
        }

        public void addAddMethod(String string, Method method) {
            this.addMethods.put(string, method);
        }

        public void addAddConfiguredMethod(String string, Method method) {
            this.addConfiguredMethods.put(string, method);
        }

        private void addAddMethod(Method method) {
            this.typeAddMethods.put(method.getParameterTypes()[0], method);
        }

        private void addAddConfiguredMethod(Method method) {
            this.typeAddConfiguredMethods.put(method.getParameterTypes()[0], method);
        }

        public void addSetMethod(String string, Method method) {
            Method method2 = (Method)this.setMethods.get(string);
            if (method2 != null && method2.getParameterTypes()[0] == String.class) {
                return;
            }
            this.setMethods.put(string, method);
        }

        public Object getObject() {
            return this.obj;
        }

        public Method getCreateMethod(String string) {
            return (Method)this.createMethods.get(string);
        }

        public Method getAddMethod(String string) {
            return (Method)this.addMethods.get(string);
        }

        public Method getAddConfiguredMethod(String string) {
            return (Method)this.addConfiguredMethods.get(string);
        }

        public Method getAddMethod(Class clazz) {
            return this.getTypeMatchingMethod(clazz, this.typeAddMethods);
        }

        public Method getAddConfiguredMethod(Class clazz) {
            return this.getTypeMatchingMethod(clazz, this.typeAddConfiguredMethods);
        }

        private Method getTypeMatchingMethod(Class clazz, Map map) {
            Method method = (Method)map.get(clazz);
            if (method != null) {
                return method;
            }
            for (Class clazz2 : map.keySet()) {
                if (!clazz2.isAssignableFrom(clazz)) continue;
                return (Method)map.get(clazz2);
            }
            return null;
        }

        public Method getSetMethod(String string) {
            return (Method)this.setMethods.get(string);
        }

        public String getObjectName() {
            return this.objName;
        }
    }

    public static class MacroDef {
        private String name;
        private Map attributes = new HashMap();
        private Map elements = new HashMap();
        private MacroRecord macroRecord;

        public MacroDef(String string) {
            this.name = string;
        }

        public Attribute getAttribute(String string) {
            return (Attribute)this.attributes.get(string);
        }

        public Object play(Configurator configurator, Map map, Map map2) {
            for (Attribute attribute : this.attributes.values()) {
                String string = (String)map.get(attribute.getName());
                if (string != null) continue;
                if (attribute.getDefault() == null) {
                    throw new IllegalArgumentException("attribute " + attribute.getName() + " is required in " + this.getName());
                }
                map.put(attribute.getName(), attribute.getDefault());
            }
            return this.play(configurator, this.macroRecord, map, map2);
        }

        private Object play(Configurator configurator, MacroRecord macroRecord, Map map, Map map2) {
            Object object;
            if (macroRecord.getObject() != null) {
                configurator.addChild(macroRecord.getName(), macroRecord.getObject());
                configurator.endCreateChild();
                return macroRecord.getObject();
            }
            configurator.startCreateChild(macroRecord.getName());
            Map map3 = macroRecord.getAttributes();
            for (Object object2 : map3.keySet()) {
                object = this.replaceParam((String)map3.get(object2), map);
                configurator.setAttribute((String)object2, (String)object);
            }
            for (Object object2 : macroRecord.getChildren()) {
                object = (Element)this.elements.get(((MacroRecord)object2).getName());
                if (object != null) {
                    List list = (List)map2.get(((MacroRecord)object2).getName());
                    if (list != null) {
                        for (MacroRecord macroRecord2 : list) {
                            for (MacroRecord macroRecord3 : macroRecord2.getChildren()) {
                                this.play(configurator, macroRecord3, map, Collections.EMPTY_MAP);
                            }
                        }
                        continue;
                    }
                    if (((Element)object).isOptional()) continue;
                    throw new IllegalArgumentException("non optional element is not specified: " + ((Element)object).getName() + " in macro " + this.getName());
                }
                this.play(configurator, (MacroRecord)object2, map, map2);
            }
            return configurator.endCreateChild();
        }

        private String replaceParam(String string, Map map) {
            return IvyPatternHelper.substituteParams(string, map);
        }

        public String getName() {
            return this.name;
        }

        public void addConfiguredAttribute(Attribute attribute) {
            this.attributes.put(attribute.getName(), attribute);
        }

        public void addConfiguredElement(Element element) {
            this.elements.put(element.getName(), element);
        }

        public Macro createMacro() {
            return new Macro(this);
        }

        public void addAttribute(String string, String string2) {
            Attribute attribute = new Attribute();
            attribute.setName(string);
            attribute.setDefault(string2);
            this.addConfiguredAttribute(attribute);
        }

        public void addElement(String string, boolean bl) {
            Element element = new Element();
            element.setName(string);
            element.setOptional(bl);
            this.addConfiguredElement(element);
        }

        public MacroRecord recordCreateChild(String string) {
            this.macroRecord = new MacroRecord(string);
            return this.macroRecord;
        }
    }

    public static class MacroRecord {
        private String name;
        private Map attributes = new LinkedHashMap();
        private List children = new ArrayList();
        private Object object;

        public MacroRecord(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void recordAttribute(String string, String string2) {
            this.attributes.put(string, string2);
        }

        public MacroRecord recordChild(String string) {
            MacroRecord macroRecord = new MacroRecord(string);
            this.children.add(macroRecord);
            return macroRecord;
        }

        public MacroRecord recordChild(String string, Object object) {
            MacroRecord macroRecord = this.recordChild(string);
            macroRecord.object = object;
            return macroRecord;
        }

        public Map getAttributes() {
            return this.attributes;
        }

        public List getChildren() {
            return this.children;
        }

        public Object getObject() {
            return this.object;
        }
    }

    public static class Element {
        private String name;
        private boolean optional = false;

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public void setOptional(boolean bl) {
            this.optional = bl;
        }
    }

    public static class Attribute {
        private String name;
        private String defaultValue;

        public String getDefault() {
            return this.defaultValue;
        }

        public void setDefault(String string) {
            this.defaultValue = string;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }
    }

    public static class Macro {
        private MacroDef macrodef;
        private Map attValues = new HashMap();
        private Map macroRecords = new HashMap();

        public Macro(MacroDef macroDef) {
            this.macrodef = macroDef;
        }

        public void defineAttribute(String string, String string2) {
            if (this.macrodef.getAttribute(string) == null) {
                throw new IllegalArgumentException("undeclared attribute " + string + " on macro " + this.macrodef.getName());
            }
            this.attValues.put(string, string2);
        }

        public MacroRecord recordCreateChild(String string) {
            MacroRecord macroRecord = new MacroRecord(string);
            ArrayList<MacroRecord> arrayList = (ArrayList<MacroRecord>)this.macroRecords.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<MacroRecord>();
                this.macroRecords.put(string, arrayList);
            }
            arrayList.add(macroRecord);
            return macroRecord;
        }

        public Object play(Configurator configurator) {
            return this.macrodef.play(configurator, this.attValues, this.macroRecords);
        }
    }
}

