#ifndef _EFL_CANVAS_ANIMATION_SCALE_EO_H_
#define _EFL_CANVAS_ANIMATION_SCALE_EO_H_

#ifndef _EFL_CANVAS_ANIMATION_SCALE_EO_CLASS_TYPE
#define _EFL_CANVAS_ANIMATION_SCALE_EO_CLASS_TYPE

typedef Eo Efl_Canvas_Animation_Scale;

#endif

#ifndef _EFL_CANVAS_ANIMATION_SCALE_EO_TYPES
#define _EFL_CANVAS_ANIMATION_SCALE_EO_TYPES


#endif
/** Efl scale animation class
 *
 * @ingroup Efl_Canvas_Animation_Scale
 */
#define EFL_CANVAS_ANIMATION_SCALE_CLASS efl_canvas_animation_scale_class_get()

EWAPI const Efl_Class *efl_canvas_animation_scale_class_get(void);

/**
 * @brief Scale property
 *
 * @param[in] obj The object.
 * @param[in] from_scale_x Scale factor along x axis when animation starts
 * @param[in] from_scale_y Scale factor along y axis when animation starts
 * @param[in] to_scale_x Scale factor along x axis when animation ends
 * @param[in] to_scale_y Scale factor along y axis when animation ends
 * @param[in] pivot Pivot object for the center point. If the pivot object is
 * NULL, then the object is scaled on itself.
 * @param[in] cx X relative coordinate of the center point. The left end is 0.0
 * and the right end is 1.0 (the center is 0.5).
 * @param[in] cy Y relative coordinate of the center point. The top end is 0.0
 * and the bottom end is 1.0 (the center is 0.5).
 *
 * @ingroup Efl_Canvas_Animation_Scale
 */
EOAPI void efl_animation_scale_set(Eo *obj, double from_scale_x, double from_scale_y, double to_scale_x, double to_scale_y, Efl_Canvas_Object *pivot, double cx, double cy);

/**
 * @brief Scale property
 *
 * @param[in] obj The object.
 * @param[out] from_scale_x Scale factor along x axis when animation starts
 * @param[out] from_scale_y Scale factor along y axis when animation starts
 * @param[out] to_scale_x Scale factor along x axis when animation ends
 * @param[out] to_scale_y Scale factor along y axis when animation ends
 * @param[out] pivot Pivot object for the center point. If the pivot object is
 * NULL, then the object is scaled on itself.
 * @param[out] cx X relative coordinate of the center point. The left end is
 * 0.0 and the right end is 1.0 (the center is 0.5).
 * @param[out] cy Y relative coordinate of the center point. The top end is 0.0
 * and the bottom end is 1.0 (the center is 0.5).
 *
 * @ingroup Efl_Canvas_Animation_Scale
 */
EOAPI void efl_animation_scale_get(const Eo *obj, double *from_scale_x, double *from_scale_y, double *to_scale_x, double *to_scale_y, Efl_Canvas_Object **pivot, double *cx, double *cy);

/**
 * @brief Scale absolute property
 *
 * @param[in] obj The object.
 * @param[in] from_scale_x Scale factor along x axis when animation starts
 * @param[in] from_scale_y Scale factor along y axis when animation starts
 * @param[in] to_scale_x Scale factor along x axis when animation ends
 * @param[in] to_scale_y Scale factor along y axis when animation ends
 * @param[in] cx X absolute coordinate of the center point.
 * @param[in] cy Y absolute coordinate of the center point.
 *
 * @ingroup Efl_Canvas_Animation_Scale
 */
EOAPI void efl_animation_scale_absolute_set(Eo *obj, double from_scale_x, double from_scale_y, double to_scale_x, double to_scale_y, int cx, int cy);

/**
 * @brief Scale absolute property
 *
 * @param[in] obj The object.
 * @param[out] from_scale_x Scale factor along x axis when animation starts
 * @param[out] from_scale_y Scale factor along y axis when animation starts
 * @param[out] to_scale_x Scale factor along x axis when animation ends
 * @param[out] to_scale_y Scale factor along y axis when animation ends
 * @param[out] cx X absolute coordinate of the center point.
 * @param[out] cy Y absolute coordinate of the center point.
 *
 * @ingroup Efl_Canvas_Animation_Scale
 */
EOAPI void efl_animation_scale_absolute_get(const Eo *obj, double *from_scale_x, double *from_scale_y, double *to_scale_x, double *to_scale_y, int *cx, int *cy);

#endif
