
/* GENERATED CODE... DO NOT EDIT */

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Copyright (C) 2013 - 2018 Aleksander Morgado <aleksander@aleksander.es>
 */


#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>

#include "mbim-message.h"
#include "mbim-device.h"
#include "mbim-enums.h"

#ifndef __LIBMBIM_GLIB_MBIM_MS_BASIC_CONNECT_EXTENSIONS__
#define __LIBMBIM_GLIB_MBIM_MS_BASIC_CONNECT_EXTENSIONS__

G_BEGIN_DECLS

/*****************************************************************************/
/* Struct: MbimPcoValue */

/**
 * MbimPcoValue:
 * @session_id: a #guint32.
 * @pco_data_size: a #guint32.
 * @pco_data_type: a #guint32.
 * @pco_data_buffer: an array of #guint8 values.
 */
typedef struct {
    guint32 session_id;
    guint32 pco_data_size;
    guint32 pco_data_type;
    guint8 *pco_data_buffer;
} MbimPcoValue;

void mbim_pco_value_free (MbimPcoValue *var);

/*****************************************************************************/
/* Struct: MbimLteAttachConfiguration */

/**
 * MbimLteAttachConfiguration:
 * @ip_type: a #guint32.
 * @roaming: a #guint32.
 * @source: a #guint32.
 * @access_string: a string.
 * @user_name: a string.
 * @password: a string.
 * @compression: a #guint32.
 * @auth_protocol: a #guint32.
 */
typedef struct {
    guint32 ip_type;
    guint32 roaming;
    guint32 source;
    gchar *access_string;
    gchar *user_name;
    gchar *password;
    guint32 compression;
    guint32 auth_protocol;
} MbimLteAttachConfiguration;

void mbim_lte_attach_configuration_array_free (MbimLteAttachConfiguration **array);

/*****************************************************************************/
/* Struct: MbimLteAttachStatus */

/**
 * MbimLteAttachStatus:
 * @lte_attach_state: a #guint32.
 * @ip_type: a #guint32.
 * @access_string: a string.
 * @user_name: a string.
 * @password: a string.
 * @compression: a #guint32.
 * @auth_protocol: a #guint32.
 */
typedef struct {
    guint32 lte_attach_state;
    guint32 ip_type;
    gchar *access_string;
    gchar *user_name;
    gchar *password;
    guint32 compression;
    guint32 auth_protocol;
} MbimLteAttachStatus;

void mbim_lte_attach_status_free (MbimLteAttachStatus *var);

/*****************************************************************************/
/* Message (Query): MBIM Message Ms Basic Connect Extensions PCO */

MbimMessage *mbim_message_ms_basic_connect_extensions_pco_query_new (
    const MbimPcoValue *pco_value,
    GError **error);

/*****************************************************************************/
/* Message (Response): MBIM Message Ms Basic Connect Extensions PCO */

gboolean mbim_message_ms_basic_connect_extensions_pco_response_parse (
    const MbimMessage *message,
    MbimPcoValue **pco_value,
    GError **error);

/*****************************************************************************/
/* Message (Notification): MBIM Message Ms Basic Connect Extensions PCO */

gboolean mbim_message_ms_basic_connect_extensions_pco_notification_parse (
    const MbimMessage *message,
    MbimPcoValue **pco_value,
    GError **error);

/*****************************************************************************/
/* Message (Query): MBIM Message Ms Basic Connect Extensions Lte Attach Configuration */

MbimMessage *mbim_message_ms_basic_connect_extensions_lte_attach_configuration_query_new (
    GError **error);

/*****************************************************************************/
/* Message (Set): MBIM Message Ms Basic Connect Extensions Lte Attach Configuration */

MbimMessage *mbim_message_ms_basic_connect_extensions_lte_attach_configuration_set_new (
    MbimLteAttachContextOperation operation,
    guint32 configuration_count,
    const MbimLteAttachConfiguration *const *configurations,
    GError **error);

/*****************************************************************************/
/* Message (Response): MBIM Message Ms Basic Connect Extensions Lte Attach Configuration */

gboolean mbim_message_ms_basic_connect_extensions_lte_attach_configuration_response_parse (
    const MbimMessage *message,
    guint32 *configuration_count,
    MbimLteAttachConfiguration ***configurations,
    GError **error);

/*****************************************************************************/
/* Message (Notification): MBIM Message Ms Basic Connect Extensions Lte Attach Configuration */

gboolean mbim_message_ms_basic_connect_extensions_lte_attach_configuration_notification_parse (
    const MbimMessage *message,
    guint32 *configuration_count,
    MbimLteAttachConfiguration ***configurations,
    GError **error);

/*****************************************************************************/
/* Message (Query): MBIM Message Ms Basic Connect Extensions Lte Attach Status */

MbimMessage *mbim_message_ms_basic_connect_extensions_lte_attach_status_query_new (
    GError **error);

/*****************************************************************************/
/* Message (Response): MBIM Message Ms Basic Connect Extensions Lte Attach Status */

gboolean mbim_message_ms_basic_connect_extensions_lte_attach_status_response_parse (
    const MbimMessage *message,
    MbimLteAttachStatus **lte_attach_status,
    GError **error);

/*****************************************************************************/
/* Message (Notification): MBIM Message Ms Basic Connect Extensions Lte Attach Status */

gboolean mbim_message_ms_basic_connect_extensions_lte_attach_status_notification_parse (
    const MbimMessage *message,
    MbimLteAttachStatus **lte_attach_status,
    GError **error);

/*****************************************************************************/
/* Service helper for printable fields */

#if defined (LIBMBIM_GLIB_COMPILATION)

G_GNUC_INTERNAL
gchar *
__mbim_message_ms_basic_connect_extensions_get_printable_fields (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error);

#endif

G_END_DECLS

#endif /* __LIBMBIM_GLIB_MBIM_MS_BASIC_CONNECT_EXTENSIONS__ */
