/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include "typedef.h"
#include "getput.h"
#include "datei.h"
#include "idem.h"

/***************************************************************************
@
@---------------------------------------------------------------------------
@
@ FILE: brav_from_datei.c
@
@---------------------------------------------------------------------------
@
****************************************************************************/


/***************************************************************************
@
@---------------------------------------------------------------------------
@
@ bravais_TYP *brav_from_datei(char *symb,int almost,int zclass)
@ 
@ Reads a single bravais group from the catalog.
@ The symbol, the number almost and zclass are exactly as in the
@ standalone Datei resp. Bravais_catalog
@
@---------------------------------------------------------------------------
@
****************************************************************************/
bravais_TYP *brav_from_datei(char *symb,int almost,int zclass)
{

   bravais_TYP *RES;

   symbol_out *S;

   matrix_TYP *X;

   char *file;

   int i=1;

   /* initialize */
   S = read_symbol_from_string(symb);
   get_zentr(S);

   while (i<almost){
      /* get the next almost decomposable group */
      i++;
      file = S->fn;
      free_bravais(S->grp);
      free(S);
      S = get_symbol(file);
      if (file != NULL) free(file);
   }


   if (zclass == 1){
      RES = S->grp;
   }
   else{
      RES = Z_class(S->grp,S->grp->zentr[zclass-2]);
      free_bravais(S->grp);
   }

   if (S->fn != NULL) free(S->fn);
   free(S);

   return RES;

}

