/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.HomeObject;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Camera
extends HomeObject {
    private static final long serialVersionUID = 1L;
    private String name;
    private float x;
    private float y;
    private float z;
    private float yaw;
    private float pitch;
    private float fieldOfView;
    private long time;
    private transient Lens lens;
    private String lensName;
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public Camera(float f, float f2, float f3, float f4, float f5, float f6) {
        this(f, f2, f3, f4, f5, f6, Camera.midday(), Lens.PINHOLE);
    }

    public Camera(float f, float f2, float f3, float f4, float f5, float f6, long l, Lens lens) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.yaw = f4;
        this.pitch = f5;
        this.fieldOfView = f6;
        this.time = l;
        this.lens = lens;
    }

    private static long midday() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        gregorianCalendar.set(11, 12);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        return gregorianCalendar.getTimeInMillis();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.time = Camera.midday();
        this.lens = Lens.PINHOLE;
        objectInputStream.defaultReadObject();
        try {
            if (this.lensName != null) {
                this.lens = Lens.valueOf(this.lensName);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.lensName = this.lens.name();
        objectOutputStream.defaultWriteObject();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (!(string == this.name || string != null && string.equals(this.name))) {
            String string2 = this.name;
            this.name = string;
            this.propertyChangeSupport.firePropertyChange(Property.NAME.name(), string2, string);
        }
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setYaw(float f) {
        if (f != this.yaw) {
            float f2 = this.yaw;
            this.yaw = f;
            this.propertyChangeSupport.firePropertyChange(Property.YAW.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitch(float f) {
        if (f != this.pitch) {
            float f2 = this.pitch;
            this.pitch = f;
            this.propertyChangeSupport.firePropertyChange(Property.PITCH.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getFieldOfView() {
        return this.fieldOfView;
    }

    public void setFieldOfView(float f) {
        if (f != this.fieldOfView) {
            float f2 = this.fieldOfView;
            this.fieldOfView = f;
            this.propertyChangeSupport.firePropertyChange(Property.FIELD_OF_VIEW.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getX() {
        return this.x;
    }

    public void setX(float f) {
        if (f != this.x) {
            float f2 = this.x;
            this.x = f;
            this.propertyChangeSupport.firePropertyChange(Property.X.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getY() {
        return this.y;
    }

    public void setY(float f) {
        if (f != this.y) {
            float f2 = this.y;
            this.y = f;
            this.propertyChangeSupport.firePropertyChange(Property.Y.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getZ() {
        return this.z;
    }

    public void setZ(float f) {
        if (f != this.z) {
            float f2 = this.z;
            this.z = f;
            this.propertyChangeSupport.firePropertyChange(Property.Z.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long l) {
        if (this.time != l) {
            long l2 = this.time;
            this.time = l;
            this.propertyChangeSupport.firePropertyChange(Property.TIME.name(), l2, l);
        }
    }

    public static long convertTimeToTimeZone(long l, String string) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        gregorianCalendar.setTimeInMillis(l);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(TimeZone.getTimeZone(string));
        gregorianCalendar2.set(1, gregorianCalendar.get(1));
        gregorianCalendar2.set(2, gregorianCalendar.get(2));
        gregorianCalendar2.set(5, gregorianCalendar.get(5));
        gregorianCalendar2.set(11, gregorianCalendar.get(11));
        gregorianCalendar2.set(12, gregorianCalendar.get(12));
        gregorianCalendar2.set(13, gregorianCalendar.get(13));
        gregorianCalendar2.set(14, gregorianCalendar.get(14));
        return gregorianCalendar2.getTimeInMillis();
    }

    public Lens getLens() {
        return this.lens;
    }

    public void setLens(Lens lens) {
        if (lens != this.lens) {
            Lens lens2 = this.lens;
            this.lens = lens;
            this.propertyChangeSupport.firePropertyChange(Property.LENS.name(), (Object)lens2, (Object)lens);
        }
    }

    public void setCamera(Camera camera) {
        this.setX(camera.getX());
        this.setY(camera.getY());
        this.setZ(camera.getZ());
        this.setYaw(camera.getYaw());
        this.setPitch(camera.getPitch());
        this.setFieldOfView(camera.getFieldOfView());
    }

    @Override
    public Camera clone() {
        Camera camera = (Camera)super.clone();
        camera.propertyChangeSupport = new PropertyChangeSupport(camera);
        return camera;
    }

    public static enum Property {
        NAME,
        X,
        Y,
        Z,
        YAW,
        PITCH,
        FIELD_OF_VIEW,
        TIME,
        LENS;

    }

    public static enum Lens {
        PINHOLE,
        NORMAL,
        FISHEYE,
        SPHERICAL;

    }
}

