/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BehaviorStructure;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.VirtualUniverse;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupIndexedList;

public final class WakeupOnElapsedFrames
extends WakeupCriterion {
    static final int COND_IN_BS_LIST = 0;
    static final int TOTAL_INDEXED_UNORDER_SET_TYPES = 1;
    boolean passive;
    int frameCount;
    int countdown;

    public WakeupOnElapsedFrames(int n) {
        this(n, false);
    }

    public WakeupOnElapsedFrames(int n, boolean bl) {
        if (n < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("WakeupOnElapsedFrames0"));
        }
        this.frameCount = n;
        this.passive = bl;
        WakeupIndexedList.init(this, 1);
    }

    public int getElapsedFrameCount() {
        return this.frameCount;
    }

    public boolean isPassive() {
        return this.passive;
    }

    void newFrame() {
        if (this.countdown == 0) {
            this.setTriggered();
        } else {
            --this.countdown;
        }
    }

    @Override
    void addBehaviorCondition(BehaviorStructure behaviorStructure) {
        this.countdown = this.frameCount;
        behaviorStructure.wakeupOnElapsedFrames.add(this);
        if (!this.passive && this.behav != null && this.behav.enable) {
            ++behaviorStructure.activeWakeupOnFrameCount;
        }
        VirtualUniverse.mc.sendRunMessage(behaviorStructure.universe, 256);
    }

    @Override
    void removeBehaviorCondition(BehaviorStructure behaviorStructure) {
        behaviorStructure.wakeupOnElapsedFrames.remove(this);
        if (!this.passive && this.behav != null && this.behav.enable) {
            --behaviorStructure.activeWakeupOnFrameCount;
        }
    }

    @Override
    void resetBehaviorCondition(BehaviorStructure behaviorStructure) {
        this.countdown = this.frameCount;
    }
}

