/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lucene.index.FilterableTermsEnum;
import org.elasticsearch.common.lucene.index.FreqTermsEnum;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.BucketUtils;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantTextAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantTextAggregator;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.SearchContext;

public class SignificantTextAggregatorFactory
extends AggregatorFactory<SignificantTextAggregatorFactory>
implements Releasable {
    private final IncludeExclude includeExclude;
    private String indexedFieldName;
    private MappedFieldType fieldType;
    private final String[] sourceFieldNames;
    private FilterableTermsEnum termsEnum;
    private int numberOfAggregatorsCreated;
    private final Query filter;
    private final int supersetNumDocs;
    private final TermsAggregator.BucketCountThresholds bucketCountThresholds;
    private final SignificanceHeuristic significanceHeuristic;
    private final DocValueFormat format = DocValueFormat.RAW;
    private final boolean filterDuplicateText;

    public SignificantTextAggregatorFactory(String name, IncludeExclude includeExclude, QueryBuilder filterBuilder, TermsAggregator.BucketCountThresholds bucketCountThresholds, SignificanceHeuristic significanceHeuristic, SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder, String fieldName, String[] sourceFieldNames, boolean filterDuplicateText, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, subFactoriesBuilder, metaData);
        String[] stringArray;
        this.fieldType = context.getQueryShardContext().fieldMapper(fieldName);
        String string = this.indexedFieldName = this.fieldType != null ? this.fieldType.name() : fieldName;
        if (sourceFieldNames == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.indexedFieldName;
        } else {
            stringArray = sourceFieldNames;
        }
        this.sourceFieldNames = stringArray;
        this.includeExclude = includeExclude;
        this.filter = filterBuilder == null ? null : filterBuilder.toQuery(context.getQueryShardContext());
        this.filterDuplicateText = filterDuplicateText;
        ContextIndexSearcher searcher = context.searcher();
        this.supersetNumDocs = this.filter == null ? searcher.getIndexReader().maxDoc() : searcher.count(this.filter);
        this.bucketCountThresholds = bucketCountThresholds;
        this.significanceHeuristic = significanceHeuristic;
    }

    public long getSupersetNumDocs() {
        return this.supersetNumDocs;
    }

    private FilterableTermsEnum getTermsEnum(String field) throws IOException {
        if (this.termsEnum != null) {
            return this.termsEnum;
        }
        IndexReader reader = this.context.searcher().getIndexReader();
        this.termsEnum = this.numberOfAggregatorsCreated > 1 ? new FreqTermsEnum(reader, field, true, false, this.filter, this.context.bigArrays()) : new FilterableTermsEnum(reader, this.indexedFieldName, 0, this.filter);
        return this.termsEnum;
    }

    private long getBackgroundFrequency(String value) throws IOException {
        Query query = this.fieldType.termQuery(value, this.context.getQueryShardContext());
        if (query instanceof TermQuery) {
            Term term = ((TermQuery)query).getTerm();
            FilterableTermsEnum termsEnum = this.getTermsEnum(term.field());
            if (termsEnum.seekExact(term.bytes())) {
                return termsEnum.docFreq();
            }
            return 0L;
        }
        if (this.filter != null) {
            query = new BooleanQuery.Builder().add(query, BooleanClause.Occur.FILTER).add(this.filter, BooleanClause.Occur.FILTER).build();
        }
        return this.context.searcher().count(query);
    }

    public long getBackgroundFrequency(BytesRef termBytes) throws IOException {
        String value = this.format.format(termBytes).toString();
        return this.getBackgroundFrequency(value);
    }

    @Override
    public void close() {
        try {
            if (this.termsEnum instanceof Releasable) {
                ((Releasable)((Object)this.termsEnum)).close();
            }
        }
        finally {
            this.termsEnum = null;
        }
    }

    @Override
    protected Aggregator createInternal(Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        if (!collectsFromSingleBucket) {
            return SignificantTextAggregatorFactory.asMultiBucketAggregator(this, this.context, parent);
        }
        ++this.numberOfAggregatorsCreated;
        TermsAggregator.BucketCountThresholds bucketCountThresholds = new TermsAggregator.BucketCountThresholds(this.bucketCountThresholds);
        if (bucketCountThresholds.getShardSize() == SignificantTextAggregationBuilder.DEFAULT_BUCKET_COUNT_THRESHOLDS.getShardSize()) {
            bucketCountThresholds.setShardSize(2 * BucketUtils.suggestShardSideQueueSize(bucketCountThresholds.getRequiredSize()));
        }
        IncludeExclude.StringFilter incExcFilter = this.includeExclude == null ? null : this.includeExclude.convertToStringFilter(DocValueFormat.RAW);
        return new SignificantTextAggregator(this.name, this.factories, this.context, parent, pipelineAggregators, bucketCountThresholds, incExcFilter, this.significanceHeuristic, this, this.indexedFieldName, this.sourceFieldNames, this.filterDuplicateText, metaData);
    }
}

