/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.jdk;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsProvider;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;

public final class IoDetailsProvider
extends DetailsProvider.Basic {
    private static final String FILE_MASK = "java.io.File+";
    private static final String ZIPFILE_MASK = "java.util.zip.ZipFile+";
    private static final String RAF_MASK = "java.io.RandomAccessFile";
    private static final String FIS_MASK = "java.io.FileInputStream";
    private static final String FOS_MASK = "java.io.FileOutputStream";
    private static final String FD_MASK = "java.io.FileDescriptor";
    private static final String FD_RAF_CLASS = "java.io.RandomAccessFile";
    private static final String FD_FIS_CLASS = "java.io.FileInputStream";
    private static final String FD_FOS_CLASS = "java.io.FileOutputStream";
    private static final String FCI_MASK = "sun.nio.ch.FileChannelImpl";
    private static final String HEAPCHARBUFFER_MASK = "java.nio.HeapCharBuffer";
    private static final Object CACHE_LOCK = new Object();
    private static WeakHashMap<Heap, Map<Long, String>> CACHE;

    public IoDetailsProvider() {
        super(FILE_MASK, ZIPFILE_MASK, "java.io.RandomAccessFile", "java.io.FileInputStream", "java.io.FileOutputStream", FD_MASK, FCI_MASK, HEAPCHARBUFFER_MASK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDetailsString(String string, Instance instance, Heap heap) {
        if (FILE_MASK.equals(string)) {
            return DetailsUtils.getInstanceFieldString(instance, "path", heap);
        }
        if (ZIPFILE_MASK.equals(string)) {
            return DetailsUtils.getInstanceFieldString(instance, "name", heap);
        }
        if ("java.io.RandomAccessFile".equals(string)) {
            return DetailsUtils.getInstanceFieldString(instance, "path", heap);
        }
        if ("java.io.FileInputStream".equals(string)) {
            return DetailsUtils.getInstanceFieldString(instance, "path", heap);
        }
        if ("java.io.FileOutputStream".equals(string)) {
            return DetailsUtils.getInstanceFieldString(instance, "path", heap);
        }
        if (FD_MASK.equals(string)) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                Map<Long, String> map;
                if (CACHE == null) {
                    CACHE = new WeakHashMap();
                }
                if ((map = CACHE.get(heap)) == null) {
                    map = this.computeFDCache(heap, instance.getJavaClass());
                    CACHE.put(heap, map);
                }
                return map.get(instance.getInstanceId());
            }
        }
        if (FCI_MASK.equals(string)) {
            return DetailsUtils.getInstanceFieldString(instance, "path", heap);
        }
        if (HEAPCHARBUFFER_MASK.equals(string)) {
            int n = DetailsUtils.getIntFieldValue(instance, "position", -1);
            int n2 = DetailsUtils.getIntFieldValue(instance, "limit", -1);
            int n3 = DetailsUtils.getIntFieldValue(instance, "offset", -1);
            return DetailsUtils.getPrimitiveArrayFieldString(instance, "hb", n + n3, n2 - n, null, "...");
        }
        return null;
    }

    private Map<Long, String> computeFDCache(Heap heap, JavaClass javaClass) {
        HashMap<Long, String> hashMap = new HashMap<Long, String>();
        this.computeFDCacheForClass(heap, "java.io.RandomAccessFile", "fd", hashMap);
        this.computeFDCacheForClass(heap, "java.io.FileInputStream", "fd", hashMap);
        this.computeFDCacheForClass(heap, "java.io.FileOutputStream", "fd", hashMap);
        this.computeStdDescriptor(javaClass, "in", "Standard Input", hashMap);
        this.computeStdDescriptor(javaClass, "out", "Standard Output", hashMap);
        this.computeStdDescriptor(javaClass, "err", "Standard Error", hashMap);
        return hashMap;
    }

    private void computeFDCacheForClass(Heap heap, String string, String string2, Map<Long, String> map) {
        JavaClass javaClass = heap.getJavaClassByName(string);
        if (javaClass != null) {
            for (Instance instance : javaClass.getInstances()) {
                String string3;
                Instance instance2 = (Instance)instance.getValueOfField(string2);
                if (instance2 == null || (string3 = this.getDetailsString(string, instance, heap)) == null) continue;
                map.put(instance2.getInstanceId(), string3);
            }
        }
    }

    private void computeStdDescriptor(JavaClass javaClass, String string, String string2, Map<Long, String> map) {
        Instance instance = (Instance)javaClass.getValueOfStaticField(string);
        if (instance != null) {
            map.put(instance.getInstanceId(), string2);
        }
    }
}

