/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import org.gradle.api.file.FileTreeElement;
import org.gradle.internal.file.FileMetadataSnapshot;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.WellKnownFileLocations;

public class SplitFileHasher
implements FileHasher {
    private final FileHasher globalHasher;
    private final FileHasher localHasher;
    private final WellKnownFileLocations wellKnownFileLocations;

    public SplitFileHasher(FileHasher globalHasher, FileHasher localHasher, WellKnownFileLocations wellKnownFileLocations) {
        this.globalHasher = globalHasher;
        this.localHasher = localHasher;
        this.wellKnownFileLocations = wellKnownFileLocations;
    }

    public HashCode hash(File file) {
        if (this.wellKnownFileLocations.isImmutable(file.getPath())) {
            return this.globalHasher.hash(file);
        }
        return this.localHasher.hash(file);
    }

    public HashCode hash(FileTreeElement fileDetails) {
        if (this.wellKnownFileLocations.isImmutable(fileDetails.getFile().getPath())) {
            return this.globalHasher.hash(fileDetails);
        }
        return this.localHasher.hash(fileDetails);
    }

    public HashCode hash(File file, FileMetadataSnapshot fileDetails) {
        if (this.wellKnownFileLocations.isImmutable(file.getPath())) {
            return this.globalHasher.hash(file, fileDetails);
        }
        return this.localHasher.hash(file, fileDetails);
    }
}

