/*
 * Decompiled with CFR 0.152.
 */
package grails.validation;

import org.grails.core.exceptions.GrailsException;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;

public class ValidationException
extends GrailsException {
    private static final long serialVersionUID = 1L;
    private Errors errors;
    private String fullMessage;

    public ValidationException(String msg, Errors e) {
        super(msg);
        this.errors = e;
        this.fullMessage = ValidationException.formatErrors(e, msg);
    }

    public Errors getErrors() {
        return this.errors;
    }

    @Override
    public String getMessage() {
        return this.fullMessage;
    }

    public static String formatErrors(Errors errors) {
        return ValidationException.formatErrors(errors, null);
    }

    public static String formatErrors(Errors errors, String msg) {
        StringBuilder b = new StringBuilder();
        if (msg != null && msg.length() > 0) {
            b.append(msg).append(":\n");
        }
        for (ObjectError error : errors.getAllErrors()) {
            b.append("- ").append(error).append("\n");
        }
        return b.toString();
    }
}

