/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.util;

public final class PoolUtils {
    private static final String GPARS_POOLSIZE = "gpars.poolsize";

    private PoolUtils() {
    }

    public static int retrieveDefaultPoolSize() {
        String poolSizeValue = System.getProperty(GPARS_POOLSIZE);
        if (poolSizeValue == null) {
            return PoolUtils.defaultPoolSize();
        }
        try {
            return Integer.parseInt(poolSizeValue);
        }
        catch (NumberFormatException ignored) {
            return PoolUtils.defaultPoolSize();
        }
    }

    private static int defaultPoolSize() {
        return Runtime.getRuntime().availableProcessors() + 1;
    }

    public static void checkValidPoolSize(int poolSize) {
        if (poolSize <= 0) {
            throw new IllegalStateException("Pool size must be a positive number.");
        }
    }
}

