//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.2
//
// <auto-generated>
//
// Generated from file `PermissionsVerifier.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __Glacier2_PermissionsVerifier_h__
#define __Glacier2_PermissionsVerifier_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/SlicedDataF.h>
#include <Glacier2/SSLInfo.h>
#include <IceUtil/UndefSysMacros.h>
#include <Glacier2/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 2
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef GLACIER2_API
#   if defined(ICE_STATIC_LIBS)
#       define GLACIER2_API /**/
#   elif defined(GLACIER2_API_EXPORTS)
#       define GLACIER2_API ICE_DECLSPEC_EXPORT
#   else
#       define GLACIER2_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace Glacier2
{

class PermissionsVerifier;
class PermissionsVerifierPrx;
class SSLPermissionsVerifier;
class SSLPermissionsVerifierPrx;

}

namespace Glacier2
{

/**
 * This exception is raised if a client is denied the ability to create
 * a session with the router.
 * \headerfile Glacier2/Glacier2.h
 */
class ICE_CLASS(GLACIER2_API) PermissionDeniedException : public ::Ice::UserExceptionHelper<PermissionDeniedException, ::Ice::UserException>
{
public:

    ICE_MEMBER(GLACIER2_API) virtual ~PermissionDeniedException();

    PermissionDeniedException(const PermissionDeniedException&) = default;

    PermissionDeniedException() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param reason The reason why permission was denied.
     */
    PermissionDeniedException(const ::std::string& reason) :
        reason(::std::move(reason))
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

    /**
     * The reason why permission was denied.
     */
    ::std::string reason;

    /**
     * Obtains the SlicedData object created when an unknown exception type was marshaled
     * in the sliced format and the Ice run time sliced it to a known type.
     * @return The SlicedData object, or nil if the exception was not sliced or was not
     * marshaled in the sliced format.
     */
    ICE_MEMBER(GLACIER2_API) virtual ::std::shared_ptr<::Ice::SlicedData> ice_getSlicedData() const override;

    /// \cond STREAM
    ICE_MEMBER(GLACIER2_API) virtual void _write(::Ice::OutputStream*) const override;
    ICE_MEMBER(GLACIER2_API) virtual void _read(::Ice::InputStream*) override;

    ::std::shared_ptr<::Ice::SlicedData> _slicedData;
    /// \endcond
};

/// \cond INTERNAL
static PermissionDeniedException _iceS_PermissionDeniedException_init;
/// \endcond

}

namespace Glacier2
{

/**
 * The Glacier2 permissions verifier. This is called through the
 * process of establishing a session.
 * @see Router
 * \headerfile Glacier2/Glacier2.h
 */
class GLACIER2_API PermissionsVerifier : public virtual ::Ice::Object
{
public:

    using ProxyType = PermissionsVerifierPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Encapsulates the results of a call to checkPermissions.
     */
    struct CheckPermissionsResult
    {
        /** True if access is granted, or false otherwise. */
        bool returnValue;
        /** The reason why access was denied. */
        ::std::string reason;
    };

    /**
     * Check whether a user has permission to access the router.
     * @param userId The user id for which to check permission.
     * @param password The user's password.
     * @param reason The reason why access was denied.
     * @param current The Current object for the invocation.
     * @return True if access is granted, or false otherwise.
     * @throws Glacier2::PermissionDeniedException Raised if the user access is
     * denied. This can be raised in place of returning false with a
     * reason set in the reason out parameter.
     */
    virtual bool checkPermissions(::std::string userId, ::std::string password, ::std::string& reason, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_checkPermissions(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

/**
 * The SSL Glacier2 permissions verifier. This is called through the
 * process of establishing a session.
 * @see Router
 * \headerfile Glacier2/Glacier2.h
 */
class GLACIER2_API SSLPermissionsVerifier : public virtual ::Ice::Object
{
public:

    using ProxyType = SSLPermissionsVerifierPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Encapsulates the results of a call to authorize.
     */
    struct AuthorizeResult
    {
        /** True if access is granted, or false otherwise. */
        bool returnValue;
        /** The reason why access was denied. */
        ::std::string reason;
    };

    /**
     * Check whether a user has permission to access the router.
     * @param info The SSL information.
     * @param reason The reason why access was denied.
     * @param current The Current object for the invocation.
     * @return True if access is granted, or false otherwise.
     * @throws Glacier2::PermissionDeniedException Raised if the user access is
     * denied. This can be raised in place of returning false with a
     * reason set in the reason out parameter.
     * @see SSLInfo
     */
    virtual bool authorize(SSLInfo info, ::std::string& reason, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_authorize(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

}

namespace Glacier2
{

/**
 * The Glacier2 permissions verifier. This is called through the
 * process of establishing a session.
 * @see Router
 * \headerfile Glacier2/Glacier2.h
 */
class ICE_CLASS(GLACIER2_API) PermissionsVerifierPrx : public virtual ::Ice::Proxy<PermissionsVerifierPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Check whether a user has permission to access the router.
     * @param userId The user id for which to check permission.
     * @param password The user's password.
     * @param reason The reason why access was denied.
     * @param context The Context map to send with the invocation.
     * @return True if access is granted, or false otherwise.
     * @throws Glacier2::PermissionDeniedException Raised if the user access is
     * denied. This can be raised in place of returning false with a
     * reason set in the reason out parameter.
     */
    bool checkPermissions(const ::std::string& userId, const ::std::string& password, ::std::string& reason, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _result = _makePromiseOutgoing<PermissionsVerifier::CheckPermissionsResult>(true, this, &PermissionsVerifierPrx::_iceI_checkPermissions, userId, password, context).get();
        reason = ::std::move(_result.reason);
        return _result.returnValue;
    }

    /**
     * Check whether a user has permission to access the router.
     * @param userId The user id for which to check permission.
     * @param password The user's password.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto checkPermissionsAsync(const ::std::string& userId, const ::std::string& password, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<PermissionsVerifier::CheckPermissionsResult>>().get_future())
    {
        return _makePromiseOutgoing<PermissionsVerifier::CheckPermissionsResult, P>(false, this, &PermissionsVerifierPrx::_iceI_checkPermissions, userId, password, context);
    }

    /**
     * Check whether a user has permission to access the router.
     * @param userId The user id for which to check permission.
     * @param password The user's password.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    checkPermissionsAsync(const ::std::string& userId, const ::std::string& password,
                          ::std::function<void(bool, ::std::string)> response,
                          ::std::function<void(::std::exception_ptr)> ex = nullptr,
                          ::std::function<void(bool)> sent = nullptr,
                          const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _responseCb = [response](PermissionsVerifier::CheckPermissionsResult&& _result)
        {
            response(_result.returnValue, ::std::move(_result.reason));
        };
        return _makeLamdaOutgoing<PermissionsVerifier::CheckPermissionsResult>(_responseCb, ex, sent, this, &Glacier2::PermissionsVerifierPrx::_iceI_checkPermissions, userId, password, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(GLACIER2_API) void _iceI_checkPermissions(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<PermissionsVerifier::CheckPermissionsResult>>&, const ::std::string&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    PermissionsVerifierPrx() = default;
    friend ::std::shared_ptr<PermissionsVerifierPrx> IceInternal::createProxy<PermissionsVerifierPrx>();

    ICE_MEMBER(GLACIER2_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * The SSL Glacier2 permissions verifier. This is called through the
 * process of establishing a session.
 * @see Router
 * \headerfile Glacier2/Glacier2.h
 */
class ICE_CLASS(GLACIER2_API) SSLPermissionsVerifierPrx : public virtual ::Ice::Proxy<SSLPermissionsVerifierPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Check whether a user has permission to access the router.
     * @param info The SSL information.
     * @param reason The reason why access was denied.
     * @param context The Context map to send with the invocation.
     * @return True if access is granted, or false otherwise.
     * @throws Glacier2::PermissionDeniedException Raised if the user access is
     * denied. This can be raised in place of returning false with a
     * reason set in the reason out parameter.
     * @see SSLInfo
     */
    bool authorize(const SSLInfo& info, ::std::string& reason, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _result = _makePromiseOutgoing<SSLPermissionsVerifier::AuthorizeResult>(true, this, &SSLPermissionsVerifierPrx::_iceI_authorize, info, context).get();
        reason = ::std::move(_result.reason);
        return _result.returnValue;
    }

    /**
     * Check whether a user has permission to access the router.
     * @param info The SSL information.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     * @see SSLInfo
     */
    template<template<typename> class P = ::std::promise>
    auto authorizeAsync(const SSLInfo& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<SSLPermissionsVerifier::AuthorizeResult>>().get_future())
    {
        return _makePromiseOutgoing<SSLPermissionsVerifier::AuthorizeResult, P>(false, this, &SSLPermissionsVerifierPrx::_iceI_authorize, info, context);
    }

    /**
     * Check whether a user has permission to access the router.
     * @param info The SSL information.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     * @see SSLInfo
     */
    ::std::function<void()>
    authorizeAsync(const SSLInfo& info,
                   ::std::function<void(bool, ::std::string)> response,
                   ::std::function<void(::std::exception_ptr)> ex = nullptr,
                   ::std::function<void(bool)> sent = nullptr,
                   const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _responseCb = [response](SSLPermissionsVerifier::AuthorizeResult&& _result)
        {
            response(_result.returnValue, ::std::move(_result.reason));
        };
        return _makeLamdaOutgoing<SSLPermissionsVerifier::AuthorizeResult>(_responseCb, ex, sent, this, &Glacier2::SSLPermissionsVerifierPrx::_iceI_authorize, info, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(GLACIER2_API) void _iceI_authorize(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<SSLPermissionsVerifier::AuthorizeResult>>&, const SSLInfo&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    SSLPermissionsVerifierPrx() = default;
    friend ::std::shared_ptr<SSLPermissionsVerifierPrx> IceInternal::createProxy<SSLPermissionsVerifierPrx>();

    ICE_MEMBER(GLACIER2_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

}

/// \cond STREAM
namespace Ice
{

template<typename S>
struct StreamReader<::Glacier2::PermissionDeniedException, S>
{
    static void read(S* istr, ::Glacier2::PermissionDeniedException& v)
    {
        istr->readAll(v.reason);
    }
};

}
/// \endcond

/// \cond INTERNAL
namespace Glacier2
{

using PermissionsVerifierPtr = ::std::shared_ptr<PermissionsVerifier>;
using PermissionsVerifierPrxPtr = ::std::shared_ptr<PermissionsVerifierPrx>;

using SSLPermissionsVerifierPtr = ::std::shared_ptr<SSLPermissionsVerifier>;
using SSLPermissionsVerifierPrxPtr = ::std::shared_ptr<SSLPermissionsVerifierPrx>;

}
/// \endcond

#else // C++98 mapping

namespace IceProxy
{

namespace Glacier2
{

class PermissionsVerifier;
/// \cond INTERNAL
GLACIER2_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< PermissionsVerifier>&);
GLACIER2_API ::IceProxy::Ice::Object* upCast(PermissionsVerifier*);
/// \endcond

class SSLPermissionsVerifier;
/// \cond INTERNAL
GLACIER2_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< SSLPermissionsVerifier>&);
GLACIER2_API ::IceProxy::Ice::Object* upCast(SSLPermissionsVerifier*);
/// \endcond

}

}

namespace Glacier2
{

class PermissionsVerifier;
/// \cond INTERNAL
GLACIER2_API ::Ice::Object* upCast(PermissionsVerifier*);
/// \endcond
typedef ::IceInternal::Handle< PermissionsVerifier> PermissionsVerifierPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Glacier2::PermissionsVerifier> PermissionsVerifierPrx;
typedef PermissionsVerifierPrx PermissionsVerifierPrxPtr;
/// \cond INTERNAL
GLACIER2_API void _icePatchObjectPtr(PermissionsVerifierPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class SSLPermissionsVerifier;
/// \cond INTERNAL
GLACIER2_API ::Ice::Object* upCast(SSLPermissionsVerifier*);
/// \endcond
typedef ::IceInternal::Handle< SSLPermissionsVerifier> SSLPermissionsVerifierPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Glacier2::SSLPermissionsVerifier> SSLPermissionsVerifierPrx;
typedef SSLPermissionsVerifierPrx SSLPermissionsVerifierPrxPtr;
/// \cond INTERNAL
GLACIER2_API void _icePatchObjectPtr(SSLPermissionsVerifierPtr&, const ::Ice::ObjectPtr&);
/// \endcond

}

namespace Glacier2
{

/**
 * This exception is raised if a client is denied the ability to create
 * a session with the router.
 * \headerfile Glacier2/Glacier2.h
 */
class GLACIER2_API PermissionDeniedException : public ::Ice::UserException
{
public:

    PermissionDeniedException() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param reason The reason why permission was denied.
     */
    explicit PermissionDeniedException(const ::std::string& reason);
    virtual ~PermissionDeniedException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual PermissionDeniedException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The reason why permission was denied.
     */
    ::std::string reason;

    /**
     * Obtains the SlicedData object created when an unknown exception type was marshaled
     * in the sliced format and the Ice run time sliced it to a known type.
     * @return The SlicedData object, or nil if the exception was not sliced or was not
     * marshaled in the sliced format.
     */
    virtual ::Ice::SlicedDataPtr ice_getSlicedData() const;

    /// \cond STREAM
    virtual void _write(::Ice::OutputStream*) const;
    virtual void _read(::Ice::InputStream*);
    using ::Ice::UserException::_write;
    using ::Ice::UserException::_read;
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond

    /// \cond STREAM
    ::Ice::SlicedDataPtr _slicedData;
    /// \endcond
};

/// \cond INTERNAL
static PermissionDeniedException _iceS_PermissionDeniedException_init;
/// \endcond

}

namespace Glacier2
{

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Glacier2::PermissionsVerifier::begin_checkPermissions.
 * Create a wrapper instance by calling ::Glacier2::newCallback_PermissionsVerifier_checkPermissions.
 */
class Callback_PermissionsVerifier_checkPermissions_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_PermissionsVerifier_checkPermissions_Base> Callback_PermissionsVerifier_checkPermissionsPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Glacier2::SSLPermissionsVerifier::begin_authorize.
 * Create a wrapper instance by calling ::Glacier2::newCallback_SSLPermissionsVerifier_authorize.
 */
class Callback_SSLPermissionsVerifier_authorize_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_SSLPermissionsVerifier_authorize_Base> Callback_SSLPermissionsVerifier_authorizePtr;

}

namespace IceProxy
{

namespace Glacier2
{

class ICE_CLASS(GLACIER2_API) PermissionsVerifier : public virtual ::Ice::Proxy<PermissionsVerifier, ::IceProxy::Ice::Object>
{
public:

    /**
     * Check whether a user has permission to access the router.
     * @param userId The user id for which to check permission.
     * @param password The user's password.
     * @param reason The reason why access was denied.
     * @param context The Context map to send with the invocation.
     * @return True if access is granted, or false otherwise.
     * @throws Glacier2::PermissionDeniedException Raised if the user access is
     * denied. This can be raised in place of returning false with a
     * reason set in the reason out parameter.
     */
    ICE_MEMBER(GLACIER2_API) bool checkPermissions(const ::std::string& userId, const ::std::string& password, ::std::string& reason, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_checkPermissions(reason, _iceI_begin_checkPermissions(userId, password, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Check whether a user has permission to access the router.
     * @param userId The user id for which to check permission.
     * @param password The user's password.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_checkPermissions(const ::std::string& userId, const ::std::string& password, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_checkPermissions(userId, password, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Check whether a user has permission to access the router.
     * @param userId The user id for which to check permission.
     * @param password The user's password.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_checkPermissions(const ::std::string& userId, const ::std::string& password, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_checkPermissions(userId, password, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Check whether a user has permission to access the router.
     * @param userId The user id for which to check permission.
     * @param password The user's password.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_checkPermissions(const ::std::string& userId, const ::std::string& password, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_checkPermissions(userId, password, context, cb, cookie);
    }

    /**
     * Check whether a user has permission to access the router.
     * @param userId The user id for which to check permission.
     * @param password The user's password.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_checkPermissions(const ::std::string& userId, const ::std::string& password, const ::Glacier2::Callback_PermissionsVerifier_checkPermissionsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_checkPermissions(userId, password, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Check whether a user has permission to access the router.
     * @param userId The user id for which to check permission.
     * @param password The user's password.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_checkPermissions(const ::std::string& userId, const ::std::string& password, const ::Ice::Context& context, const ::Glacier2::Callback_PermissionsVerifier_checkPermissionsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_checkPermissions(userId, password, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_checkPermissions.
     * @param reason The reason why access was denied.
     * @param result The asynchronous result object for the invocation.
     * @return True if access is granted, or false otherwise.
     * @throws Glacier2::PermissionDeniedException Raised if the user access is
     * denied. This can be raised in place of returning false with a
     * reason set in the reason out parameter.
     */
    ICE_MEMBER(GLACIER2_API) bool end_checkPermissions(::std::string& reason, const ::Ice::AsyncResultPtr& result);
    /// \cond INTERNAL

    ICE_MEMBER(GLACIER2_API) void _iceI_end_checkPermissions(::std::string& iceP_reason, bool& ret, const ::Ice::AsyncResultPtr&);
    /// \endcond

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_checkPermissions(const ::std::string&, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(GLACIER2_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(GLACIER2_API) SSLPermissionsVerifier : public virtual ::Ice::Proxy<SSLPermissionsVerifier, ::IceProxy::Ice::Object>
{
public:

    /**
     * Check whether a user has permission to access the router.
     * @param info The SSL information.
     * @param reason The reason why access was denied.
     * @param context The Context map to send with the invocation.
     * @return True if access is granted, or false otherwise.
     * @throws Glacier2::PermissionDeniedException Raised if the user access is
     * denied. This can be raised in place of returning false with a
     * reason set in the reason out parameter.
     * @see SSLInfo
     */
    ICE_MEMBER(GLACIER2_API) bool authorize(const ::Glacier2::SSLInfo& info, ::std::string& reason, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_authorize(reason, _iceI_begin_authorize(info, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Check whether a user has permission to access the router.
     * @param info The SSL information.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see SSLInfo
     */
    ::Ice::AsyncResultPtr begin_authorize(const ::Glacier2::SSLInfo& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_authorize(info, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Check whether a user has permission to access the router.
     * @param info The SSL information.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see SSLInfo
     */
    ::Ice::AsyncResultPtr begin_authorize(const ::Glacier2::SSLInfo& info, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_authorize(info, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Check whether a user has permission to access the router.
     * @param info The SSL information.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see SSLInfo
     */
    ::Ice::AsyncResultPtr begin_authorize(const ::Glacier2::SSLInfo& info, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_authorize(info, context, cb, cookie);
    }

    /**
     * Check whether a user has permission to access the router.
     * @param info The SSL information.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see SSLInfo
     */
    ::Ice::AsyncResultPtr begin_authorize(const ::Glacier2::SSLInfo& info, const ::Glacier2::Callback_SSLPermissionsVerifier_authorizePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_authorize(info, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Check whether a user has permission to access the router.
     * @param info The SSL information.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see SSLInfo
     */
    ::Ice::AsyncResultPtr begin_authorize(const ::Glacier2::SSLInfo& info, const ::Ice::Context& context, const ::Glacier2::Callback_SSLPermissionsVerifier_authorizePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_authorize(info, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_authorize.
     * @param reason The reason why access was denied.
     * @param result The asynchronous result object for the invocation.
     * @return True if access is granted, or false otherwise.
     * @throws Glacier2::PermissionDeniedException Raised if the user access is
     * denied. This can be raised in place of returning false with a
     * reason set in the reason out parameter.
     */
    ICE_MEMBER(GLACIER2_API) bool end_authorize(::std::string& reason, const ::Ice::AsyncResultPtr& result);
    /// \cond INTERNAL

    ICE_MEMBER(GLACIER2_API) void _iceI_end_authorize(::std::string& iceP_reason, bool& ret, const ::Ice::AsyncResultPtr&);
    /// \endcond

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_authorize(const ::Glacier2::SSLInfo&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(GLACIER2_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

}

}

namespace Glacier2
{

/**
 * The Glacier2 permissions verifier. This is called through the
 * process of establishing a session.
 * @see Router
 * \headerfile Glacier2/Glacier2.h
 */
class GLACIER2_API PermissionsVerifier : public virtual ::Ice::Object
{
public:

    typedef PermissionsVerifierPrx ProxyType;
    typedef PermissionsVerifierPtr PointerType;

    virtual ~PermissionsVerifier();

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Check whether a user has permission to access the router.
     * @param userId The user id for which to check permission.
     * @param password The user's password.
     * @param reason The reason why access was denied.
     * @param current The Current object for the invocation.
     * @return True if access is granted, or false otherwise.
     * @throws Glacier2::PermissionDeniedException Raised if the user access is
     * denied. This can be raised in place of returning false with a
     * reason set in the reason out parameter.
     */
    virtual bool checkPermissions(const ::std::string& userId, const ::std::string& password, ::std::string& reason, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_checkPermissions(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const PermissionsVerifier& lhs, const PermissionsVerifier& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const PermissionsVerifier& lhs, const PermissionsVerifier& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * The SSL Glacier2 permissions verifier. This is called through the
 * process of establishing a session.
 * @see Router
 * \headerfile Glacier2/Glacier2.h
 */
class GLACIER2_API SSLPermissionsVerifier : public virtual ::Ice::Object
{
public:

    typedef SSLPermissionsVerifierPrx ProxyType;
    typedef SSLPermissionsVerifierPtr PointerType;

    virtual ~SSLPermissionsVerifier();

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Check whether a user has permission to access the router.
     * @param info The SSL information.
     * @param reason The reason why access was denied.
     * @param current The Current object for the invocation.
     * @return True if access is granted, or false otherwise.
     * @throws Glacier2::PermissionDeniedException Raised if the user access is
     * denied. This can be raised in place of returning false with a
     * reason set in the reason out parameter.
     * @see SSLInfo
     */
    virtual bool authorize(const SSLInfo& info, ::std::string& reason, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_authorize(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const SSLPermissionsVerifier& lhs, const SSLPermissionsVerifier& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const SSLPermissionsVerifier& lhs, const SSLPermissionsVerifier& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

}

/// \cond STREAM
namespace Ice
{

template<>
struct StreamableTraits< ::Glacier2::PermissionDeniedException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::Glacier2::PermissionDeniedException, S>
{
    static void write(S* ostr, const ::Glacier2::PermissionDeniedException& v)
    {
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::Glacier2::PermissionDeniedException, S>
{
    static void read(S* istr, ::Glacier2::PermissionDeniedException& v)
    {
        istr->read(v.reason);
    }
};

}
/// \endcond

namespace Glacier2
{

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Glacier2::PermissionsVerifier::begin_checkPermissions.
 * Create a wrapper instance by calling ::Glacier2::newCallback_PermissionsVerifier_checkPermissions.
 */
template<class T>
class CallbackNC_PermissionsVerifier_checkPermissions : public Callback_PermissionsVerifier_checkPermissions_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(bool, const ::std::string&);

    CallbackNC_PermissionsVerifier_checkPermissions(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        PermissionsVerifierPrx proxy = PermissionsVerifierPrx::uncheckedCast(result->getProxy());
        ::std::string iceP_reason;
        bool ret;
        try
        {
            ret = proxy->end_checkPermissions(iceP_reason, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret, iceP_reason);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::PermissionsVerifier::begin_checkPermissions.
 */
template<class T> Callback_PermissionsVerifier_checkPermissionsPtr
newCallback_PermissionsVerifier_checkPermissions(const IceUtil::Handle<T>& instance, void (T::*cb)(bool, const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_PermissionsVerifier_checkPermissions<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::PermissionsVerifier::begin_checkPermissions.
 */
template<class T> Callback_PermissionsVerifier_checkPermissionsPtr
newCallback_PermissionsVerifier_checkPermissions(T* instance, void (T::*cb)(bool, const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_PermissionsVerifier_checkPermissions<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Glacier2::PermissionsVerifier::begin_checkPermissions.
 * Create a wrapper instance by calling ::Glacier2::newCallback_PermissionsVerifier_checkPermissions.
 */
template<class T, typename CT>
class Callback_PermissionsVerifier_checkPermissions : public Callback_PermissionsVerifier_checkPermissions_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(bool, const ::std::string&, const CT&);

    Callback_PermissionsVerifier_checkPermissions(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        PermissionsVerifierPrx proxy = PermissionsVerifierPrx::uncheckedCast(result->getProxy());
        ::std::string iceP_reason;
        bool ret;
        try
        {
            ret = proxy->end_checkPermissions(iceP_reason, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, iceP_reason, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::PermissionsVerifier::begin_checkPermissions.
 */
template<class T, typename CT> Callback_PermissionsVerifier_checkPermissionsPtr
newCallback_PermissionsVerifier_checkPermissions(const IceUtil::Handle<T>& instance, void (T::*cb)(bool, const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_PermissionsVerifier_checkPermissions<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::PermissionsVerifier::begin_checkPermissions.
 */
template<class T, typename CT> Callback_PermissionsVerifier_checkPermissionsPtr
newCallback_PermissionsVerifier_checkPermissions(T* instance, void (T::*cb)(bool, const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_PermissionsVerifier_checkPermissions<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Glacier2::SSLPermissionsVerifier::begin_authorize.
 * Create a wrapper instance by calling ::Glacier2::newCallback_SSLPermissionsVerifier_authorize.
 */
template<class T>
class CallbackNC_SSLPermissionsVerifier_authorize : public Callback_SSLPermissionsVerifier_authorize_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(bool, const ::std::string&);

    CallbackNC_SSLPermissionsVerifier_authorize(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        SSLPermissionsVerifierPrx proxy = SSLPermissionsVerifierPrx::uncheckedCast(result->getProxy());
        ::std::string iceP_reason;
        bool ret;
        try
        {
            ret = proxy->end_authorize(iceP_reason, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret, iceP_reason);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SSLPermissionsVerifier::begin_authorize.
 */
template<class T> Callback_SSLPermissionsVerifier_authorizePtr
newCallback_SSLPermissionsVerifier_authorize(const IceUtil::Handle<T>& instance, void (T::*cb)(bool, const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SSLPermissionsVerifier_authorize<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SSLPermissionsVerifier::begin_authorize.
 */
template<class T> Callback_SSLPermissionsVerifier_authorizePtr
newCallback_SSLPermissionsVerifier_authorize(T* instance, void (T::*cb)(bool, const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SSLPermissionsVerifier_authorize<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Glacier2::SSLPermissionsVerifier::begin_authorize.
 * Create a wrapper instance by calling ::Glacier2::newCallback_SSLPermissionsVerifier_authorize.
 */
template<class T, typename CT>
class Callback_SSLPermissionsVerifier_authorize : public Callback_SSLPermissionsVerifier_authorize_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(bool, const ::std::string&, const CT&);

    Callback_SSLPermissionsVerifier_authorize(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        SSLPermissionsVerifierPrx proxy = SSLPermissionsVerifierPrx::uncheckedCast(result->getProxy());
        ::std::string iceP_reason;
        bool ret;
        try
        {
            ret = proxy->end_authorize(iceP_reason, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, iceP_reason, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SSLPermissionsVerifier::begin_authorize.
 */
template<class T, typename CT> Callback_SSLPermissionsVerifier_authorizePtr
newCallback_SSLPermissionsVerifier_authorize(const IceUtil::Handle<T>& instance, void (T::*cb)(bool, const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SSLPermissionsVerifier_authorize<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SSLPermissionsVerifier::begin_authorize.
 */
template<class T, typename CT> Callback_SSLPermissionsVerifier_authorizePtr
newCallback_SSLPermissionsVerifier_authorize(T* instance, void (T::*cb)(bool, const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SSLPermissionsVerifier_authorize<T, CT>(instance, cb, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
