/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.oql;

import com.sun.tools.visualvm.core.ui.components.ScrollableContainer;
import com.sun.tools.visualvm.heapviewer.HeapContext;
import com.sun.tools.visualvm.heapviewer.java.ClassNode;
import com.sun.tools.visualvm.heapviewer.java.InstanceNode;
import com.sun.tools.visualvm.heapviewer.model.DataType;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNode;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNodeFilter;
import com.sun.tools.visualvm.heapviewer.model.Progress;
import com.sun.tools.visualvm.heapviewer.model.RootNode;
import com.sun.tools.visualvm.heapviewer.model.TextNode;
import com.sun.tools.visualvm.heapviewer.oql.Bundle;
import com.sun.tools.visualvm.heapviewer.oql.OQLEditorComponent;
import com.sun.tools.visualvm.heapviewer.oql.OQLQueries;
import com.sun.tools.visualvm.heapviewer.ui.HTMLView;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewerActions;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewerFeature;
import com.sun.tools.visualvm.heapviewer.ui.PluggableTreeTableView;
import com.sun.tools.visualvm.heapviewer.ui.TreeTableViewColumn;
import com.sun.tools.visualvm.heapviewer.utils.HeapUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JExtendedSplitPane;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.swing.GrayLabel;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.OQLSupport;
import org.netbeans.modules.profiler.oql.engine.api.OQLEngine;
import org.netbeans.modules.profiler.oql.engine.api.OQLException;
import org.netbeans.modules.profiler.oql.engine.api.ReferenceChain;
import org.openide.util.RequestProcessor;

public class OQLConsoleView
extends HeapViewerFeature {
    private static final int RESULTS_LIMIT = Integer.parseInt(System.getProperty("OQLController.limitResults", "100"));
    private static final Color SEPARATOR_COLOR = UIManager.getColor("Separator.foreground");
    private static final Logger LOGGER = Logger.getLogger(OQLConsoleView.class.getName());
    private final HeapContext context;
    private final HeapViewerActions actions;
    private ProfilerToolbar toolbar;
    private ProfilerToolbar pluginsToolbar;
    private ProfilerToolbar resultsToolbar;
    private ProfilerToolbar progressToolbar;
    private JComponent component;
    private Action runAction;
    private Action cancelAction;
    private Action loadAction;
    private Action saveAction;
    private Action editAction;
    private JLabel progressLabel;
    private JProgressBar progressBar;
    private OQLEngine engine;
    private OQLEditorComponent editor;
    private JPanel resultsContainer;
    private HTMLView htmlView;
    private PluggableTreeTableView objectsView;
    private JToggleButton rObjects;
    private JToggleButton rHTML;
    private final AtomicBoolean analysisRunning = new AtomicBoolean(false);
    private final ExecutorService progressUpdater = Executors.newSingleThreadExecutor();
    private boolean queryValid;
    private Set<HeapViewerNode> nodeResults;
    private OQLSupport.Query currentQuery;

    public OQLConsoleView(HeapContext context, HeapViewerActions actions) {
        super("java_objects_oql", Bundle.OQLConsoleView_Name(), Bundle.OQLConsoleView_Description(), Icons.getIcon((String)"HeapWalkerIcons.OQLConsole"), 1000);
        this.context = context;
        this.actions = actions;
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            this.init();
        }
        return this.component;
    }

    @Override
    public ProfilerToolbar getToolbar() {
        if (this.toolbar == null) {
            this.init();
        }
        return this.toolbar;
    }

    private void init() {
        this.toolbar = ProfilerToolbar.create((boolean)false);
        this.component = new JPanel(new BorderLayout());
        this.component.setOpaque(true);
        this.component.setBackground(UIUtils.getProfilerResultsBackground());
        JLabel l = new JLabel(Bundle.OQLConsoleView_InitializingEngine(), 0);
        l.setEnabled(false);
        l.setOpaque(false);
        this.component.add((Component)l, "Center");
        new RequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                Heap heap = OQLConsoleView.this.context.getFragment().getHeap();
                if (OQLEngine.isOQLSupported()) {
                    try {
                        OQLConsoleView.this.engine = new OQLEngine(heap);
                        TreeTableViewColumn[] ownColumns = new TreeTableViewColumn[]{new TreeTableViewColumn.Name(heap), new TreeTableViewColumn.Count(heap, false, false), new TreeTableViewColumn.OwnSize(heap, true, true), new TreeTableViewColumn.RetainedSize(heap, true, false)};
                        OQLConsoleView.this.objectsView = new PluggableTreeTableView("java_objects_oql", OQLConsoleView.this.context, OQLConsoleView.this.actions, ownColumns){

                            @Override
                            protected HeapViewerNode[] computeData(RootNode root, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) {
                                if (OQLConsoleView.this.nodeResults == null) {
                                    return new HeapViewerNode[]{new TextNode(Bundle.OQLConsoleView_NothingExecuted())};
                                }
                                if (OQLConsoleView.this.nodeResults.isEmpty()) {
                                    return new HeapViewerNode[]{new TextNode(Bundle.OQLConsoleView_NoResults())};
                                }
                                return OQLConsoleView.this.nodeResults.toArray(HeapViewerNode.NO_NODES);
                            }
                        };
                        OQLConsoleView.this.objectsView.setViewName(Bundle.OQLConsoleView_ViewName());
                        String htmlS = Bundle.OQLConsoleView_NothingExecuted().replace("<", "&lt;").replace(">", "&gt;");
                        OQLConsoleView.this.htmlView = new HTMLView("java_objects_oql", OQLConsoleView.this.context, OQLConsoleView.this.actions, "<p>&nbsp;&nbsp;" + htmlS + "</p>"){

                            @Override
                            protected HeapViewerNode nodeForURL(URL url, HeapContext context) {
                                return OQLConsoleView.getNode(url, context);
                            }
                        };
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                OQLConsoleView.this.toolbar.addSpace(2);
                                OQLConsoleView.this.toolbar.addSeparator();
                                OQLConsoleView.this.toolbar.addSpace(5);
                                OQLConsoleView.this.toolbar.add((Component)new GrayLabel(Bundle.OQLConsoleView_OQLQuery()));
                                OQLConsoleView.this.toolbar.addSpace(2);
                                OQLConsoleView.this.runAction = new AbstractAction(Bundle.OQLConsoleView_RunAction(), Icons.getIcon((String)"GeneralIcons.Start")){
                                    {
                                        this.putValue("ShortDescription", Bundle.OQLConsoleView_RunActionTooltip());
                                    }

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        OQLConsoleView.this.executeQuery();
                                    }
                                };
                                JButton runButton = new JButton(OQLConsoleView.this.runAction){

                                    @Override
                                    public Dimension getPreferredSize() {
                                        Dimension d = super.getPreferredSize();
                                        d.width += 6;
                                        return d;
                                    }

                                    @Override
                                    public Dimension getMinimumSize() {
                                        return this.getPreferredSize();
                                    }

                                    @Override
                                    public Dimension getMaximumSize() {
                                        return this.getPreferredSize();
                                    }
                                };
                                OQLConsoleView.this.cancelAction = new AbstractAction(Bundle.OQLConsoleView_CancelAction(), Icons.getIcon((String)"GeneralIcons.Stop")){
                                    {
                                        this.putValue("ShortDescription", Bundle.OQLConsoleView_CancelActionTooltip());
                                    }

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        OQLConsoleView.this.cancelQuery();
                                    }
                                };
                                JButton cancelButton = new JButton(OQLConsoleView.this.cancelAction);
                                cancelButton.setHideActionText(true);
                                OQLConsoleView.this.loadAction = new AbstractAction(Bundle.OQLConsoleView_LoadAction(), OQLQueries.ICON_LOAD){
                                    {
                                        this.putValue("ShortDescription", Bundle.OQLConsoleView_LoadActionTooltip());
                                    }

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        if (e.getSource() instanceof JComponent) {
                                            JPopupMenu p = new JPopupMenu();
                                            OQLQueries.instance().populateLoadQuery(p, OQLConsoleView.this.currentQuery, new OQLQueries.Handler(){

                                                @Override
                                                protected void querySelected(OQLSupport.Query query) {
                                                    OQLConsoleView.this.currentQuery = query;
                                                    if (OQLConsoleView.this.editor != null) {
                                                        OQLConsoleView.this.editor.setScript(OQLConsoleView.this.currentQuery.getScript());
                                                    }
                                                }
                                            });
                                            JComponent c = (JComponent)e.getSource();
                                            if (p.getComponentCount() > 0) {
                                                if (c.getClientProperty("POPUP_LEFT") != null) {
                                                    p.show(c, c.getWidth() + 1, 0);
                                                } else {
                                                    p.show(c, 0, c.getHeight() + 1);
                                                }
                                            }
                                        }
                                    }
                                };
                                JButton loadButton = new JButton(OQLConsoleView.this.loadAction);
                                loadButton.setHideActionText(true);
                                OQLConsoleView.this.saveAction = new AbstractAction(Bundle.OQLConsoleView_SaveAction(), OQLQueries.ICON_SAVE){
                                    {
                                        this.putValue("ShortDescription", Bundle.OQLConsoleView_SaveActionTooltip());
                                    }

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        if (e.getSource() instanceof JComponent) {
                                            JPopupMenu p = new JPopupMenu();
                                            OQLQueries.instance().populateSaveQuery(p, OQLConsoleView.this.currentQuery, OQLConsoleView.this.editor.getScript(), new OQLQueries.Handler(){

                                                @Override
                                                protected void querySelected(OQLSupport.Query query) {
                                                    OQLConsoleView.this.currentQuery = query;
                                                }
                                            });
                                            JComponent c = (JComponent)e.getSource();
                                            if (p.getComponentCount() > 0) {
                                                if (c.getClientProperty("POPUP_LEFT") != null) {
                                                    p.show(c, c.getWidth() + 1, 0);
                                                } else {
                                                    p.show(c, 0, c.getHeight() + 1);
                                                }
                                            }
                                        }
                                    }
                                };
                                JButton saveButton = new JButton(OQLConsoleView.this.saveAction);
                                saveButton.setHideActionText(true);
                                OQLConsoleView.this.editAction = new AbstractAction(Bundle.OQLConsoleView_EditAction(), Icons.getIcon((String)"HeapWalkerIcons.Rules")){
                                    {
                                        this.putValue("ShortDescription", Bundle.OQLConsoleView_EditActionTooltip());
                                    }

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        OptionsDisplayer.getDefault().open("HeapViewerOptions");
                                    }
                                };
                                JButton editButton = new JButton(OQLConsoleView.this.editAction);
                                editButton.setHideActionText(true);
                                OQLConsoleView.this.progressToolbar = ProfilerToolbar.create((boolean)false);
                                OQLConsoleView.this.progressToolbar.getComponent().setVisible(false);
                                OQLConsoleView.this.progressToolbar.addSpace(2);
                                OQLConsoleView.this.progressToolbar.addSeparator();
                                OQLConsoleView.this.progressToolbar.addSpace(5);
                                OQLConsoleView.this.progressLabel = (JLabel)new GrayLabel(Bundle.OQLConsoleView_ExecutingProgress());
                                OQLConsoleView.this.progressToolbar.add((Component)OQLConsoleView.this.progressLabel);
                                OQLConsoleView.this.progressToolbar.addSpace(8);
                                OQLConsoleView.this.progressBar = new JProgressBar(0){

                                    @Override
                                    public Dimension getPreferredSize() {
                                        Dimension dim = super.getMinimumSize();
                                        dim.width = 120;
                                        return dim;
                                    }

                                    @Override
                                    public Dimension getMinimumSize() {
                                        return this.getPreferredSize();
                                    }

                                    @Override
                                    public Dimension getMaximumSize() {
                                        return this.getPreferredSize();
                                    }
                                };
                                OQLConsoleView.this.progressToolbar.add((Component)OQLConsoleView.this.progressBar);
                                OQLConsoleView.this.toolbar.add((Component)runButton);
                                OQLConsoleView.this.toolbar.add((Component)cancelButton);
                                OQLConsoleView.this.toolbar.addSpace(5);
                                OQLConsoleView.this.toolbar.add((Component)loadButton);
                                OQLConsoleView.this.toolbar.add((Component)saveButton);
                                OQLConsoleView.this.toolbar.add((Component)editButton);
                                OQLConsoleView.this.resultsToolbar = ProfilerToolbar.create((boolean)false);
                                OQLConsoleView.this.resultsToolbar.addSpace(2);
                                OQLConsoleView.this.resultsToolbar.addSeparator();
                                OQLConsoleView.this.resultsToolbar.addSpace(5);
                                OQLConsoleView.this.resultsToolbar.add((Component)new GrayLabel(Bundle.OQLConsoleView_Results()));
                                OQLConsoleView.this.resultsToolbar.addSpace(3);
                                ButtonGroup resultsBG = new ButtonGroup();
                                OQLConsoleView.this.rObjects = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.TabHotSpots"), true){

                                    @Override
                                    protected void fireItemStateChanged(ItemEvent e) {
                                        if (e.getStateChange() == 1) {
                                            if (OQLConsoleView.this.resultsContainer != null) {
                                                ((CardLayout)OQLConsoleView.this.resultsContainer.getLayout()).first(OQLConsoleView.this.resultsContainer);
                                            }
                                            if (OQLConsoleView.this.pluginsToolbar != null) {
                                                OQLConsoleView.this.pluginsToolbar.getComponent().setVisible(true);
                                            }
                                        }
                                    }
                                };
                                OQLConsoleView.this.rObjects.putClientProperty("JButton.buttonType", "segmented");
                                OQLConsoleView.this.rObjects.putClientProperty("JButton.segmentPosition", "first");
                                OQLConsoleView.this.rObjects.setToolTipText(Bundle.OQLConsoleView_ObjectsTooltip());
                                resultsBG.add(OQLConsoleView.this.rObjects);
                                OQLConsoleView.this.resultsToolbar.add((Component)OQLConsoleView.this.rObjects);
                                OQLConsoleView.this.rHTML = new JToggleButton(Icons.getIcon((String)"HeapWalkerIcons.Properties")){

                                    @Override
                                    protected void fireItemStateChanged(ItemEvent e) {
                                        if (e.getStateChange() == 1) {
                                            if (OQLConsoleView.this.resultsContainer != null) {
                                                ((CardLayout)OQLConsoleView.this.resultsContainer.getLayout()).last(OQLConsoleView.this.resultsContainer);
                                            }
                                            if (OQLConsoleView.this.pluginsToolbar != null) {
                                                OQLConsoleView.this.pluginsToolbar.getComponent().setVisible(false);
                                            }
                                        }
                                    }
                                };
                                OQLConsoleView.this.rHTML.putClientProperty("JButton.buttonType", "segmented");
                                OQLConsoleView.this.rHTML.putClientProperty("JButton.segmentPosition", "last");
                                OQLConsoleView.this.rHTML.setToolTipText(Bundle.OQLConsoleView_HTMLTooltip());
                                resultsBG.add(OQLConsoleView.this.rHTML);
                                OQLConsoleView.this.resultsToolbar.add((Component)OQLConsoleView.this.rHTML);
                                if (OQLConsoleView.this.objectsView.hasPlugins()) {
                                    OQLConsoleView.this.pluginsToolbar = ProfilerToolbar.create((boolean)false);
                                    OQLConsoleView.this.pluginsToolbar.addSpace(8);
                                    OQLConsoleView.this.pluginsToolbar.add((Component)new GrayLabel(Bundle.OQLConsoleView_Details()));
                                    OQLConsoleView.this.pluginsToolbar.addSpace(2);
                                    OQLConsoleView.this.pluginsToolbar.add(OQLConsoleView.this.objectsView.getToolbar());
                                    OQLConsoleView.this.resultsToolbar.add(OQLConsoleView.this.pluginsToolbar);
                                }
                                OQLConsoleView.this.toolbar.add(OQLConsoleView.this.resultsToolbar);
                                OQLConsoleView.this.toolbar.add(OQLConsoleView.this.progressToolbar);
                                OQLConsoleView.this.editor = new OQLEditorComponent(OQLConsoleView.this.engine){

                                    @Override
                                    protected void validityChanged(boolean valid) {
                                        OQLConsoleView.this.queryValid = valid;
                                        OQLConsoleView.this.updateUIState();
                                    }
                                };
                                OQLConsoleView.this.resultsContainer = new JPanel(new CardLayout());
                                OQLConsoleView.this.resultsContainer.add(OQLConsoleView.this.objectsView.getComponent());
                                OQLConsoleView.this.resultsContainer.add(new ResultsView(OQLConsoleView.this.htmlView.getComponent()));
                                JExtendedSplitPane masterSplit = new JExtendedSplitPane(0, true, (Component)OQLConsoleView.this.resultsContainer, (Component)new EditorView(OQLConsoleView.this.editor));
                                BasicSplitPaneDivider masterDivider = ((BasicSplitPaneUI)masterSplit.getUI()).getDivider();
                                masterDivider.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, SEPARATOR_COLOR));
                                masterDivider.setDividerSize(6);
                                masterSplit.setBorder(BorderFactory.createEmptyBorder());
                                masterSplit.setResizeWeight(0.7);
                                OQLConsoleView.this.component.removeAll();
                                OQLConsoleView.this.component.add((Component)masterSplit, "Center");
                                OQLConsoleView.this.component.getParent().invalidate();
                                OQLConsoleView.this.component.getParent().revalidate();
                                OQLConsoleView.this.component.getParent().repaint();
                                OQLConsoleView.this.toolbar.getComponent().repaint();
                                OQLConsoleView.this.updateUIState();
                            }
                        });
                    }
                    catch (Exception e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JLabel l = new JLabel(Bundle.OQLConsoleView_EngineNotAvailable(), 0);
                                l.setEnabled(false);
                                l.setOpaque(false);
                                OQLConsoleView.this.component.removeAll();
                                OQLConsoleView.this.component.add((Component)l, "Center");
                                OQLConsoleView.this.component.getParent().invalidate();
                                OQLConsoleView.this.component.getParent().revalidate();
                                OQLConsoleView.this.component.getParent().repaint();
                            }
                        });
                    }
                }
            }
        });
    }

    private void executeQuery() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (OQLConsoleView.this.nodeResults == null) {
                    OQLConsoleView.this.nodeResults = new HashSet();
                } else {
                    OQLConsoleView.this.nodeResults.clear();
                }
                OQLConsoleView.this.executeQueryImpl(OQLConsoleView.this.editor.getScript());
            }
        });
    }

    private void cancelQuery() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    OQLConsoleView.this.engine.cancelQuery();
                }
                catch (OQLException oQLException) {
                    // empty catch block
                }
                OQLConsoleView.this.finalizeQuery(null);
            }
        });
    }

    public void queryStarted(final BoundedRangeModel model) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OQLConsoleView.this.updateUIState();
                OQLConsoleView.this.resultsToolbar.getComponent().setVisible(false);
                OQLConsoleView.this.progressToolbar.getComponent().setVisible(true);
                OQLConsoleView.this.progressBar.setModel(model);
            }
        });
    }

    public void queryFinished(final String result) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OQLConsoleView.this.updateUIState();
                OQLConsoleView.this.progressToolbar.getComponent().setVisible(false);
                OQLConsoleView.this.resultsToolbar.getComponent().setVisible(true);
                OQLConsoleView.this.progressBar.setModel(new DefaultBoundedRangeModel(0, 0, 0, 0));
                OQLConsoleView.this.objectsView.reloadView();
                if (result != null) {
                    OQLConsoleView.this.htmlView.setText(result);
                    if (result.length() > 0 && OQLConsoleView.this.nodeResults.isEmpty()) {
                        OQLConsoleView.this.rHTML.setSelected(true);
                    }
                }
            }
        });
    }

    private void finalizeQuery(String result) {
        this.analysisRunning.compareAndSet(true, false);
        this.queryFinished(result);
    }

    private void updateUIState() {
        int scriptLength = this.editor.getScript().trim().length();
        this.saveAction.setEnabled(scriptLength > 0);
        if (this.analysisRunning.get()) {
            this.runAction.setEnabled(false);
            this.cancelAction.setEnabled(true);
            this.loadAction.setEnabled(false);
            this.editor.setEditable(false);
        } else {
            this.runAction.setEnabled(scriptLength > 0 && this.queryValid);
            this.cancelAction.setEnabled(false);
            this.loadAction.setEnabled(true);
            this.editor.setEditable(true);
        }
    }

    private void executeQueryImpl(final String oqlQuery) {
        final DefaultBoundedRangeModel progressModel = new DefaultBoundedRangeModel(0, 10, 0, 100);
        new RequestProcessor("OQL Query Processor").post(new Runnable(){

            @Override
            public void run() {
                final AtomicInteger counter = new AtomicInteger(RESULTS_LIMIT);
                progressModel.setMaximum(100);
                final StringBuilder sb = new StringBuilder();
                final boolean[] oddRow = new boolean[1];
                Color oddRowBackground = UIUtils.getDarker((Color)UIUtils.getProfilerResultsBackground());
                final String oddRowBackgroundString = "rgb(" + oddRowBackground.getRed() + "," + oddRowBackground.getGreen() + "," + oddRowBackground.getBlue() + ")";
                sb.append("<table border='0' width='100%'>");
                try {
                    OQLConsoleView.this.analysisRunning.compareAndSet(false, true);
                    OQLConsoleView.this.queryStarted(progressModel);
                    OQLConsoleView.this.progressUpdater.submit(new ProgressUpdater(progressModel));
                    OQLConsoleView.this.engine.executeQuery(oqlQuery, new OQLEngine.ObjectVisitor(){

                        public boolean visit(Object o) {
                            sb.append(oddRow[0] ? "<tr><td style='background-color: " + oddRowBackgroundString + ";'>" : "<tr><td>");
                            oddRow[0] = !oddRow[0];
                            OQLConsoleView.this.dump(o, sb);
                            sb.append("</td></tr>");
                            return counter.decrementAndGet() == 0 || !OQLConsoleView.this.analysisRunning.get() && !OQLConsoleView.this.engine.isCancelled();
                        }
                    });
                    if (counter.get() == 0) {
                        sb.append("<tr><td>");
                        sb.append("&lt;" + Bundle.OQLConsoleView_TooManyResults() + "&gt;");
                        sb.append("</td></tr>");
                    } else if (counter.get() == RESULTS_LIMIT) {
                        sb.append("<tr><td>");
                        sb.append("&lt;" + Bundle.OQLConsoleView_NoResults2() + "&gt;");
                        sb.append("</td></tr>");
                    }
                    sb.append("</table>");
                    OQLConsoleView.this.finalizeQuery(sb.toString());
                }
                catch (OQLException oQLException) {
                    LOGGER.log(Level.INFO, "Error executing OQL", oQLException);
                    StringBuilder errorMessage = new StringBuilder();
                    errorMessage.append("<h2>").append(Bundle.OQLConsoleView_QueryError()).append("</h2>");
                    errorMessage.append(Bundle.OQLConsoleView_BadQuery());
                    errorMessage.append("<hr>");
                    errorMessage.append(oQLException.getLocalizedMessage().replace("\n", "<br>").replace("\r", "<br>"));
                    OQLConsoleView.this.finalizeQuery(errorMessage.toString());
                }
            }
        });
    }

    private void dump(Object o, StringBuilder sb) {
        if (o == null) {
            return;
        }
        if (o instanceof Instance) {
            Instance i = (Instance)o;
            this.nodeResults.add(new InstanceNode(i));
            sb.append(HeapUtils.instanceToHtml(i, true, this.context.getFragment().getHeap(), null));
        } else if (o instanceof JavaClass) {
            JavaClass c = (JavaClass)o;
            this.nodeResults.add(new ClassNode(c));
            sb.append(HeapUtils.classToHtml(c));
        } else if (o instanceof ReferenceChain) {
            boolean first = true;
            for (ReferenceChain rc = (ReferenceChain)o; rc != null; rc = rc.getNext()) {
                if (!first) {
                    sb.append("-&gt;");
                } else {
                    first = false;
                }
                o = rc.getObj();
                if (o instanceof Instance) {
                    Instance i = (Instance)o;
                    this.nodeResults.add(new InstanceNode(i));
                    sb.append(HeapUtils.instanceToHtml(i, true, this.context.getFragment().getHeap(), null));
                    continue;
                }
                if (!(o instanceof JavaClass)) continue;
                JavaClass c = (JavaClass)o;
                this.nodeResults.add(new ClassNode(c));
                sb.append(HeapUtils.classToHtml(c));
            }
        } else if (o instanceof Map) {
            Set entries = ((Map)o).entrySet();
            sb.append("<span><b>{</b><br/>");
            boolean first = true;
            for (Map.Entry entry : entries) {
                if (!first) {
                    sb.append(",<br/>");
                } else {
                    first = false;
                }
                sb.append(entry.getKey().toString().replace("<", "&lt;").replace(">", "&gt;"));
                sb.append(" = ");
                this.dump(this.unwrap(entry.getValue()), sb);
            }
            sb.append("<br/><b>}</b></span>");
        } else if (o instanceof Object[]) {
            sb.append("<span><b>[</b>&nbsp;");
            boolean first = true;
            for (Object obj1 : (Object[])o) {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                this.dump(this.unwrap(obj1), sb);
            }
            sb.append("&nbsp;<b>]</b></span>");
        } else {
            sb.append(o.toString());
        }
    }

    private Object unwrap(Object obj1) {
        Object obj2 = this.engine.unwrapJavaObject(obj1, true);
        return obj2 != null ? obj2 : obj1;
    }

    private static HeapViewerNode getNode(URL url, HeapContext context) {
        String urls = url.toString();
        if (HeapUtils.isInstance(urls)) {
            Instance instance = HeapUtils.instanceFromHtml(urls, context.getFragment().getHeap());
            if (instance != null) {
                return new InstanceNode(instance);
            }
            ProfilerDialogs.displayError((String)Bundle.OQLConsoleView_CannotResolveInstanceMsg());
        } else if (HeapUtils.isClass(urls)) {
            JavaClass javaClass = HeapUtils.classFromHtml(urls, context.getFragment().getHeap());
            if (javaClass != null) {
                return new ClassNode(javaClass);
            }
            ProfilerDialogs.displayError((String)Bundle.OQLConsoleView_CannotResolveClassMsg());
        }
        return null;
    }

    private class ResultsView
    extends JPanel {
        ResultsView(JComponent results) {
            super(new BorderLayout());
            this.add((Component)new ScrollableContainer(results), "Center");
        }
    }

    private class EditorView
    extends JPanel {
        EditorView(OQLEditorComponent editor) {
            super(new BorderLayout());
            editor.clearScrollBorders();
            this.add((Component)editor, "Center");
            JToolBar controls = new JToolBar(1);
            controls.setFloatable(false);
            controls.setBorderPainted(false);
            controls.add(OQLConsoleView.this.runAction);
            controls.add(OQLConsoleView.this.cancelAction);
            controls.addSeparator();
            controls.add(OQLConsoleView.this.loadAction).putClientProperty("POPUP_LEFT", Boolean.TRUE);
            controls.add(OQLConsoleView.this.saveAction).putClientProperty("POPUP_LEFT", Boolean.TRUE);
            controls.add(OQLConsoleView.this.editAction).putClientProperty("POPUP_LEFT", Boolean.TRUE);
            JPanel controlsContainer = new JPanel(new BorderLayout());
            controlsContainer.setOpaque(false);
            controlsContainer.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, UIManager.getColor("Separator.foreground")), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
            controlsContainer.add((Component)controls, "Center");
            this.add((Component)controlsContainer, "West");
            int h = controls.getComponent((int)0).getPreferredSize().height;
            this.setMinimumSize(new Dimension(0, h += controls.getComponent((int)1).getPreferredSize().height + 2));
        }
    }

    private class ProgressUpdater
    implements Runnable {
        private final BoundedRangeModel progressModel;

        ProgressUpdater(BoundedRangeModel model) {
            this.progressModel = model;
        }

        @Override
        public void run() {
            while (OQLConsoleView.this.analysisRunning.get()) {
                int val = this.progressModel.getValue() + 10;
                if (val > this.progressModel.getMaximum()) {
                    val = this.progressModel.getMinimum();
                }
                final int newVal = val;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProgressUpdater.this.progressModel.setValue(newVal);
                    }
                });
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

