/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.NetworkRequestHandler;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.control.FreeColServerHolder;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public abstract class CurrentPlayerNetworkRequestHandler
extends FreeColServerHolder
implements NetworkRequestHandler {
    public CurrentPlayerNetworkRequestHandler(FreeColServer freeColServer) {
        super(freeColServer);
    }

    private boolean isCurrentPlayer(Player player) {
        ServerGame game = this.getGame();
        return player == null || game == null ? false : player.equals(game.getCurrentPlayer());
    }

    @Override
    public final Element handle(Connection conn, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(conn);
        if (!this.isCurrentPlayer(player)) {
            return DOMMessage.clientError("Received message: " + element.getTagName() + " out of turn from player: " + player.getNation());
        }
        return this.handle(player, conn, element);
    }

    protected abstract Element handle(Player var1, Connection var2, Element var3);
}

