/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.openide.util.NbBundle;

public class JFreeChartDialog
extends JDialog {
    private ChartPanel chartPanel;
    private static final int MAX_DIMENSION = 3000;
    private JButton closeButton;
    private JPanel jPanel1;
    private JButton resetButton;
    private JScrollPane scroll;
    private JButton zoomInButton;
    private JButton zoomOutButton;

    public JFreeChartDialog(Frame parent, String title, JFreeChart chart, int initialWidth, int initialHeight) {
        super(parent, false);
        this.setTitle(title);
        this.initialize(chart);
        this.setSize(initialWidth, initialHeight);
        this.setLocationRelativeTo(parent);
    }

    public JFreeChartDialog(Frame parent, JFreeChart chart) {
        super(parent, false);
        this.initialize(chart);
        this.setLocationRelativeTo(parent);
    }

    private void initialize(JFreeChart chart) {
        this.initComponents();
        if (chart == null) {
            throw new IllegalArgumentException("Chart panel can't be null");
        }
        this.chartPanel = new ChartPanel(chart, true);
        this.scroll.setViewportView((Component)this.chartPanel);
        this.adaptChartPanelSizeToScrollSize();
        this.scroll.revalidate();
        this.scroll.repaint();
        this.setVisible(true);
    }

    private void adaptChartPanelSizeToScrollSize() {
        this.chartPanel.setPreferredSize(new Dimension(0, 0));
        this.chartPanel.revalidate();
        this.chartPanel.repaint();
    }

    private void applyZoom(float multiplier) {
        int width = (int)((float)this.chartPanel.getSize().width * multiplier);
        int heigth = (int)((float)this.chartPanel.getSize().height * multiplier);
        width = width > 3000 ? 3000 : width;
        heigth = heigth > 3000 ? 3000 : heigth;
        this.chartPanel.setPreferredSize(new Dimension(width, heigth));
        this.chartPanel.revalidate();
        this.chartPanel.repaint();
    }

    public JFreeChart getChart() {
        return this.chartPanel.getChart();
    }

    public void setChart(JFreeChart chart) {
        if (chart == null) {
            throw new IllegalArgumentException("Chart panel can't be null");
        }
        this.chartPanel.setChart(chart);
    }

    public Dimension getChartSize() {
        return this.chartPanel.getSize();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.scroll = new JScrollPane();
        this.closeButton = new JButton();
        this.resetButton = new JButton();
        this.zoomOutButton = new JButton();
        this.zoomInButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(200, 200));
        this.scroll.setMinimumSize(new Dimension(10, 10));
        this.scroll.setPreferredSize(new Dimension(10, 10));
        this.closeButton.setText(NbBundle.getMessage(JFreeChartDialog.class, (String)"JFreeChartDialog.closeButton.text"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFreeChartDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.resetButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/ui/components/resources/magnifier-history.png")));
        this.resetButton.setText(NbBundle.getMessage(JFreeChartDialog.class, (String)"JFreeChartDialog.resetButton.text"));
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFreeChartDialog.this.resetButtonActionPerformed(evt);
            }
        });
        this.zoomOutButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/ui/components/resources/magnifier--minus.png")));
        this.zoomOutButton.setText(NbBundle.getMessage(JFreeChartDialog.class, (String)"JFreeChartDialog.zoomOutButton.text"));
        this.zoomOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFreeChartDialog.this.zoomOutButtonActionPerformed(evt);
            }
        });
        this.zoomInButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/ui/components/resources/magnifier--plus.png")));
        this.zoomInButton.setText(NbBundle.getMessage(JFreeChartDialog.class, (String)"JFreeChartDialog.zoomInButton.text"));
        this.zoomInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFreeChartDialog.this.zoomInButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scroll, -1, 256, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.zoomOutButton, -1, 97, Short.MAX_VALUE).addComponent(this.zoomInButton, -1, 97, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.closeButton, -1, -1, Short.MAX_VALUE).addComponent(this.resetButton)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.scroll, -1, 251, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.resetButton).addComponent(this.zoomInButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.zoomOutButton).addComponent(this.closeButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        this.adaptChartPanelSizeToScrollSize();
    }

    private void zoomInButtonActionPerformed(ActionEvent evt) {
        this.applyZoom(1.5f);
    }

    private void zoomOutButtonActionPerformed(ActionEvent evt) {
        this.applyZoom(0.5f);
    }
}

