/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.awt.Color;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.netbeans.api.autoupdate.UpdateElement;
import org.openide.util.NbBundle;

public class ValidationWarningPanel
extends JPanel {
    private JScrollPane spPlugins;
    private JTree tPlugins;
    private JTextArea taHead;
    private JTextArea taWarning;
    private final DefaultMutableTreeNode pluginModelRoot = new DefaultMutableTreeNode("Third-party Plugins");
    private final DefaultTreeModel pluginsModel = new DefaultTreeModel(this.pluginModelRoot);

    public ValidationWarningPanel(List<UpdateElement> signedVerified, List<UpdateElement> signedUnverified, List<UpdateElement> unsigned, List<UpdateElement> modified, int total) {
        this.initComponents();
        this.tPlugins.getSelectionModel().setSelectionMode(1);
        this.taHead.setBackground(new Color(0, 0, 0, 0));
        this.taHead.setBorder(BorderFactory.createEmptyBorder());
        this.taWarning.setBackground(new Color(0, 0, 0, 0));
        this.taWarning.setBorder(BorderFactory.createEmptyBorder());
        this.postInitComponents(signedVerified, signedUnverified, unsigned, modified, total);
    }

    private void postInitComponents(List<UpdateElement> signedVerified, List<UpdateElement> signedUnverified, List<UpdateElement> unsigned, List<UpdateElement> modified, int total) {
        DefaultMutableTreeNode signedAndValidNode = new DefaultMutableTreeNode("Signed and Valid (" + signedVerified.size() + ")");
        DefaultMutableTreeNode selfSignedNode = new DefaultMutableTreeNode("Self signed (" + signedUnverified.size() + ")");
        DefaultMutableTreeNode unsignedNode = new DefaultMutableTreeNode("Unsigned (" + unsigned.size() + ")");
        for (UpdateElement el : signedVerified) {
            signedAndValidNode.add(new DefaultMutableTreeNode(el.getDisplayName()));
        }
        this.pluginModelRoot.add(signedAndValidNode);
        for (UpdateElement el : signedUnverified) {
            selfSignedNode.add(new DefaultMutableTreeNode(el.getDisplayName()));
        }
        this.pluginModelRoot.add(selfSignedNode);
        for (UpdateElement el : unsigned) {
            unsignedNode.add(new DefaultMutableTreeNode(el.getDisplayName()));
        }
        this.pluginModelRoot.add(unsignedNode);
        this.pluginsModel.reload();
        int requiresAttention = signedVerified.size() + signedUnverified.size() + unsigned.size();
        if (requiresAttention > 1) {
            this.taHead.setText(NbBundle.getMessage(ValidationWarningPanel.class, (String)"ValidationWarningPanel_taHead_NotTrustedTextPl", (Object)requiresAttention, (Object)total));
        } else {
            this.taHead.setText(NbBundle.getMessage(ValidationWarningPanel.class, (String)"ValidationWarningPanel_taHead_NotTrustedTextSg", (Object)requiresAttention, (Object)total));
        }
    }

    public String getSelectedNode() {
        Object o = this.tPlugins.getLastSelectedPathComponent();
        return o == null ? "" : o.toString();
    }

    public void addSelectionListener(TreeSelectionListener tsl) {
        this.tPlugins.getSelectionModel().addTreeSelectionListener(tsl);
    }

    private void initComponents() {
        this.taHead = new JTextArea();
        this.spPlugins = new JScrollPane();
        this.tPlugins = new JTree();
        this.taWarning = new JTextArea();
        this.taHead.setEditable(false);
        this.taHead.setLineWrap(true);
        this.taHead.setWrapStyleWord(true);
        this.taHead.setOpaque(false);
        this.tPlugins.setModel(this.pluginsModel);
        this.spPlugins.setViewportView(this.tPlugins);
        this.taWarning.setEditable(false);
        this.taWarning.setLineWrap(true);
        this.taWarning.setText(NbBundle.getMessage(ValidationWarningPanel.class, (String)"ValidationWarningPanel_taWarning_Text"));
        this.taWarning.setWrapStyleWord(true);
        this.taWarning.setOpaque(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spPlugins, -1, 398, Short.MAX_VALUE).addComponent(this.taHead).addComponent(this.taWarning, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.taHead, -2, 57, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spPlugins, -1, 196, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.taWarning, -2, 58, Short.MAX_VALUE).addContainerGap()));
        this.taHead.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ValidationWarningPanel.class, (String)"ValidationWarningPanel_taHead_ACN"));
        this.taHead.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ValidationWarningPanel.class, (String)"ValidationWarningPanel_taHead_ACN"));
        this.taWarning.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ValidationWarningPanel.class, (String)"ValidationWarningPanel_taWarning_Text_ACN"));
        this.taWarning.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ValidationWarningPanel.class, (String)"ValidationWarningPanel_taWarning_Text_ACD"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ValidationWarningPanel.class, (String)"ValidationWarningPanel_ACD"));
    }
}

