/*
 * Decompiled with CFR 0.152.
 */
package biz.k11i.xgboost.tree;

import biz.k11i.xgboost.util.FVec;
import biz.k11i.xgboost.util.ModelReader;
import java.io.IOException;
import java.io.Serializable;

public class RegTree
implements Serializable {
    private Param param;
    private Node[] nodes;
    private RTreeNodeStat[] stats;

    public void loadModel(ModelReader reader) throws IOException {
        int i;
        this.param = new Param(reader);
        this.nodes = new Node[this.param.num_nodes];
        for (i = 0; i < this.param.num_nodes; ++i) {
            this.nodes[i] = new Node(reader);
        }
        this.stats = new RTreeNodeStat[this.param.num_nodes];
        for (i = 0; i < this.param.num_nodes; ++i) {
            this.stats[i] = new RTreeNodeStat(reader);
        }
    }

    public int getLeafIndex(FVec feat, int root_id) {
        int pid = root_id;
        while (true) {
            Node n = this.nodes[pid];
            if (n._isLeaf) break;
            pid = n.next(feat);
        }
        return pid;
    }

    public double getLeafValue(FVec feat, int root_id) {
        Node n = this.nodes[root_id];
        while (!n._isLeaf) {
            n = this.nodes[n.next(feat)];
        }
        return n.leaf_value;
    }

    static class RTreeNodeStat
    implements Serializable {
        final float loss_chg;
        final float sum_hess;
        final float base_weight;
        final int leaf_child_cnt;

        RTreeNodeStat(ModelReader reader) throws IOException {
            this.loss_chg = reader.readFloat();
            this.sum_hess = reader.readFloat();
            this.base_weight = reader.readFloat();
            this.leaf_child_cnt = reader.readInt();
        }
    }

    static class Node
    implements Serializable {
        final int parent_;
        final int cleft_;
        final int cright_;
        final int sindex_;
        final double leaf_value;
        final double split_cond;
        private final int _defaultNext;
        private final int _splitIndex;
        final boolean _isLeaf;

        Node(ModelReader reader) throws IOException {
            this.parent_ = reader.readInt();
            this.cleft_ = reader.readInt();
            this.cright_ = reader.readInt();
            this.sindex_ = reader.readInt();
            if (this.is_leaf()) {
                this.leaf_value = reader.readFloat();
                this.split_cond = Double.NaN;
            } else {
                this.split_cond = reader.readFloat();
                this.leaf_value = Double.NaN;
            }
            this._defaultNext = this.cdefault();
            this._splitIndex = this.split_index();
            this._isLeaf = this.is_leaf();
        }

        boolean is_leaf() {
            return this.cleft_ == -1;
        }

        int split_index() {
            return (int)((long)this.sindex_ & Integer.MAX_VALUE);
        }

        int cdefault() {
            return this.default_left() ? this.cleft_ : this.cright_;
        }

        boolean default_left() {
            return this.sindex_ >>> 31 != 0;
        }

        int next(FVec feat) {
            double fvalue = feat.fvalue(this._splitIndex);
            if (fvalue != fvalue) {
                return this._defaultNext;
            }
            return fvalue < this.split_cond ? this.cleft_ : this.cright_;
        }
    }

    static class Param
    implements Serializable {
        final int num_roots;
        final int num_nodes;
        final int num_deleted;
        final int max_depth;
        final int num_feature;
        final int size_leaf_vector;
        final int[] reserved;

        Param(ModelReader reader) throws IOException {
            this.num_roots = reader.readInt();
            this.num_nodes = reader.readInt();
            this.num_deleted = reader.readInt();
            this.max_depth = reader.readInt();
            this.num_feature = reader.readInt();
            this.size_leaf_vector = reader.readInt();
            this.reserved = reader.readIntArray(31);
        }
    }
}

