from typing import Any, Optional, Text
from werkzeug.datastructures import CallbackDict

def generate_key(salt: Optional[Any] = ...): ...

class ModificationTrackingDict(CallbackDict):
    modified = ...  # type: Any
    def __init__(self, *args, **kwargs): ...
    def copy(self): ...
    def __copy__(self): ...

class Session(ModificationTrackingDict):
    sid = ...  # type: Any
    new = ...  # type: Any
    def __init__(self, data, sid, new: bool = ...): ...
    @property
    def should_save(self): ...

class SessionStore:
    session_class = ...  # type: Any
    def __init__(self, session_class: Optional[Any] = ...): ...
    def is_valid_key(self, key): ...
    def generate_key(self, salt: Optional[Any] = ...): ...
    def new(self): ...
    def save(self, session): ...
    def save_if_modified(self, session): ...
    def delete(self, session): ...
    def get(self, sid): ...

class FilesystemSessionStore(SessionStore):
    path = ...  # type: Any
    filename_template: str
    renew_missing = ...  # type: Any
    mode = ...  # type: Any
    def __init__(self, path: Optional[Any] = ..., filename_template: Text = ..., session_class: Optional[Any] = ...,
                 renew_missing: bool = ..., mode: int = ...): ...
    def get_session_filename(self, sid): ...
    def save(self, session): ...
    def delete(self, session): ...
    def get(self, sid): ...
    def list(self): ...

class SessionMiddleware:
    app = ...  # type: Any
    store = ...  # type: Any
    cookie_name = ...  # type: Any
    cookie_age = ...  # type: Any
    cookie_expires = ...  # type: Any
    cookie_path = ...  # type: Any
    cookie_domain = ...  # type: Any
    cookie_secure = ...  # type: Any
    cookie_httponly = ...  # type: Any
    environ_key = ...  # type: Any
    def __init__(self, app, store, cookie_name: str = ..., cookie_age: Optional[Any] = ..., cookie_expires: Optional[Any] = ...,
                 cookie_path: str = ..., cookie_domain: Optional[Any] = ..., cookie_secure: Optional[Any] = ...,
                 cookie_httponly: bool = ..., environ_key: str = ...): ...
    def __call__(self, environ, start_response): ...
