/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.core;

import java.io.PrintStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.ivy.osgi.core.ManifestHeaderElement;

public class ManifestHeaderValue {
    private List elements = new ArrayList();

    ManifestHeaderValue() {
    }

    public ManifestHeaderValue(String string) throws ParseException {
        if (string != null) {
            new ManifestHeaderParser(string).parse();
        }
    }

    public List getElements() {
        return this.elements;
    }

    public String getSingleValue() {
        if (this.elements.isEmpty()) {
            return null;
        }
        List list = ((ManifestHeaderElement)this.getElements().iterator().next()).getValues();
        if (list.isEmpty()) {
            return null;
        }
        return (String)list.iterator().next();
    }

    public List getValues() {
        if (this.elements.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList arrayList = new ArrayList();
        for (ManifestHeaderElement manifestHeaderElement : this.getElements()) {
            arrayList.addAll(manifestHeaderElement.getValues());
        }
        return arrayList;
    }

    void addElement(ManifestHeaderElement manifestHeaderElement) {
        this.elements.add(manifestHeaderElement);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ManifestHeaderValue)) {
            return false;
        }
        ManifestHeaderValue manifestHeaderValue = (ManifestHeaderValue)object;
        if (manifestHeaderValue.elements.size() != this.elements.size()) {
            return false;
        }
        for (ManifestHeaderElement manifestHeaderElement : this.elements) {
            if (manifestHeaderValue.elements.contains(manifestHeaderElement)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String string = "";
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            string = string.concat(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            string = string.concat(",");
        }
        return string;
    }

    public static void writeParseException(PrintStream printStream, String string, ParseException parseException) {
        printStream.println(parseException.getMessage());
        printStream.print("   " + string + "\n   ");
        for (int i = 0; i < parseException.getErrorOffset(); ++i) {
            printStream.print(' ');
        }
        printStream.println('^');
    }

    class ManifestHeaderParser {
        private final String header;
        private int length;
        private StringBuffer buffer = new StringBuffer();
        private int pos = 0;
        private char c;
        private ManifestHeaderElement elem = new ManifestHeaderElement();
        private boolean valuesParsed;
        private String paramName;
        private boolean isDirective;

        ManifestHeaderParser(String string) {
            this.header = string;
            this.length = string.length();
        }

        void parse() throws ParseException {
            do {
                this.elem = new ManifestHeaderElement();
                int n = this.pos;
                this.parseElement();
                if (this.elem.getValues().isEmpty()) {
                    this.error("No defined value", n);
                    continue;
                }
                ManifestHeaderValue.this.addElement(this.elem);
            } while (this.pos < this.length);
        }

        private char readNext() {
            this.c = this.pos == this.length ? (char)'\u0000' : this.header.charAt(this.pos++);
            return this.c;
        }

        private void error(String string) throws ParseException {
            this.error(string, this.pos - 1);
        }

        private void error(String string, int n) throws ParseException {
            throw new ParseException(string, n);
        }

        private void parseElement() throws ParseException {
            this.valuesParsed = false;
            do {
                this.parseValueOrParameter();
            } while (this.c == ';' && this.pos < this.length);
        }

        private void parseValueOrParameter() throws ParseException {
            boolean bl = false;
            boolean bl2 = false;
            block6: do {
                switch (this.readNext()) {
                    case '\u0000': {
                        break;
                    }
                    case ',': 
                    case ';': {
                        this.endValue();
                        return;
                    }
                    case ':': 
                    case '=': {
                        this.endParameterName();
                        this.parseSeparator();
                        this.parseParameterValue();
                        return;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (!bl) continue block6;
                        bl2 = true;
                        break;
                    }
                    default: {
                        if (bl2) {
                            this.error("Expecting the end of a value or of an parameter name");
                            bl2 = false;
                        }
                        bl = true;
                        this.buffer.append(this.c);
                    }
                }
            } while (this.pos < this.length);
            this.endValue();
        }

        private void endValue() throws ParseException {
            if (this.valuesParsed) {
                this.error("Early end of a parameter");
                this.buffer.setLength(0);
                return;
            }
            if (this.buffer.length() == 0) {
                this.error("Empty value");
            }
            this.elem.addValue(this.buffer.toString());
            this.buffer.setLength(0);
        }

        private void endParameterName() throws ParseException {
            if (this.buffer.length() == 0) {
                this.error("Empty parameter name");
                this.paramName = null;
            }
            this.paramName = this.buffer.toString();
            this.buffer.setLength(0);
        }

        private void parseSeparator() throws ParseException {
            if (this.c == '=') {
                this.isDirective = false;
                return;
            }
            if (this.readNext() != '=') {
                this.error("Expecting '='");
                --this.pos;
                this.paramName = null;
            }
            this.isDirective = true;
        }

        private void parseParameterValue() throws ParseException {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            block9: do {
                switch (this.readNext()) {
                    case '\u0000': {
                        break;
                    }
                    case ',': 
                    case ';': {
                        this.endParameterValue();
                        return;
                    }
                    case ':': 
                    case '=': {
                        this.error("Illegal character '" + this.c + "' in parameter value of " + this.paramName);
                        this.paramName = null;
                        break;
                    }
                    case '\"': {
                        bl3 = true;
                    }
                    case '\'': {
                        if (bl2 && this.paramName != null) {
                            this.error("Expecting the end of a parameter value");
                            this.paramName = null;
                        }
                        if (bl) {
                            this.buffer.append(this.c);
                            break;
                        }
                        bl = true;
                        this.appendQuoted(bl3);
                        bl2 = true;
                        break;
                    }
                    case '\\': {
                        if (bl2 && this.paramName != null) {
                            this.error("Expecting the end of a parameter value");
                            this.paramName = null;
                        }
                        bl = true;
                        this.appendEscaped();
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (!bl) continue block9;
                        bl2 = true;
                        break;
                    }
                    default: {
                        if (bl2 && this.paramName != null) {
                            this.error("Expecting the end of a parameter value");
                            this.paramName = null;
                        }
                        bl = true;
                        this.buffer.append(this.c);
                    }
                }
            } while (this.pos < this.length);
            this.endParameterValue();
        }

        private void endParameterValue() throws ParseException {
            if (this.paramName == null) {
                return;
            }
            if (this.buffer.length() == 0) {
                this.error("Empty parameter value");
                return;
            }
            String string = this.buffer.toString();
            if (this.isDirective) {
                this.elem.addDirective(this.paramName, string);
            } else {
                this.elem.addAttribute(this.paramName, string);
            }
            this.valuesParsed = true;
            this.buffer.setLength(0);
        }

        private void appendQuoted(boolean bl) {
            do {
                switch (this.readNext()) {
                    case '\u0000': {
                        break;
                    }
                    case '\"': {
                        if (bl) {
                            return;
                        }
                        this.buffer.append(this.c);
                        break;
                    }
                    case '\'': {
                        if (!bl) {
                            return;
                        }
                        this.buffer.append(this.c);
                        break;
                    }
                    case '\\': {
                        break;
                    }
                    default: {
                        this.buffer.append(this.c);
                    }
                }
            } while (this.pos < this.length);
        }

        private void appendEscaped() {
            if (this.pos < this.length) {
                this.buffer.append(this.readNext());
            } else {
                this.buffer.append(this.c);
            }
        }
    }
}

