/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httpsessions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.Cookie;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.httpsessions.ExtensionHttpSessions;
import org.zaproxy.zap.extension.httpsessions.HttpSession;
import org.zaproxy.zap.extension.httpsessions.HttpSessionTokensSet;
import org.zaproxy.zap.extension.httpsessions.HttpSessionsSite;
import org.zaproxy.zap.utils.ApiUtils;
import org.zaproxy.zap.utils.Pair;
import org.zaproxy.zap.utils.XMLStringUtil;

public class HttpSessionsAPI
extends ApiImplementor {
    private static final Logger log = Logger.getLogger(HttpSessionsAPI.class);
    private static final String PREFIX = "httpSessions";
    private static final String ACTION_CREATE_EMPTY_SESSION = "createEmptySession";
    private static final String ACTION_REMOVE_SESSION = "removeSession";
    private static final String ACTION_SET_ACTIVE_SESSION = "setActiveSession";
    private static final String ACTION_ADD_SESSION_TOKEN = "addSessionToken";
    private static final String ACTION_REMOVE_SESSION_TOKEN = "removeSessionToken";
    private static final String ACTION_UNSET_ACTIVE_SESSION = "unsetActiveSession";
    private static final String ACTION_SET_SESSION_TOKEN = "setSessionTokenValue";
    private static final String ACTION_RENAME_SESSION = "renameSession";
    private static final String ACTION_PARAM_SITE = "site";
    private static final String ACTION_PARAM_SESSION = "session";
    private static final String ACTION_PARAM_SESSION_OLD_NAME = "oldSessionName";
    private static final String ACTION_PARAM_SESSION_NEW_NAME = "newSessionName";
    private static final String ACTION_PARAM_TOKEN_NAME = "sessionToken";
    private static final String ACTION_PARAM_TOKEN_VALUE = "tokenValue";
    private static final String VIEW_SITES = "sites";
    private static final String VIEW_SESSIONS = "sessions";
    private static final String VIEW_ACTIVE_SESSION = "activeSession";
    private static final String VIEW_SESSION_TOKENS = "sessionTokens";
    private static final String VIEW_PARAM_SITE = "site";
    private static final String VIEW_PARAM_SESSION = "session";
    private ExtensionHttpSessions extension;

    public HttpSessionsAPI(ExtensionHttpSessions extension) {
        this.extension = extension;
        this.addApiAction(new ApiAction(ACTION_CREATE_EMPTY_SESSION, new String[]{"site"}, new String[]{"session"}));
        this.addApiAction(new ApiAction(ACTION_REMOVE_SESSION, new String[]{"site", "session"}));
        this.addApiAction(new ApiAction(ACTION_SET_ACTIVE_SESSION, new String[]{"site", "session"}));
        this.addApiAction(new ApiAction(ACTION_UNSET_ACTIVE_SESSION, new String[]{"site"}));
        this.addApiAction(new ApiAction(ACTION_ADD_SESSION_TOKEN, new String[]{"site", ACTION_PARAM_TOKEN_NAME}));
        this.addApiAction(new ApiAction(ACTION_REMOVE_SESSION_TOKEN, new String[]{"site", ACTION_PARAM_TOKEN_NAME}));
        this.addApiAction(new ApiAction(ACTION_SET_SESSION_TOKEN, new String[]{"site", "session", ACTION_PARAM_TOKEN_NAME, ACTION_PARAM_TOKEN_VALUE}));
        this.addApiAction(new ApiAction(ACTION_RENAME_SESSION, new String[]{"site", ACTION_PARAM_SESSION_OLD_NAME, ACTION_PARAM_SESSION_NEW_NAME}));
        this.addApiView(new ApiView(VIEW_SITES));
        this.addApiView(new ApiView(VIEW_SESSIONS, new String[]{"site"}, new String[]{"session"}));
        this.addApiView(new ApiView(VIEW_ACTIVE_SESSION, new String[]{"site"}));
        this.addApiView(new ApiView(VIEW_SESSION_TOKENS, new String[]{"site"}));
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public ApiResponse handleApiAction(String name, JSONObject params) throws ApiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Request for handleApiAction: " + name + " (params: " + params.toString() + ")"));
        }
        switch (name) {
            case "createEmptySession": {
                HttpSessionsSite site = this.extension.getHttpSessionsSite(ApiUtils.getAuthority(params.getString("site")), true);
                if (site == null) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "site");
                }
                String sessionName = this.getParam(params, "session", "");
                if ("".equals(sessionName)) {
                    site.createEmptySession();
                } else {
                    site.createEmptySession(sessionName);
                }
                return ApiResponseElement.OK;
            }
            case "removeSession": {
                HttpSessionsSite site = this.extension.getHttpSessionsSite(ApiUtils.getAuthority(params.getString("site")), false);
                if (site == null) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "site");
                }
                HttpSession sessionRS = site.getHttpSession(params.getString("session"));
                if (sessionRS == null) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "session");
                }
                site.removeHttpSession(sessionRS);
                return ApiResponseElement.OK;
            }
            case "setActiveSession": {
                HttpSessionsSite site = this.extension.getHttpSessionsSite(ApiUtils.getAuthority(params.getString("site")), false);
                if (site == null) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "site");
                }
                String sname = params.getString("session");
                for (HttpSession session : site.getHttpSessions()) {
                    if (!session.getName().equals(sname)) continue;
                    site.setActiveSession(session);
                    return ApiResponseElement.OK;
                }
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "session");
            }
            case "unsetActiveSession": {
                HttpSessionsSite site = this.extension.getHttpSessionsSite(ApiUtils.getAuthority(params.getString("site")), false);
                if (site == null) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "site");
                }
                site.unsetActiveSession();
                return ApiResponseElement.OK;
            }
            case "addSessionToken": {
                this.extension.addHttpSessionToken(ApiUtils.getAuthority(params.getString("site")), params.getString(ACTION_PARAM_TOKEN_NAME));
                return ApiResponseElement.OK;
            }
            case "removeSessionToken": {
                this.extension.removeHttpSessionToken(ApiUtils.getAuthority(params.getString("site")), params.getString(ACTION_PARAM_TOKEN_NAME));
                return ApiResponseElement.OK;
            }
            case "setSessionTokenValue": {
                HttpSessionsSite site = this.extension.getHttpSessionsSite(ApiUtils.getAuthority(params.getString("site")), false);
                if (site == null) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "site");
                }
                HttpSession sessionSST = site.getHttpSession(params.getString("session"));
                if (sessionSST == null) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "session");
                }
                this.extension.addHttpSessionToken(ApiUtils.getAuthority(params.getString("site")), params.getString(ACTION_PARAM_TOKEN_NAME));
                sessionSST.setTokenValue(params.getString(ACTION_PARAM_TOKEN_NAME), new Cookie(null, params.getString(ACTION_PARAM_TOKEN_NAME), params.getString(ACTION_PARAM_TOKEN_VALUE)));
                return ApiResponseElement.OK;
            }
            case "renameSession": {
                HttpSessionsSite site = this.extension.getHttpSessionsSite(ApiUtils.getAuthority(params.getString("site")), false);
                if (site == null) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "site");
                }
                if (!site.renameHttpSession(params.getString(ACTION_PARAM_SESSION_OLD_NAME), params.getString(ACTION_PARAM_SESSION_NEW_NAME))) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, Constant.messages.getString("httpsessions.api.error.rename"));
                }
                return ApiResponseElement.OK;
            }
        }
        throw new ApiException(ApiException.Type.BAD_ACTION);
    }

    @Override
    public ApiResponse handleApiView(String name, JSONObject params) throws ApiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Request for handleApiView: " + name + " (params: " + params.toString() + ")"));
        }
        switch (name) {
            case "sites": {
                ApiResponseList responseSites = new ApiResponseList(name);
                for (String s : this.extension.getSites()) {
                    responseSites.addItem(new ApiResponseElement("site", s));
                }
                return responseSites;
            }
            case "sessions": {
                HttpSessionsSite site = this.extension.getHttpSessionsSite(ApiUtils.getAuthority(params.getString("site")), false);
                if (site == null) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "site");
                }
                ApiResponseList response = new ApiResponseList(name);
                String vsName = this.getParam(params, "session", "");
                if (vsName == null || vsName.isEmpty()) {
                    Set<HttpSession> sessions = site.getHttpSessions();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("API View for sessions for " + ApiUtils.getAuthority(params.getString("site")) + ": " + site));
                    }
                    for (HttpSession session : sessions) {
                        if (session.getTokenValuesUnmodifiableMap().size() <= 0) continue;
                        response.addItem(this.createSessionResponse(session));
                    }
                } else {
                    HttpSession session = site.getHttpSession(vsName);
                    if (session != null) {
                        response.addItem(this.createSessionResponse(session));
                    }
                }
                return response;
            }
            case "activeSession": {
                HttpSessionsSite site = this.extension.getHttpSessionsSite(ApiUtils.getAuthority(params.getString("site")), false);
                if (site == null) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "site");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("API View for active session for " + ApiUtils.getAuthority(params.getString("site")) + ": " + site));
                }
                if (site.getActiveSession() != null) {
                    return new ApiResponseElement("active_session", site.getActiveSession().getName());
                }
                return new ApiResponseElement("active_session", "");
            }
            case "sessionTokens": {
                Set<String> tokens;
                String siteName = ApiUtils.getAuthority(params.getString("site"));
                if (this.extension.getHttpSessionsSite(siteName, false) == null) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "site");
                }
                HttpSessionTokensSet sessionTokens = this.extension.getHttpSessionTokensSet(siteName);
                ApiResponseList responseST = new ApiResponseList("session_tokens");
                if (sessionTokens != null && (tokens = sessionTokens.getTokensSet()) != null) {
                    for (String token : tokens) {
                        responseST.addItem(new ApiResponseElement("token", token));
                    }
                }
                return responseST;
            }
        }
        throw new ApiException(ApiException.Type.BAD_VIEW);
    }

    private ApiResponseList createSessionResponse(HttpSession session) {
        ApiResponseList sessionResult = new ApiResponseList("session");
        sessionResult.addItem(new ApiResponseElement("name", session.getName()));
        sessionResult.addItem(new TokenValuesResponseSet(session.getTokenValuesUnmodifiableMap()));
        sessionResult.addItem(new ApiResponseElement("messages_matched", Integer.toString(session.getMessagesMatched())));
        return sessionResult;
    }

    private static class TokenValuesResponseSet
    extends ApiResponseSet<Cookie> {
        private final List<List<Pair<String, String>>> xmlTokenElements;

        public TokenValuesResponseSet(Map<String, Cookie> values) {
            super("tokens", values);
            this.xmlTokenElements = TokenValuesResponseSet.convertTokenValues(values);
        }

        @Override
        public void toXML(Document doc, Element parent) {
            parent.setAttribute("type", "set");
            for (List<Pair<String, String>> tokenElements : this.xmlTokenElements) {
                Element tokenSet = doc.createElement("token");
                tokenSet.setAttribute("type", "set");
                for (Pair<String, String> element : tokenElements) {
                    Element el = doc.createElement((String)element.first);
                    el.appendChild(doc.createTextNode(XMLStringUtil.escapeControlChrs((String)element.second)));
                    tokenSet.appendChild(el);
                }
                parent.appendChild(tokenSet);
            }
        }

        private static List<List<Pair<String, String>>> convertTokenValues(Map<String, Cookie> values) {
            ArrayList<List<Pair<String, String>>> tokens = new ArrayList<List<Pair<String, String>>>();
            for (Map.Entry<String, Cookie> token : values.entrySet()) {
                Cookie cookie = token.getValue();
                ArrayList<Pair<String, String>> fields = new ArrayList<Pair<String, String>>();
                fields.add(new Pair<String, String>("name", token.getKey()));
                fields.add(new Pair<String, String>("value", cookie.getValue()));
                fields.add(new Pair<String, String>("domain", cookie.getDomain()));
                fields.add(new Pair<String, String>("path", cookie.getPath()));
                fields.add(new Pair<String, String>("secure", Boolean.toString(cookie.getSecure())));
                tokens.add(fields);
            }
            return tokens;
        }
    }
}

