/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.popup;

import java.util.List;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.StructuralSiteNode;
import org.zaproxy.zap.view.ContextIncludePanel;
import org.zaproxy.zap.view.popup.PopupMenuItemSiteNodeContainer;

public class PopupMenuItemIncludeInContext
extends PopupMenuItemSiteNodeContainer {
    private static final long serialVersionUID = 990419495607725846L;
    protected Context context;

    public PopupMenuItemIncludeInContext() {
        super(Constant.messages.getString("context.new.title"), true);
        this.context = null;
        this.setPrecedeWithSeparator(true);
    }

    public PopupMenuItemIncludeInContext(Context context) {
        super(context.getName(), true);
        this.context = context;
    }

    @Override
    public String getParentMenuName() {
        return Constant.messages.getString("context.include.popup");
    }

    @Override
    public boolean isSubMenu() {
        return true;
    }

    @Override
    public void performAction(SiteNode sn) {
        try {
            this.performAction(sn.getNodeName(), new StructuralSiteNode(sn).getRegexPattern());
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
    }

    protected void performAction(String name, String url) {
        if (this.context == null) {
            Session session = Model.getSingleton().getSession();
            this.context = session.getNewContext(name);
            this.recreateUISharedContexts(session);
        }
        Context uiSharedContext = View.getSingleton().getSessionDialog().getUISharedContext(this.context.getIndex());
        uiSharedContext.addIncludeInContextRegex(url);
    }

    @Override
    public void performHistoryReferenceActions(List<HistoryReference> hrefs) {
        Session session = Model.getSingleton().getSession();
        if (this.context != null) {
            this.recreateUISharedContexts(session);
        }
        super.performHistoryReferenceActions(hrefs);
        View.getSingleton().showSessionDialog(session, ContextIncludePanel.getPanelName(this.context.getIndex()), false);
    }

    private void recreateUISharedContexts(Session session) {
        View.getSingleton().getSessionDialog().recreateUISharedContexts(session);
    }

    @Override
    public boolean isButtonEnabledForSiteNode(SiteNode sn) {
        if (this.context == null) {
            return Model.getSingleton().getSession().getContext(sn.getNodeName()) == null;
        }
        return !this.context.isIncluded(sn) && !this.context.isExcluded(sn);
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

