/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.event.MouseInputListener;

public class GrabbableViewport
extends JViewport
implements MouseInputListener {
    private static final long serialVersionUID = -2824980836373317470L;
    private static Cursor HAND = new Cursor(13);
    private static Cursor DFLT = new Cursor(0);
    private Rectangle rect;
    private Point point;
    private JComponent view;

    public static void setHandCursorIcon(ImageIcon icon) {
        Image grabbingHand = icon.getImage();
        HAND = Toolkit.getDefaultToolkit().createCustomCursor(grabbingHand, new Point(0, 0), "hand cursor");
    }

    @Override
    public void setView(Component view) {
        super.setView(view);
        if (this.view != view) {
            if (this.view != null) {
                this.view.removeMouseListener(this);
                this.view.removeMouseMotionListener(this);
            }
            if (view != null) {
                view.addMouseListener(this);
                view.addMouseMotionListener(this);
            }
            this.view = (JComponent)view;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.view.setCursor(HAND);
        this.rect = this.getViewRect();
        this.point = this.screenLocation(e);
    }

    private Point screenLocation(MouseEvent e) {
        Point root = this.view.getLocationOnScreen();
        Point mouse = e.getPoint();
        if (this.rect != null && !this.rect.contains(mouse)) {
            return null;
        }
        Point screenPoint = new Point(root.x + mouse.x, root.y + mouse.y);
        return screenPoint;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.view.setCursor(DFLT);
        this.scrollTo(this.screenLocation(e));
        this.clear();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.scrollTo(this.screenLocation(e));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private void scrollTo(Point newPoint) {
        if (this.point != null && newPoint != null && this.rect != null) {
            int deltaX = this.point.x - newPoint.x;
            int deltaY = this.point.y - newPoint.y;
            this.rect.x += deltaX;
            this.rect.y += deltaY;
            ((JComponent)this.getView()).scrollRectToVisible(this.rect);
            this.point = newPoint;
        }
    }

    private void clear() {
        this.rect = null;
        this.point = null;
    }
}

