/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.psych;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.psych.PsychLibrary;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.IOOutputStream;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.emitter.Emitter;
import org.yaml.snakeyaml.emitter.EmitterException;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.ImplicitTuple;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.events.StreamEndEvent;
import org.yaml.snakeyaml.events.StreamStartEvent;

public class PsychEmitter
extends RubyObject {
    Emitter emitter;
    DumperOptions options = new DumperOptions();
    IRubyObject io;
    private static final Mark NULL_MARK = new Mark("", 0, 0, 0, new int[0], 0);
    private static final DumperOptions.ScalarStyle[] SCALAR_STYLES = new DumperOptions.ScalarStyle[]{DumperOptions.ScalarStyle.PLAIN, DumperOptions.ScalarStyle.PLAIN, DumperOptions.ScalarStyle.SINGLE_QUOTED, DumperOptions.ScalarStyle.DOUBLE_QUOTED, DumperOptions.ScalarStyle.LITERAL, DumperOptions.ScalarStyle.FOLDED};
    private static final DumperOptions.FlowStyle[] FLOW_STYLES = new DumperOptions.FlowStyle[]{DumperOptions.FlowStyle.AUTO, DumperOptions.FlowStyle.BLOCK, DumperOptions.FlowStyle.FLOW};

    public static void initPsychEmitter(Ruby ruby, RubyModule rubyModule) {
        RubyClass rubyClass = ruby.defineClassUnder("Handler", ruby.getObject(), ruby.getObject().getAllocator(), rubyModule);
        RubyClass rubyClass2 = ruby.defineClassUnder("Emitter", rubyClass, new ObjectAllocator(){

            public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                return new PsychEmitter(ruby, rubyClass);
            }
        }, rubyModule);
        rubyClass2.defineAnnotatedMethods(PsychEmitter.class);
    }

    public PsychEmitter(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.options = new DumperOptions();
        this.options.setIndent(2);
        this.io = iRubyObject;
        return threadContext.nil;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        IRubyObject iRubyObject3 = iRubyObject2.callMethod(threadContext, "line_width");
        IRubyObject iRubyObject4 = iRubyObject2.callMethod(threadContext, "canonical");
        IRubyObject iRubyObject5 = iRubyObject2.callMethod(threadContext, "indentation");
        this.options = new DumperOptions();
        this.options.setCanonical(iRubyObject4.isTrue());
        this.options.setIndent((int)iRubyObject5.convertToInteger().getLongValue());
        this.line_width_set(threadContext, iRubyObject3);
        this.io = iRubyObject;
        return threadContext.nil;
    }

    @JRubyMethod
    public IRubyObject start_stream(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyFixnum)) {
            throw threadContext.runtime.newTypeError(iRubyObject, threadContext.runtime.getFixnum());
        }
        this.initEmitter(threadContext, iRubyObject);
        StreamStartEvent streamStartEvent = new StreamStartEvent(NULL_MARK, NULL_MARK);
        this.emit(threadContext, (Event)streamStartEvent);
        return this;
    }

    @JRubyMethod
    public IRubyObject end_stream(ThreadContext threadContext) {
        StreamEndEvent streamEndEvent = new StreamEndEvent(NULL_MARK, NULL_MARK);
        this.emit(threadContext, (Event)streamEndEvent);
        return this;
    }

    @JRubyMethod
    public IRubyObject start_document(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        RubyArray rubyArray;
        int n;
        DumperOptions.Version version = null;
        boolean bl = iRubyObject3.isTrue();
        HashMap<String, String> hashMap = null;
        RubyArray rubyArray2 = iRubyObject.convertToArray();
        if (rubyArray2.size() == 2) {
            int n2 = (int)rubyArray2.eltInternal(0).convertToInteger().getLongValue();
            n = (int)rubyArray2.eltInternal(1).convertToInteger().getLongValue();
            if (n2 == 1) {
                if (n == 0) {
                    version = DumperOptions.Version.V1_0;
                } else if (n == 1) {
                    version = DumperOptions.Version.V1_1;
                }
            }
            if (version == null) {
                throw threadContext.runtime.newArgumentError("invalid YAML version: " + rubyArray2);
            }
        }
        if ((rubyArray = iRubyObject2.convertToArray()).size() > 0) {
            hashMap = new HashMap<String, String>(rubyArray.size());
            for (n = 0; n < rubyArray.size(); ++n) {
                RubyArray rubyArray3 = rubyArray.eltInternal(n).convertToArray();
                if (rubyArray3.size() != 2) {
                    throw threadContext.runtime.newRuntimeError("tags tuple must be of length 2");
                }
                IRubyObject iRubyObject4 = rubyArray3.eltInternal(0);
                IRubyObject iRubyObject5 = rubyArray3.eltInternal(1);
                hashMap.put(iRubyObject4.asJavaString(), iRubyObject5.asJavaString());
            }
        }
        DocumentStartEvent documentStartEvent = new DocumentStartEvent(NULL_MARK, NULL_MARK, !bl, version, hashMap);
        this.emit(threadContext, (Event)documentStartEvent);
        return this;
    }

    @JRubyMethod
    public IRubyObject end_document(ThreadContext threadContext, IRubyObject iRubyObject) {
        DocumentEndEvent documentEndEvent = new DocumentEndEvent(NULL_MARK, NULL_MARK, !iRubyObject.isTrue());
        this.emit(threadContext, (Event)documentEndEvent);
        return this;
    }

    @JRubyMethod(required=6)
    public IRubyObject scalar(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject = iRubyObjectArray[0];
        IRubyObject iRubyObject2 = iRubyObjectArray[1];
        IRubyObject iRubyObject3 = iRubyObjectArray[2];
        IRubyObject iRubyObject4 = iRubyObjectArray[3];
        IRubyObject iRubyObject5 = iRubyObjectArray[4];
        IRubyObject iRubyObject6 = iRubyObjectArray[5];
        if (!(iRubyObject instanceof RubyString)) {
            throw threadContext.runtime.newTypeError(iRubyObject, threadContext.runtime.getString());
        }
        ScalarEvent scalarEvent = new ScalarEvent(iRubyObject2.isNil() ? null : iRubyObject2.asJavaString(), iRubyObject3.isNil() ? null : iRubyObject3.asJavaString(), new ImplicitTuple(iRubyObject4.isTrue(), iRubyObject5.isTrue()), iRubyObject.asJavaString(), NULL_MARK, NULL_MARK, SCALAR_STYLES[iRubyObject6.convertToInteger().getIntValue()]);
        this.emit(threadContext, (Event)scalarEvent);
        return this;
    }

    @JRubyMethod(required=4)
    public IRubyObject start_sequence(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject = iRubyObjectArray[0];
        IRubyObject iRubyObject2 = iRubyObjectArray[1];
        IRubyObject iRubyObject3 = iRubyObjectArray[2];
        IRubyObject iRubyObject4 = iRubyObjectArray[3];
        SequenceStartEvent sequenceStartEvent = new SequenceStartEvent(iRubyObject.isNil() ? null : iRubyObject.asJavaString(), iRubyObject2.isNil() ? null : iRubyObject2.asJavaString(), iRubyObject3.isTrue(), NULL_MARK, NULL_MARK, FLOW_STYLES[iRubyObject4.convertToInteger().getIntValue()]);
        this.emit(threadContext, (Event)sequenceStartEvent);
        return this;
    }

    @JRubyMethod
    public IRubyObject end_sequence(ThreadContext threadContext) {
        SequenceEndEvent sequenceEndEvent = new SequenceEndEvent(NULL_MARK, NULL_MARK);
        this.emit(threadContext, (Event)sequenceEndEvent);
        return this;
    }

    @JRubyMethod(required=4)
    public IRubyObject start_mapping(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject = iRubyObjectArray[0];
        IRubyObject iRubyObject2 = iRubyObjectArray[1];
        IRubyObject iRubyObject3 = iRubyObjectArray[2];
        IRubyObject iRubyObject4 = iRubyObjectArray[3];
        MappingStartEvent mappingStartEvent = new MappingStartEvent(iRubyObject.isNil() ? null : iRubyObject.asJavaString(), iRubyObject2.isNil() ? null : iRubyObject2.asJavaString(), iRubyObject3.isTrue(), NULL_MARK, NULL_MARK, FLOW_STYLES[iRubyObject4.convertToInteger().getIntValue()]);
        this.emit(threadContext, (Event)mappingStartEvent);
        return this;
    }

    @JRubyMethod
    public IRubyObject end_mapping(ThreadContext threadContext) {
        MappingEndEvent mappingEndEvent = new MappingEndEvent(NULL_MARK, NULL_MARK);
        this.emit(threadContext, (Event)mappingEndEvent);
        return this;
    }

    @JRubyMethod
    public IRubyObject alias(ThreadContext threadContext, IRubyObject iRubyObject) {
        AliasEvent aliasEvent = new AliasEvent(iRubyObject.asJavaString(), NULL_MARK, NULL_MARK);
        this.emit(threadContext, (Event)aliasEvent);
        return this;
    }

    @JRubyMethod(name={"canonical="})
    public IRubyObject canonical_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.options.setCanonical(iRubyObject.isTrue());
        return iRubyObject;
    }

    @JRubyMethod
    public IRubyObject canonical(ThreadContext threadContext) {
        return threadContext.runtime.newBoolean(this.options.isCanonical());
    }

    @JRubyMethod(name={"indentation="})
    public IRubyObject indentation_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.options.setIndent((int)iRubyObject.convertToInteger().getLongValue());
        return iRubyObject;
    }

    @JRubyMethod
    public IRubyObject indentation(ThreadContext threadContext) {
        return threadContext.runtime.newFixnum(this.options.getIndent());
    }

    @JRubyMethod(name={"line_width="})
    public IRubyObject line_width_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        int n = (int)iRubyObject.convertToInteger().getLongValue();
        if (n <= 0) {
            n = Integer.MAX_VALUE;
        }
        this.options.setWidth(n);
        return iRubyObject;
    }

    @JRubyMethod
    public IRubyObject line_width(ThreadContext threadContext) {
        return threadContext.runtime.newFixnum(this.options.getWidth());
    }

    private void emit(ThreadContext threadContext, Event event) {
        try {
            if (this.emitter == null) {
                throw threadContext.runtime.newRuntimeError("uninitialized emitter");
            }
            this.emitter.emit(event);
        }
        catch (IOException iOException) {
            throw threadContext.runtime.newIOErrorFromException(iOException);
        }
        catch (EmitterException emitterException) {
            throw threadContext.runtime.newRuntimeError(emitterException.toString());
        }
    }

    private void initEmitter(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.emitter != null) {
            throw threadContext.runtime.newRuntimeError("already initialized emitter");
        }
        Encoding encoding = PsychLibrary.YAMLEncoding.values()[(int)iRubyObject.convertToInteger().getLongValue()].encoding;
        Charset charset = threadContext.runtime.getEncodingService().charsetForEncoding(encoding);
        this.emitter = new Emitter((Writer)new OutputStreamWriter((OutputStream)new IOOutputStream(this.io, encoding), charset), this.options);
    }
}

