/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.EncodingVersion;
import com.zeroc.Ice.ProtocolVersion;
import com.zeroc.Ice.UnsupportedEncodingException;
import com.zeroc.Ice.UnsupportedProtocolException;

public final class Protocol {
    public static final int headerSize = 14;
    public static final byte[] magic = new byte[]{73, 99, 101, 80};
    public static final byte protocolMajor = 1;
    public static final byte protocolMinor = 0;
    public static final byte protocolEncodingMajor = 1;
    public static final byte protocolEncodingMinor = 0;
    public static final byte encodingMajor = 1;
    public static final byte encodingMinor = 1;
    public static final byte requestMsg = 0;
    public static final byte requestBatchMsg = 1;
    public static final byte replyMsg = 2;
    public static final byte validateConnectionMsg = 3;
    public static final byte closeConnectionMsg = 4;
    public static final byte[] requestHdr = new byte[]{magic[0], magic[1], magic[2], magic[3], 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final byte[] requestBatchHdr = new byte[]{magic[0], magic[1], magic[2], magic[3], 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final byte[] replyHdr = new byte[]{magic[0], magic[1], magic[2], magic[3], 1, 0, 1, 0, 2, 0, 0, 0, 0, 0};
    public static final ProtocolVersion currentProtocol = new ProtocolVersion(1, 0);
    public static final EncodingVersion currentProtocolEncoding = new EncodingVersion(1, 0);
    public static final EncodingVersion currentEncoding = new EncodingVersion(1, 1);
    public static final int OPTIONAL_END_MARKER = 255;
    public static final byte FLAG_HAS_TYPE_ID_STRING = 1;
    public static final byte FLAG_HAS_TYPE_ID_INDEX = 2;
    public static final byte FLAG_HAS_TYPE_ID_COMPACT = 3;
    public static final byte FLAG_HAS_OPTIONAL_MEMBERS = 4;
    public static final byte FLAG_HAS_INDIRECTION_TABLE = 8;
    public static final byte FLAG_HAS_SLICE_SIZE = 16;
    public static final byte FLAG_IS_LAST_SLICE = 32;

    public static void checkSupportedProtocol(ProtocolVersion v) {
        if (v.major != Protocol.currentProtocol.major || v.minor > Protocol.currentProtocol.minor) {
            throw new UnsupportedProtocolException("", v, currentProtocol);
        }
    }

    public static void checkSupportedProtocolEncoding(EncodingVersion v) {
        if (v.major != Protocol.currentProtocolEncoding.major || v.minor > Protocol.currentProtocolEncoding.minor) {
            throw new UnsupportedEncodingException("", v, currentProtocolEncoding);
        }
    }

    public static void checkSupportedEncoding(EncodingVersion v) {
        if (v.major != Protocol.currentEncoding.major || v.minor > Protocol.currentEncoding.minor) {
            throw new UnsupportedEncodingException("", v, currentEncoding);
        }
    }

    public static ProtocolVersion getCompatibleProtocol(ProtocolVersion v) {
        if (v.major != Protocol.currentProtocol.major) {
            return v;
        }
        if (v.minor < Protocol.currentProtocol.minor) {
            return v;
        }
        return currentProtocol;
    }

    public static EncodingVersion getCompatibleEncoding(EncodingVersion v) {
        if (v.major != Protocol.currentEncoding.major) {
            return v;
        }
        if (v.minor < Protocol.currentEncoding.minor) {
            return v;
        }
        return currentEncoding;
    }

    public static boolean isSupported(EncodingVersion version, EncodingVersion supported) {
        return version.major == supported.major && version.minor <= supported.minor;
    }
}

