/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.main.HtmlTools;
import freemind.modes.MindMapNode;
import freemind.modes.mindmapmode.MindMapController;
import freemind.view.mindmapview.MapView;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class JoinNodesAction
extends AbstractAction {
    private final MindMapController controller;
    static final Pattern BODY_START = Pattern.compile("<body>", 2);
    static final Pattern BODY_END = Pattern.compile("</body>", 2);

    public JoinNodesAction(MindMapController controller) {
        super(controller.getText("join_nodes"));
        this.controller = controller;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MindMapNode selectedNode = this.controller.getView().getSelected().getModel();
        ArrayList selectedNodes = this.controller.getView().getSelectedNodesSortedByY();
        this.joinNodes(selectedNode, selectedNodes);
    }

    public void joinNodes(MindMapNode selectedNode, List selectedNodes) {
        String newContent = "";
        MapView mapView = this.controller.getView();
        for (MindMapNode node : selectedNodes) {
            if (!node.hasChildren()) continue;
            JOptionPane.showMessageDialog(mapView, this.controller.getText("cannot_join_nodes_with_children"), "FreeMind", 2);
            return;
        }
        boolean isHtml = false;
        for (MindMapNode node : selectedNodes) {
            String nodeContent = node.toString();
            boolean isHtmlNode = HtmlTools.isHtmlNode(nodeContent);
            newContent = this.addContent(newContent, isHtml, nodeContent, isHtmlNode);
            if (node != selectedNode) {
                this.controller.deleteNode(node);
            }
            isHtml = isHtml || isHtmlNode;
        }
        mapView.selectAsTheOnlyOneSelected(mapView.getNodeView(selectedNode));
        this.controller.setNodeText(selectedNode, newContent);
    }

    private String addContent(String content, boolean isHtml, String nodeContent, boolean isHtmlNode) {
        if (isHtml) {
            String[] start = BODY_END.split(content, -2);
            content = start[0];
            if (!isHtmlNode) {
                String[] end = BODY_START.split(content, 2);
                nodeContent = end[0] + "<body><p>" + nodeContent + "</p>";
            }
        }
        if (isHtmlNode & !content.equals("")) {
            String[] end = BODY_START.split(nodeContent, 2);
            nodeContent = end[1];
            if (!isHtml) {
                content = end[0] + "<body><p>" + content + "</p>";
            }
        }
        if (!(isHtml || isHtmlNode || content.equals(""))) {
            content = content + " ";
        }
        content = content + nodeContent;
        return content;
    }
}

