/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.main.Tools;
import freemind.view.mindmapview.EdgeView;
import freemind.view.mindmapview.MainView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class SharpBezierEdgeView
extends EdgeView {
    CubicCurve2D.Float line1 = new CubicCurve2D.Float();
    CubicCurve2D.Float line2 = new CubicCurve2D.Float();
    GeneralPath graph = new GeneralPath();
    Point2D.Float one;
    Point2D.Float two;
    private int deltaX;
    private int deltaY;
    private static final float XCTRL = 12.0f;

    private void update() {
        float zoom = this.getMap().getZoom();
        float xctrlRelative = 12.0f * zoom;
        if (this.getTarget().isLeft()) {
            this.one = new Point2D.Float((float)this.start.x - xctrlRelative, this.start.y);
            this.two = new Point2D.Float((float)this.end.x + xctrlRelative, this.end.y);
        } else {
            this.one = new Point2D.Float((float)this.start.x + xctrlRelative, this.start.y);
            this.two = new Point2D.Float((float)this.end.x - xctrlRelative, this.end.y);
        }
        float w = ((float)this.getWidth() / 2.0f + 1.0f) * zoom;
        float w2 = w / 2.0f;
        this.line1.setCurve(this.start.x - this.deltaX, this.start.y - this.deltaY, this.one.x - (float)this.deltaX, this.one.y - (float)this.deltaY, this.two.x, this.two.y - w2, this.end.x, this.end.y);
        this.line2.setCurve(this.end.x, this.end.y, this.two.x, this.two.y + w2, this.one.x + (float)this.deltaX, this.one.y + (float)this.deltaY, this.start.x + this.deltaX, this.start.y + this.deltaY);
        this.graph.reset();
        this.graph.append(this.line1, true);
        this.graph.append(this.line2, true);
        this.graph.closePath();
    }

    @Override
    protected void paint(Graphics2D g) {
        this.update();
        g.setColor(this.getColor());
        g.setPaint(this.getColor());
        g.setStroke(DEF_STROKE);
        g.fill(this.graph);
        g.draw(this.graph);
    }

    @Override
    public Color getColor() {
        return this.getModel().getColor();
    }

    @Override
    protected void createStart() {
        if (this.source.isRoot()) {
            double x0;
            double x02;
            this.start = this.source.getMainViewOutPoint(this.getTarget(), this.end);
            MainView mainView = this.source.getMainView();
            double w = mainView.getWidth() / 2;
            double w2 = w * w;
            if (w2 == (x02 = (x0 = (double)this.start.x - w) * x0)) {
                int delta = this.getMap().getZoomed(this.getWidth() / 2 + 1);
                this.deltaX = 0;
                this.deltaY = delta;
            } else {
                double delta = this.getMap().getZoom() * (float)(this.getWidth() / 2 + 1);
                int h = mainView.getHeight() / 2;
                int y0 = this.start.y - h;
                double k = (double)h / w * x0 / Math.sqrt(w2 - x02);
                double dx = delta / Math.sqrt(1.0 + k * k);
                this.deltaX = (int)dx;
                this.deltaY = (int)(k * dx);
                if (y0 > 0) {
                    this.deltaY = -this.deltaY;
                }
            }
            Tools.convertPointToAncestor((Component)mainView, this.start, this.source);
        } else {
            int delta = this.getMap().getZoomed(this.getWidth() / 2 + 1);
            super.createStart();
            this.deltaX = 0;
            this.deltaY = delta;
        }
    }
}

