/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Stroke;
import java.util.List;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.MapPolygon;

public class MapPolygonImpl
implements MapPolygon {
    private List<Coordinate> points;
    private Color color;
    private Stroke stroke;

    public MapPolygonImpl(List<Coordinate> points) {
        this(points, Color.BLUE, new BasicStroke(2.0f));
    }

    public MapPolygonImpl(List<Coordinate> points, Color color, Stroke stroke) {
        this.points = points;
        this.color = color;
        this.stroke = stroke;
    }

    @Override
    public List<Coordinate> getPoints() {
        return this.points;
    }

    @Override
    public void paint(Graphics g, List<Point> points) {
        Polygon polygon = new Polygon();
        for (Point p : points) {
            polygon.addPoint(p.x, p.y);
        }
        this.paint(g, polygon);
    }

    @Override
    public void paint(Graphics g, Polygon polygon) {
        Color oldColor = g.getColor();
        g.setColor(this.color);
        Stroke oldStroke = null;
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            oldStroke = g2.getStroke();
            g2.setStroke(this.stroke);
        }
        g.drawPolygon(polygon);
        g.setColor(oldColor);
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setStroke(oldStroke);
        }
    }

    public String toString() {
        return "MapPolygon [points=" + this.points + "]";
    }
}

