/*
 * Decompiled with CFR 0.152.
 */
package plugins.collaboration.socket;

import freemind.main.Resources;
import java.util.logging.Logger;

public abstract class TerminateableThread
extends Thread {
    protected boolean mShouldTerminate = false;
    protected boolean mIsTerminated = false;
    protected static Logger logger = null;
    protected int mSleepTime;

    public TerminateableThread(String pName) {
        super(pName);
        if (logger == null) {
            logger = Resources.getInstance().getLogger(this.getClass().getName());
        }
        this.mSleepTime = 1000;
    }

    @Override
    public void run() {
        while (!this.mShouldTerminate) {
            boolean shouldBeCalledDirectlyAgain = false;
            try {
                shouldBeCalledDirectlyAgain = this.processAction();
            }
            catch (Exception e) {
                Resources.getInstance().logException((Throwable)e);
            }
            if (shouldBeCalledDirectlyAgain) continue;
            try {
                Thread.sleep(this.mSleepTime);
            }
            catch (InterruptedException e) {
                Resources.getInstance().logException((Throwable)e);
            }
        }
        this.mIsTerminated = true;
    }

    public abstract boolean processAction() throws Exception;

    public void commitSuicide() {
        this.mShouldTerminate = true;
        int timeout = 10;
        logger.info("Shutting down thread " + this.getName() + ".");
        while (!this.mIsTerminated && timeout-- > 0) {
            try {
                Thread.sleep(this.mSleepTime);
            }
            catch (InterruptedException e) {
                Resources.getInstance().logException((Throwable)e);
            }
        }
        if (timeout == 0) {
            logger.warning("Can't stop thread " + this.getName() + "!");
        } else {
            logger.info("Shutting down thread " + this.getName() + " complete.");
        }
    }
}

