/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.jpeg.test;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.metadata.Metadata;
import com.drew.metadata.jpeg.JpegComponent;
import com.drew.metadata.jpeg.JpegDirectory;
import com.drew.metadata.jpeg.JpegReader;
import java.io.File;
import java.io.FileNotFoundException;
import junit.framework.TestCase;

public class JpegReaderTest
extends TestCase {
    private JpegDirectory _directory;

    public JpegReaderTest(String s) {
        super(s);
    }

    public void setUp() throws JpegProcessingException, FileNotFoundException {
        File jpegFile = new File("src/com/drew/metadata/jpeg/test/simple.jpg");
        JpegReader reader = new JpegReader(jpegFile);
        Metadata metadata = reader.extract();
        JpegReaderTest.assertTrue((boolean)metadata.containsDirectory(JpegDirectory.class));
        this._directory = (JpegDirectory)metadata.getDirectory(JpegDirectory.class);
    }

    public void testExtract_Width() throws Exception {
        JpegReaderTest.assertEquals((int)800, (int)this._directory.getInt(3));
    }

    public void testExtract_Height() throws Exception {
        JpegReaderTest.assertEquals((int)600, (int)this._directory.getInt(1));
    }

    public void testExtract_DataPrecision() throws Exception {
        JpegReaderTest.assertEquals((int)8, (int)this._directory.getInt(0));
    }

    public void testExtract_NumberOfComponents() throws Exception {
        JpegReaderTest.assertEquals((int)3, (int)this._directory.getInt(5));
    }

    public void testComponentData1() throws Exception {
        JpegComponent component = (JpegComponent)this._directory.getObject(6);
        JpegReaderTest.assertEquals((String)"Y", (String)component.getComponentName());
        JpegReaderTest.assertEquals((int)1, (int)component.getComponentId());
        JpegReaderTest.assertEquals((int)0, (int)component.getQuantizationTableNumber());
        JpegReaderTest.assertEquals((int)2, (int)component.getHorizontalSamplingFactor());
        JpegReaderTest.assertEquals((int)2, (int)component.getVerticalSamplingFactor());
    }

    public void testComponentData2() throws Exception {
        JpegComponent component = (JpegComponent)this._directory.getObject(7);
        JpegReaderTest.assertEquals((String)"Cb", (String)component.getComponentName());
        JpegReaderTest.assertEquals((int)2, (int)component.getComponentId());
        JpegReaderTest.assertEquals((int)1, (int)component.getQuantizationTableNumber());
        JpegReaderTest.assertEquals((int)1, (int)component.getHorizontalSamplingFactor());
        JpegReaderTest.assertEquals((int)1, (int)component.getVerticalSamplingFactor());
        JpegReaderTest.assertEquals((String)"Cb component: Quantization table 1, Sampling factors 1 horiz/1 vert", (String)this._directory.getDescription(7));
    }

    public void testComponentData3() throws Exception {
        JpegComponent component = (JpegComponent)this._directory.getObject(8);
        JpegReaderTest.assertEquals((String)"Cr", (String)component.getComponentName());
        JpegReaderTest.assertEquals((int)3, (int)component.getComponentId());
        JpegReaderTest.assertEquals((int)1, (int)component.getQuantizationTableNumber());
        JpegReaderTest.assertEquals((int)1, (int)component.getHorizontalSamplingFactor());
        JpegReaderTest.assertEquals((int)1, (int)component.getVerticalSamplingFactor());
        JpegReaderTest.assertEquals((String)"Cr component: Quantization table 1, Sampling factors 1 horiz/1 vert", (String)this._directory.getDescription(8));
    }
}

