/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.tasks;

import java.util.List;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.data.UpdateCityName;
import org.fibs.geotag.data.UpdateCountryName;
import org.fibs.geotag.data.UpdateLocationName;
import org.fibs.geotag.data.UpdateProvinceName;
import org.fibs.geotag.geonames.Location;
import org.fibs.geotag.geonames.WikipediaLocation;
import org.fibs.geotag.table.ImagesTableModel;
import org.fibs.geotag.tasks.UndoableBackgroundTask;
import org.fibs.geotag.util.Util;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class SelectLocationNameTask
extends UndoableBackgroundTask<ImageInfo> {
    private static final I18n i18n = I18nFactory.getI18n(SelectLocationNameTask.class);
    private ImageInfo imageInfo;
    private Location location;
    private String actualName;
    private ImageInfo.DATA_SOURCE dataSource;
    private ImagesTableModel imagesTableModel;

    public SelectLocationNameTask(String name, ImagesTableModel imagesTableModel, ImageInfo imageInfo, Location location, String actualName, ImageInfo.DATA_SOURCE dataSource) {
        super(null, name);
        this.imagesTableModel = imagesTableModel;
        this.imageInfo = imageInfo;
        this.location = location;
        this.actualName = actualName;
        this.dataSource = dataSource;
    }

    @Override
    public int getCurrentProgress() {
        return 1;
    }

    @Override
    public int getMaxProgress() {
        return 1;
    }

    @Override
    public int getMinProgress() {
        return 1;
    }

    @Override
    protected String doInBackground() throws Exception {
        if (this.location != null) {
            if (this.location instanceof WikipediaLocation && !Util.sameContent(this.imageInfo.getLocationName(), this.actualName)) {
                new UpdateLocationName(this.imageInfo, this.actualName, this.dataSource);
                this.publish(this.imageInfo);
            } else if (this.location.isPopulatedPlace()) {
                if (!(Util.sameContent(this.imageInfo.getCityName(), this.actualName) && Util.sameContent(this.imageInfo.getProvinceName(), this.location.getProvince()) && Util.sameContent(this.imageInfo.getCountryName(), this.location.getCountryName()))) {
                    new UpdateCityName(this.imageInfo, this.actualName, this.dataSource);
                    new UpdateProvinceName(this.imageInfo, this.location.getProvince(), this.dataSource);
                    new UpdateCountryName(this.imageInfo, this.location.getCountryName(), this.dataSource);
                    this.publish(this.imageInfo);
                }
            } else if (!(Util.sameContent(this.imageInfo.getLocationName(), this.actualName) && Util.sameContent(this.imageInfo.getProvinceName(), this.location.getProvince()) && Util.sameContent(this.imageInfo.getCountryName(), this.location.getCountryName()))) {
                new UpdateLocationName(this.imageInfo, this.actualName, this.dataSource);
                new UpdateProvinceName(this.imageInfo, this.location.getProvince(), this.dataSource);
                new UpdateCountryName(this.imageInfo, this.location.getCountryName(), this.dataSource);
                this.publish(this.imageInfo);
            }
        }
        return i18n.tr("New location name selected.");
    }

    @Override
    protected void process(List<ImageInfo> images) {
        for (ImageInfo image : images) {
            int imageRow = this.imagesTableModel.getRow(image);
            this.imagesTableModel.fireTableRowsUpdated(imageRow, imageRow);
        }
    }
}

