/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;
import org.gjt.sp.jedit.textarea.TextAreaPainter;

class InputMethodSupport
extends TextAreaExtension
implements InputMethodRequests,
InputMethodListener {
    private TextArea owner;
    private TextLayout composedTextLayout = null;
    private int composedCaretX = 0;
    private int lastCommittedAt = 0;
    private String lastCommittedText = null;

    public InputMethodSupport(TextArea textArea) {
        this.owner = textArea;
        textArea.addInputMethodListener(this);
        textArea.getPainter().addExtension(Integer.MAX_VALUE, this);
    }

    private Rectangle getCaretRectangle(int n, int n2) {
        TextAreaPainter textAreaPainter = this.owner.getPainter();
        Point point = textAreaPainter.getLocationOnScreen();
        int n3 = textAreaPainter.getLineHeight();
        return new Rectangle(point.x + n, point.y + n2, 0, n3);
    }

    @Override
    public void paintValidLine(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (this.composedTextLayout != null && n3 <= (n6 = this.owner.getCaretPosition()) && n6 < n4) {
            TextAreaPainter textAreaPainter = this.owner.getPainter();
            FontMetrics fontMetrics = textAreaPainter.getFontMetrics();
            int n7 = this.owner.offsetToXY((int)n6).x;
            int n8 = Math.round(this.composedTextLayout.getAdvance());
            int n9 = textAreaPainter.getLineHeight();
            int n10 = n9 - (fontMetrics.getLeading() + 1) - fontMetrics.getDescent();
            int n11 = n7 + this.composedCaretX;
            graphics2D.setColor(textAreaPainter.getBackground());
            graphics2D.fillRect(n7, n5, n8, n9);
            graphics2D.setColor(textAreaPainter.getForeground());
            this.composedTextLayout.draw(graphics2D, n7, n5 + n10);
            graphics2D.setColor(textAreaPainter.getCaretColor());
            graphics2D.drawLine(n11, n5, n11, n5 + n9 - 1);
        }
    }

    @Override
    public Rectangle getTextLocation(TextHitInfo textHitInfo) {
        if (this.composedTextLayout != null) {
            Point point = this.owner.offsetToXY(this.owner.getCaretPosition());
            return this.getCaretRectangle(point.x + this.composedCaretX, point.y);
        }
        Selection selection = this.owner.getSelectionAtOffset(this.owner.getCaretPosition());
        if (selection != null) {
            Point point = this.owner.offsetToXY(selection.getStart());
            return this.getCaretRectangle(point.x, point.y);
        }
        return null;
    }

    @Override
    public TextHitInfo getLocationOffset(int n, int n2) {
        if (this.composedTextLayout != null) {
            Point point = this.owner.getPainter().getLocationOnScreen();
            Point point2 = this.owner.offsetToXY(this.owner.getCaretPosition());
            float f = n - point.x - point2.x;
            float f2 = (float)(n2 - point.y - point2.y) - (this.composedTextLayout.getLeading() + 1.0f) - this.composedTextLayout.getAscent();
            return this.composedTextLayout.hitTestChar(f, f2);
        }
        return null;
    }

    @Override
    public int getInsertPositionOffset() {
        return this.owner.getCaretPosition();
    }

    @Override
    public AttributedCharacterIterator getCommittedText(int n, int n2, AttributedCharacterIterator.Attribute[] attributeArray) {
        return new AttributedString(this.owner.getText(n, n2 - n)).getIterator();
    }

    @Override
    public int getCommittedTextLength() {
        return this.owner.getBufferLength();
    }

    @Override
    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        if (this.lastCommittedText != null) {
            int n = this.lastCommittedAt;
            int n2 = this.lastCommittedText.length();
            String string = this.owner.getText(n, n2);
            if (string != null && string.equals(this.lastCommittedText)) {
                AttributedCharacterIterator attributedCharacterIterator = new AttributedString(string).getIterator();
                this.owner.getBuffer().remove(n, n2);
                this.owner.setCaretPosition(n);
                this.lastCommittedText = null;
                return attributedCharacterIterator;
            }
            this.lastCommittedText = null;
        }
        return null;
    }

    @Override
    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        Selection selection = this.owner.getSelectionAtOffset(this.owner.getCaretPosition());
        if (selection != null) {
            return new AttributedString(this.owner.getSelectedText(selection)).getIterator();
        }
        return null;
    }

    @Override
    public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
        this.composedTextLayout = null;
        AttributedCharacterIterator attributedCharacterIterator = inputMethodEvent.getText();
        if (attributedCharacterIterator != null) {
            int n;
            int n2 = inputMethodEvent.getCommittedCharacterCount();
            if (n2 > 0) {
                this.lastCommittedText = null;
                this.lastCommittedAt = this.owner.getCaretPosition();
                StringBuilder stringBuilder = new StringBuilder(n2);
                char c = attributedCharacterIterator.first();
                for (int i = n2; c != '\uffff' && i > 0; --i) {
                    this.owner.userInput(c);
                    stringBuilder.append(c);
                    c = attributedCharacterIterator.next();
                }
                this.lastCommittedText = stringBuilder.toString();
            }
            if (n2 < (n = attributedCharacterIterator.getEndIndex())) {
                AttributedString attributedString = new AttributedString(attributedCharacterIterator, n2, n);
                TextAreaPainter textAreaPainter = this.owner.getPainter();
                attributedString.addAttribute(TextAttribute.FONT, textAreaPainter.getFont());
                this.composedTextLayout = new TextLayout(attributedString.getIterator(), textAreaPainter.getFontRenderContext());
            }
        }
        this.caretPositionChanged(inputMethodEvent);
    }

    @Override
    public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
        this.composedCaretX = 0;
        if (this.composedTextLayout != null) {
            TextHitInfo textHitInfo = inputMethodEvent.getCaret();
            if (textHitInfo != null) {
                this.composedCaretX = Math.round(this.composedTextLayout.getCaretInfo(textHitInfo)[0]);
            }
            int n = this.owner.offsetToXY((int)this.owner.getCaretPosition()).x;
            TextHitInfo textHitInfo2 = inputMethodEvent.getVisiblePosition();
            int n2 = textHitInfo2 != null ? Math.round(this.composedTextLayout.getCaretInfo(textHitInfo2)[0]) : this.composedCaretX;
            int n3 = n + n2;
            int n4 = this.owner.getPainter().getWidth();
            int n5 = 0;
            if (n3 < 0) {
                n5 = n3;
            }
            if (n3 >= n4) {
                n5 = n3 - (n4 - 1);
            }
            if (n5 != 0) {
                this.owner.setHorizontalOffset(this.owner.getHorizontalOffset() - n5);
            }
        } else {
            this.owner.scrollToCaret(false);
        }
        int n = this.owner.getCaretLine();
        this.owner.invalidateLineRange(n, n + 1);
        inputMethodEvent.consume();
    }
}

