/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import org.gjt.sp.jedit.Debug;
import org.gjt.sp.util.Log;

class RangeMap {
    private int[] fvm;
    private int fvmcount;
    private int lastfvmget;

    RangeMap() {
        this.fvm = new int[2];
        this.lastfvmget = -1;
    }

    RangeMap(RangeMap rangeMap) {
        this.fvm = (int[])rangeMap.fvm.clone();
        this.fvmcount = rangeMap.fvmcount;
    }

    void reset(int n) {
        this.lastfvmget = -1;
        this.fvmcount = 2;
        this.fvm[0] = 0;
        this.fvm[1] = n;
    }

    int first() {
        return this.fvm[0];
    }

    int last() {
        return this.fvm[this.fvmcount - 1] - 1;
    }

    int lookup(int n) {
        return this.fvm[n];
    }

    int search(int n) {
        if (n < this.fvm[0]) {
            return -1;
        }
        if (n >= this.fvm[this.fvmcount - 1]) {
            return this.fvmcount - 1;
        }
        if (this.lastfvmget != -1 && n >= this.fvm[this.lastfvmget] && (this.lastfvmget == this.fvmcount - 1 || n < this.fvm[this.lastfvmget + 1])) {
            return this.lastfvmget;
        }
        int n2 = 0;
        int n3 = this.fvmcount - 1;
        block4: while (true) {
            switch (n3 - n2) {
                case 0: {
                    this.lastfvmget = n2;
                    break block4;
                }
                case 1: {
                    int n4 = this.fvm[n3];
                    if (n4 <= n) {
                        this.lastfvmget = n3;
                        break block4;
                    }
                    this.lastfvmget = n2;
                    break block4;
                }
                default: {
                    int n5 = (n3 + n2) / 2;
                    int n4 = this.fvm[n5];
                    if (n4 == n) {
                        this.lastfvmget = n5;
                        break block4;
                    }
                    if (n4 < n) {
                        n2 = n5;
                        continue block4;
                    }
                    n3 = n5 - 1;
                    continue block4;
                }
            }
            break;
        }
        return this.lastfvmget;
    }

    void put(int n, int n2, int[] nArray) {
        int n3;
        int n4;
        if (Debug.FOLD_VIS_DEBUG) {
            StringBuilder stringBuilder = new StringBuilder(50);
            stringBuilder.append("fvmput(").append(n).append(',');
            stringBuilder.append(n2).append(',');
            stringBuilder.append('{');
            if (nArray != null) {
                for (n4 = 0; n4 < nArray.length; ++n4) {
                    if (n4 != 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(nArray[n4]);
                }
            }
            stringBuilder.append("})");
            Log.log(1, this, stringBuilder.toString());
        }
        if (this.fvmcount + (n4 = (n3 = nArray == null ? 0 : nArray.length) - (n2 - n)) > this.fvm.length) {
            int[] nArray2 = new int[(this.fvm.length << 1) + 1];
            System.arraycopy(this.fvm, 0, nArray2, 0, this.fvmcount);
            this.fvm = nArray2;
        }
        if (n4 != 0) {
            System.arraycopy(this.fvm, n2, this.fvm, n + n3, this.fvmcount - n2);
        }
        if (n3 != 0) {
            System.arraycopy(nArray, 0, this.fvm, n, nArray.length);
        }
        this.fvmcount += n4;
        this.dump();
        if (this.fvmcount == 0) {
            throw new InternalError();
        }
    }

    void put2(int n, int n2, int n3, int n4) {
        if (Debug.FOLD_VIS_DEBUG) {
            Log.log(1, this, "*fvmput2(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        }
        if (n != -1 && this.fvm[n] == n3) {
            if (n2 <= this.fvmcount - 2 && this.fvm[n2 + 1] == n4 + 1) {
                this.put(n, n2 + 2, null);
            } else {
                this.put(n, n2 + 1, new int[]{n4 + 1});
            }
        } else if (n2 != this.fvmcount - 1 && this.fvm[n2 + 1] == n4 + 1) {
            this.put(n + 1, n2 + 2, new int[]{n3});
        } else {
            this.put(n + 1, n2 + 1, new int[]{n3, n4 + 1});
        }
    }

    int next(int n) {
        int n2 = this.search(n);
        if (n2 % 2 != 0) {
            if (this.fvmcount == n2 + 1) {
                return -1;
            }
            return this.fvm[n2 + 1];
        }
        if (n == this.fvm[n2 + 1] - 1) {
            if (this.fvmcount == n2 + 2) {
                return -1;
            }
            return this.fvm[n2 + 2];
        }
        return n + 1;
    }

    int prev(int n) {
        int n2 = this.search(n);
        if (n2 == -1) {
            return -1;
        }
        if (n2 % 2 == 1) {
            return this.fvm[n2] - 1;
        }
        if (n == this.fvm[n2]) {
            if (n2 == 0) {
                return -1;
            }
            return this.fvm[n2 - 1] - 1;
        }
        return n - 1;
    }

    void show(int n, int n2) {
        int n3 = this.search(n);
        int n4 = this.search(n2);
        if (n3 % 2 == 0) {
            if (n4 % 2 == 0) {
                this.put(n3 + 1, n4 + 1, null);
            } else if (n4 != this.fvmcount - 1 && this.fvm[n4 + 1] == n2 + 1) {
                this.put(n3 + 1, n4 + 2, null);
            } else {
                this.put(n3 + 1, n4, null);
                this.fvm[n3 + 1] = n2 + 1;
            }
        } else if (n4 % 2 == 0) {
            if (n3 != -1 && this.fvm[n3] == n) {
                this.put(n3, n4 + 1, null);
            } else {
                this.put(n3 + 1, n4, null);
                this.fvm[n3 + 1] = n;
            }
        } else {
            this.put2(n3, n4, n, n2);
        }
        this.lastfvmget = -1;
    }

    void hide(int n, int n2) {
        int n3 = this.search(n);
        int n4 = this.search(n2);
        if (n3 % 2 == 0) {
            if (n4 % 2 == 0) {
                this.put2(n3, n4, n, n2);
            } else if (n == this.fvm[0]) {
                this.put(n3, n4 + 1, null);
            } else {
                this.put(n3 + 1, n4, null);
                this.fvm[n3 + 1] = n;
            }
        } else if (n4 % 2 == 0) {
            if (n2 + 1 == this.fvm[this.fvmcount - 1]) {
                this.put(n3 + 1, n4 + 2, null);
            } else {
                this.put(n3 + 1, n4, null);
                this.fvm[n3 + 1] = n2 + 1;
            }
        } else {
            this.put(n3 + 1, n4 + 1, null);
        }
        this.lastfvmget = -1;
    }

    int count() {
        return this.fvmcount;
    }

    void dump() {
        if (Debug.FOLD_VIS_DEBUG) {
            StringBuilder stringBuilder = new StringBuilder("{");
            for (int i = 0; i < this.fvmcount; ++i) {
                if (i != 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(this.fvm[i]);
            }
            stringBuilder.append('}');
            Log.log(1, this, "fvm = " + stringBuilder);
        }
    }

    void contentInserted(int n, int n2) {
        if (n2 != 0) {
            int n3;
            int n4 = this.search(n);
            int n5 = n3 = n4 + 1;
            while (n5 < this.fvmcount) {
                int n6 = n5++;
                this.fvm[n6] = this.fvm[n6] + n2;
            }
            this.lastfvmget = -1;
            this.dump();
        }
    }

    boolean preContentRemoved(int n, int n2) {
        boolean bl = false;
        int n3 = n + n2;
        int n4 = this.search(n);
        int n5 = this.search(n3);
        if (Math.abs(n4 % 2) == Math.abs(n5 % 2)) {
            if (n5 - n4 == this.fvmcount) {
                bl = true;
                n4 = 1;
            } else {
                this.put(n4 + 1, n5 + 1, null);
                ++n4;
            }
        } else if (n4 != -1 && this.fvm[n4] == n) {
            if (n5 - n4 == this.fvmcount - 1) {
                bl = true;
                n4 = 1;
            } else {
                this.put(n4, n5 + 1, null);
            }
        } else {
            this.put(n4 + 1, n5, null);
            this.fvm[n4 + 1] = n;
            n4 += 2;
        }
        int n6 = n4;
        while (n6 < this.fvmcount) {
            int n7 = n6++;
            this.fvm[n7] = this.fvm[n7] - n2;
        }
        this.lastfvmget = -1;
        this.dump();
        return bl;
    }
}

