/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.textarea.Anchor;
import org.gjt.sp.jedit.textarea.DisplayManager;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;

class ScrollLineCount
extends Anchor {
    ScrollLineCount(DisplayManager displayManager, TextArea textArea) {
        super(displayManager, textArea);
    }

    @Override
    public void changed() {
    }

    @Override
    public void reset() {
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "reset()");
        }
        int n = 0;
        int n2 = this.getDisplayManager().getFirstVisibleLine();
        while (n2 != -1) {
            n += this.getDisplayManager().getScreenLineCount(n2);
            n2 = this.getDisplayManager().getNextVisibleLine(n2);
        }
        this.setPhysicalLine(this.getDisplayManager().getBuffer().getLineCount());
        this.setScrollLine(n);
    }

    @Override
    void preContentInserted(int n, int n2) {
        this.preContentInsertedScrollLines = 0;
        int n3 = n;
        if (!this.getDisplayManager().isLineVisible(n3)) {
            n3 = this.getDisplayManager().getNextVisibleLine(n3);
        }
        this.preContentInsertedScrollLines = this.getDisplayManager().getScreenLineCount(n3);
    }

    @Override
    void contentInserted(int n, int n2) {
        int n3 = 0;
        int n4 = n;
        int n5 = 0;
        int n6 = n2;
        while (n5 < n6) {
            if (this.getDisplayManager().isLineVisible(n4)) {
                n3 += this.getDisplayManager().getScreenLineCount(n4);
            }
            ++n5;
            ++n4;
        }
        if (!this.getDisplayManager().isLineVisible(n4)) {
            n4 = this.getDisplayManager().getNextVisibleLine(n4);
        }
        if (n4 >= 0) {
            n3 += this.getDisplayManager().getScreenLineCount(n4);
        }
        this.movePhysicalLine(n2);
        this.moveScrollLine(n3 -= this.preContentInsertedScrollLines);
    }

    @Override
    void preContentRemoved(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n;
        int n6 = 0;
        int n7 = 0;
        int n8 = n3;
        while (n7 < n8) {
            if (this.getDisplayManager().isLineVisible(n5)) {
                n4 += this.getDisplayManager().getScreenLineCount(n5);
                ++n6;
            }
            ++n7;
            ++n5;
        }
        if (!this.getDisplayManager().isLineVisible(n5)) {
            n5 = this.getDisplayManager().getNextVisibleLine(n5);
        }
        if (n5 >= 0) {
            n4 += this.getDisplayManager().getScreenLineCount(n5);
            ++n6;
        }
        this.preContentRemovedScrollLines = n4;
    }

    @Override
    void contentRemoved(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n;
        if (!this.getDisplayManager().isLineVisible(n5)) {
            n5 = this.getDisplayManager().getNextVisibleLine(n5);
        }
        n4 = this.getDisplayManager().getScreenLineCount(n5);
        this.movePhysicalLine(-n3);
        this.moveScrollLine(n4 -= this.preContentRemovedScrollLines);
    }
}

