/**
 * Copyright (c) 2011-2013 by Andrew Mustun. All rights reserved.
 * 
 * This file is part of the QCAD project.
 *
 * QCAD is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QCAD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QCAD.
 */
// Auto generated by Testing Dashboard
// File        : scripts/Modify/Rotate2/Tests/Rotate2Test03.js
// Timestamp   : 2011-08-08 13:59:18
// Description : Rotate 2 using an ellipse

include('scripts/Pro/Developer/TestingDashboard/TdbTest.js');

function Rotate2Test03() {
    TdbTest.call(this, 'scripts/Modify/Rotate2/Tests/Rotate2Test03.js');
}

Rotate2Test03.prototype = new TdbTest();

Rotate2Test03.prototype.test00 = function() {
    qDebug('running Rotate2Test03.test00()...');
    this.setUp();
    var w = objectFromPath('MainWindow::CadToolBar::MainToolsPanel');
    this.sendMouseEvent(w, QEvent.MouseButtonPress, new QPoint(60, 410), Qt.LeftButton, 1, 0);
    var w = objectFromPath('MainWindow::CadToolBar::MainToolsPanel');
    this.sendMouseEvent(w, QEvent.MouseButtonRelease, new QPoint(60, 410), Qt.LeftButton, 0, 0);
    this.importFile('scripts/Modify/Rotate2/Tests/data/ellipse.dxf');
    this.setZoom(19.176250917513833, new RVector(13.1934, 14.2118, 0) );
    var p = new RVector(0, -3);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.triggerCommand('rotate2');
    this.setToolOption('TranslateRotate/PrimaryAngle',  [ 33, 0 ] );
    this.setToolOption('TranslateRotate/SecondaryAngle',  [ 33, 0 ] );
    this.setToolOption('TranslateRotate/NumberOfCopies',  [ 8, 0 ] );
    this.updateToolOptions();
    this.setZoom(19.176250917513833, new RVector(13.1934, 14.2118, 0) );
    var p = new RVector(-0.052148, -2.895704);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setZoom(19.176250917513833, new RVector(13.1934, 14.2118, 0) );
    var p = new RVector(-0.052148, -3.052148);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.dlgStart();
    this.dlgAppendCode('var map = new Map()');
    this.dlgAppendCode("map.put('DialogOpenedByTdb/groupBox', 'MultipleCopies')");
    this.dlgAppendCode("map.put('DialogOpenedByTdb/NumberOfCopies',  [ 8, 0 ] )");
    this.dlgAppendCode("map.put('DialogOpenedByTdb/PrimaryAngle',  [ 33, 0 ] )");
    this.dlgAppendCode("map.put('DialogOpenedByTdb/SecondaryAngle',  [ 33, 0 ] )");
    this.dlgAppendCode("map.put('DialogOpenedByTdb/UseCurrentAttributes', false)");
    this.dlgAppendCode("WidgetFactory.restoreState(dialog, 'DialogOpenedByTdb', undefined, false, undefined, map)");
    this.dlgEnd();
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.verifyDrawing('Rotate2Test03_000.dxf');
    this.tearDown();
    qDebug('finished Rotate2Test03.test00()');
};

