/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.SecurityDialog;
import net.sourceforge.jnlp.security.SecurityDialogMessage;
import net.sourceforge.jnlp.security.appletextendedsecurity.UnsignedAppletTrustConfirmation;
import net.sourceforge.jnlp.security.dialogresults.BasicDialogValue;
import net.sourceforge.jnlp.security.dialogs.CertWarningPane;
import net.sourceforge.jnlp.security.dialogs.remember.RememberDialog;
import net.sourceforge.jnlp.security.dialogs.remember.RememberableDialog;
import net.sourceforge.jnlp.security.dialogs.remember.SavedRememberAction;
import net.sourceforge.jnlp.util.logging.OutputController;

public class SecurityDialogMessageHandler
implements Runnable {
    private BlockingQueue<SecurityDialogMessage> queue = new LinkedBlockingQueue<SecurityDialogMessage>();

    @Override
    public void run() {
        OutputController.getLogger().log("Starting security dialog thread");
        while (true) {
            try {
                while (true) {
                    SecurityDialogMessage msg = this.queue.take();
                    this.handleMessage(msg);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    protected void handleMessage(SecurityDialogMessage message) {
        SecurityDialog dialog = new SecurityDialog(message.dialogType, message.accessType, message.file, message.certVerifier, message.certificate, message.extras);
        if (this.processAutomatedAnswers(message, dialog)) {
            return;
        }
        RememberableDialog found = RememberDialog.getInstance().findRememberablePanel(dialog.getSecurityDialogPanel());
        SavedRememberAction action = null;
        if (found != null) {
            action = RememberDialog.getInstance().getRememberedState(found);
        }
        if (action != null && action.isRemember()) {
            message.userResponse = found.readValue(action.getSavedValue());
            UnsignedAppletTrustConfirmation.updateAppletAction(found.getFile(), action, null, found.getClass());
            this.unlockMessagesClient(message);
        } else if (!SecurityDialogMessageHandler.shouldPromptUser()) {
            message.userResponse = dialog.getDefaultNegativeAnswer();
            this.unlockMessagesClient(message);
        } else if (SecurityDialogMessageHandler.isHeadless()) {
            this.processMessageInHeadless(dialog, message);
        } else {
            this.processMessageInGui(dialog, found, message);
        }
    }

    private boolean processAutomatedAnswers(SecurityDialogMessage message, SecurityDialog dialog) {
        if (SecurityDialogMessageHandler.isXtrustNone()) {
            message.userResponse = dialog.getDefaultNegativeAnswer();
            this.unlockMessagesClient(message);
            return true;
        }
        if (SecurityDialogMessageHandler.isXtrustAll()) {
            message.userResponse = dialog.getDefaultPositiveAnswer();
            this.unlockMessagesClient(message);
            return true;
        }
        return false;
    }

    private void processMessageInGui(final SecurityDialog dialog, final RememberableDialog found, final SecurityDialogMessage message) {
        dialog.getViwableDialog().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (found == null) {
                    message.userResponse = dialog.getValue();
                } else {
                    message.userResponse = found.getValue();
                    RememberDialog.getInstance().setOrUpdateRememberedState(dialog);
                }
                SecurityDialogMessageHandler.this.unlockMessagesClient(message);
            }
        });
        dialog.getViwableDialog().show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMessageInHeadless(SecurityDialog dialog, SecurityDialogMessage message) {
        try {
            boolean keepGoing = true;
            boolean repeatAll = true;
            do {
                try {
                    if (repeatAll) {
                        OutputController.getLogger().printOutLn(dialog.getText());
                    }
                    OutputController.getLogger().printOutLn(Translator.R("HeadlessDialogues"));
                    OutputController.getLogger().printOutLn(dialog.helpToStdIn());
                    String s = OutputController.getLogger().readLine();
                    if (s == null) {
                        throw new IOException("Stream closed");
                    }
                    if (s.trim().toLowerCase().equals("exit")) {
                        JNLPRuntime.exit(0);
                    }
                    boolean codebase = false;
                    boolean remember = false;
                    if (s.startsWith("RC ")) {
                        codebase = true;
                        remember = true;
                        s = s.substring(3);
                    }
                    if (s.startsWith("R ")) {
                        remember = true;
                        s = s.substring(2);
                    }
                    message.userResponse = dialog.readFromStdIn(s);
                    keepGoing = false;
                    try {
                        String value = BasicDialogValue.writeNUll();
                        if (message.userResponse != null) {
                            value = message.userResponse.writeValue();
                        }
                        if (dialog.getSecurityDialogPanel() instanceof CertWarningPane) {
                            CertWarningPane cp = (CertWarningPane)dialog.getSecurityDialogPanel();
                            if (remember) {
                                cp.saveCert();
                            }
                        }
                        RememberDialog.getInstance().setOrUpdateRememberedState(dialog, codebase, new SavedRememberAction(RememberDialog.createAction(remember, message.userResponse), value));
                    }
                    catch (Exception ex) {
                        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, ex);
                    }
                }
                catch (IOException eex) {
                    OutputController.getLogger().log(eex);
                    keepGoing = false;
                }
                catch (IllegalArgumentException eeex) {
                    OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, eeex.toString());
                    OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, eeex);
                    OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("HDwrongValue"));
                    repeatAll = false;
                }
                catch (Exception ex) {
                    OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, ex.toString());
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, ex);
                    repeatAll = true;
                }
            } while (keepGoing);
        }
        finally {
            this.unlockMessagesClient(message);
        }
    }

    protected void unlockMessagesClient(SecurityDialogMessage msg) {
        if (msg.toDispose != null) {
            msg.toDispose.dispose();
        }
        if (msg.lock != null) {
            msg.lock.release();
        }
    }

    public void postMessage(SecurityDialogMessage message) {
        try {
            this.queue.put(message);
        }
        catch (InterruptedException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
        }
    }

    private static boolean shouldPromptUser() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.valueOf(JNLPRuntime.getConfiguration().getProperty("deployment.security.askgrantdialog.show"));
            }
        });
    }

    private static boolean isHeadless() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return JNLPRuntime.isHeadless();
            }
        });
    }

    private static boolean isXtrustAll() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return JNLPRuntime.isTrustAll();
            }
        });
    }

    private static boolean isXtrustNone() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return JNLPRuntime.isTrustNone();
            }
        });
    }
}

