/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.imap;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Namespaces {
    List personal;
    List other;
    List shared;

    Namespaces(String string) {
        ArrayList arrayList = new ArrayList();
        int n = string.length();
        Namespaces.parse(string, 0, n, arrayList);
        n = arrayList.size();
        if (n > 0) {
            this.personal = this.parseNamespaceList(arrayList.get(0));
            if (n > 1) {
                this.other = this.parseNamespaceList(arrayList.get(1));
                if (n > 2) {
                    this.shared = this.parseNamespaceList(arrayList.get(2));
                }
            }
        }
    }

    public Namespace[] getPersonal() {
        return this.toArray(this.personal);
    }

    public Namespace[] getOther() {
        return this.toArray(this.other);
    }

    public Namespace[] getShared() {
        return this.toArray(this.shared);
    }

    private Namespace[] toArray(List list) {
        if (list == null) {
            return null;
        }
        Namespace[] namespaceArray = new Namespace[list.size()];
        list.toArray(namespaceArray);
        return namespaceArray;
    }

    static int parse(String string, int n, int n2, List list) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        block6: for (int i = n; i < n2; ++i) {
            String string2;
            char c = string.charAt(i);
            if (bl) {
                if (c == '\"') {
                    string2 = stringBuffer.toString();
                    stringBuffer.setLength(0);
                    bl = false;
                    list.add(string2);
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            switch (c) {
                case ' ': {
                    string2 = stringBuffer.toString();
                    if ("NIL".equals(string2)) {
                        list.add(null);
                    }
                    stringBuffer.setLength(0);
                    continue block6;
                }
                case '\"': {
                    bl = true;
                    stringBuffer.setLength(0);
                    continue block6;
                }
                case '(': {
                    ArrayList arrayList = new ArrayList();
                    i = Namespaces.parse(string, i + 1, n2, arrayList);
                    list.add(arrayList);
                    continue block6;
                }
                case ')': {
                    return i;
                }
            }
        }
        return n2;
    }

    private List parseNamespaceList(Object object) {
        if (object == null) {
            return null;
        }
        List list = (List)object;
        int n = list.size();
        ArrayList<Namespace> arrayList = new ArrayList<Namespace>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.parseNamespace((List)list.get(i)));
        }
        return arrayList;
    }

    private Namespace parseNamespace(List list) {
        int n = list.size();
        Namespace namespace = new Namespace();
        namespace.prefix = (String)list.get(0);
        namespace.delimiter = ((String)list.get(1)).charAt(0);
        if (n > 2) {
            namespace.extensions = new TreeMap();
            for (int i = 2; i < n; i += 2) {
                String string = (String)list.get(i);
                Object v = i == n - 1 ? null : (Object)list.get(i + 1);
                namespace.extensions.put(string, v);
            }
        }
        return namespace;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendNamespaceList(stringBuffer, this.personal);
        stringBuffer.append(' ');
        this.appendNamespaceList(stringBuffer, this.other);
        stringBuffer.append(' ');
        this.appendNamespaceList(stringBuffer, this.shared);
        return stringBuffer.toString();
    }

    private void appendNamespaceList(StringBuffer stringBuffer, List list) {
        if (list == null) {
            stringBuffer.append("NIL");
        } else {
            int n = list.size();
            stringBuffer.append('(');
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(list.get(i));
            }
            stringBuffer.append(')');
        }
    }

    public static class Namespace {
        String prefix;
        char delimiter;
        Map extensions;

        public String getPrefix() {
            return this.prefix;
        }

        public char getDelimiter() {
            return this.delimiter;
        }

        public Map getExtensions() {
            return this.extensions;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('(');
            stringBuffer.append(Namespace.quote(this.prefix));
            stringBuffer.append(' ');
            stringBuffer.append(Namespace.quote(this.delimiter));
            if (this.extensions != null) {
                stringBuffer.append(' ');
                for (Map.Entry entry : this.extensions.entrySet()) {
                    String string = (String)entry.getKey();
                    stringBuffer.append(Namespace.quote(string));
                    stringBuffer.append(' ');
                    stringBuffer.append(this.format(entry.getValue()));
                }
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }

        static String quote(String string) {
            return '\"' + string + '\"';
        }

        static String quote(char c) {
            char[] cArray = new char[]{'\"', c, '\"'};
            return new String(cArray);
        }

        private String format(Object object) {
            if (object == null) {
                return "NIL";
            }
            if (object instanceof String) {
                return Namespace.quote((String)object);
            }
            List list = (List)object;
            int n = list.size();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('(');
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(this.format(list.get(i)));
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }
}

