/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.imap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class UTF7imap {
    private static final String US_ASCII = "US-ASCII";
    private static final byte[] src;
    private static final byte[] dst;

    private UTF7imap() {
    }

    static byte[] encode(byte[] byArray) {
        int n = 0;
        byte[] byArray2 = new byte[(byArray.length + 2) / 3 * 4 - 1];
        for (int i = 0; i < byArray.length; i += 3) {
            byte by;
            byte by2;
            byte by3;
            int n2 = byArray.length - i;
            if (n2 == 1) {
                by3 = byArray[i];
                by2 = 0;
                by = 0;
                byArray2[n++] = src[by3 >>> 2 & 0x3F];
                byArray2[n++] = src[(by3 << 4 & 0x30) + (by2 >>> 4 & 0xF)];
                continue;
            }
            if (n2 == 2) {
                by3 = byArray[i];
                by2 = byArray[i + 1];
                by = 0;
                byArray2[n++] = src[by3 >>> 2 & 0x3F];
                byArray2[n++] = src[(by3 << 4 & 0x30) + (by2 >>> 4 & 0xF)];
                byArray2[n++] = src[(by2 << 2 & 0x3C) + (by >>> 6 & 3)];
                continue;
            }
            if (n2 != 3) continue;
            by3 = byArray[i];
            by2 = byArray[i + 1];
            by = byArray[i + 2];
            byArray2[n++] = src[by3 >>> 2 & 0x3F];
            byArray2[n++] = src[(by3 << 4 & 0x30) + (by2 >>> 4 & 0xF)];
            byArray2[n++] = src[(by2 << 2 & 0x3C) + (by >>> 6 & 3)];
            byArray2[n++] = src[by & 0x3F];
        }
        return byArray2;
    }

    static int[] decode(byte[] byArray) {
        int[] nArray = new int[byArray.length];
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length - n2;
        while (n3 > 0) {
            byte by = dst[byArray[n2++] & 0xFF];
            byte by2 = dst[byArray[n2++] & 0xFF];
            nArray[n++] = by << 2 & 0xFC | by2 >>> 4 & 3;
            if (n3 > 2) {
                by = by2;
                by2 = dst[byArray[n2++] & 0xFF];
                nArray[n++] = by << 4 & 0xF0 | by2 >>> 2 & 0xF;
                if (n3 > 3) {
                    by = by2;
                    by2 = dst[byArray[n2++] & 0xFF];
                    nArray[n++] = by << 6 & 0xC0 | by2 & 0x3F;
                }
            }
            n3 = byArray.length - n2;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public static String encode(String string) {
        try {
            StringBuffer stringBuffer = null;
            OutputStream outputStream = null;
            char[] cArray = string.toCharArray();
            boolean bl = false;
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if (c == '&') {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                        for (int j = 0; j < i; ++j) {
                            stringBuffer.append(cArray[j]);
                        }
                    }
                    stringBuffer.append('&');
                    stringBuffer.append('-');
                    continue;
                }
                if (c < '\u001f' || c > '\u007f') {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                        for (int j = 0; j < i; ++j) {
                            stringBuffer.append(cArray[j]);
                        }
                        outputStream = new ByteArrayOutputStream();
                    }
                    if (!bl) {
                        ((ByteArrayOutputStream)outputStream).reset();
                        stringBuffer.append('&');
                        bl = true;
                    }
                    ((ByteArrayOutputStream)outputStream).write(c / 256);
                    ((ByteArrayOutputStream)outputStream).write(c % 256);
                    continue;
                }
                if (bl) {
                    outputStream.flush();
                    byte[] byArray = UTF7imap.encode(((ByteArrayOutputStream)outputStream).toByteArray());
                    stringBuffer.append(new String(byArray, US_ASCII));
                    stringBuffer.append('-');
                    bl = false;
                    if (c == '-') continue;
                    stringBuffer.append(c);
                    continue;
                }
                if (stringBuffer == null) continue;
                stringBuffer.append(c);
            }
            if (bl) {
                outputStream.flush();
                byte[] byArray = UTF7imap.encode(((ByteArrayOutputStream)outputStream).toByteArray());
                stringBuffer.append(new String(byArray, US_ASCII));
                stringBuffer.append('-');
            }
            if (stringBuffer != null) {
                return stringBuffer.toString();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
        return string;
    }

    public static String decode(String string) {
        StringBuffer stringBuffer = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        char[] cArray = string.toCharArray();
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '&') {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    for (int j = 0; j < i; ++j) {
                        stringBuffer.append(cArray[j]);
                    }
                }
                byteArrayOutputStream.reset();
                bl = true;
                continue;
            }
            if (c == '-' && bl) {
                if (byteArrayOutputStream.size() == 0) {
                    stringBuffer.append('&');
                } else {
                    int[] nArray = UTF7imap.decode(byteArrayOutputStream.toByteArray());
                    for (int j = 0; j < nArray.length - 1; j += 2) {
                        int n = nArray[j];
                        int n2 = nArray[j + 1];
                        int n3 = n * 256 | n2;
                        stringBuffer.append((char)n3);
                    }
                }
                bl = false;
                continue;
            }
            if (bl) {
                byteArrayOutputStream.write((byte)c);
                continue;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append(c);
        }
        if (stringBuffer != null) {
            return stringBuffer.toString();
        }
        return string;
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-d")) {
                bl = true;
                continue;
            }
            String string = bl ? UTF7imap.decode(stringArray[i]) : UTF7imap.encode(stringArray[i]);
            StringBuffer stringBuffer = new StringBuffer(stringArray[i]);
            stringBuffer.append(" = \"");
            stringBuffer.append(string);
            stringBuffer.append("\"(");
            for (int j = 0; j < string.length(); ++j) {
                if (j > 0) {
                    stringBuffer.append(' ');
                }
                char c = string.charAt(j);
                stringBuffer.append(Integer.toString(c, 16));
            }
            stringBuffer.append(")");
            System.out.println(stringBuffer.toString());
        }
    }

    static {
        int n;
        src = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 44};
        dst = new byte[256];
        for (n = 0; n < 255; ++n) {
            UTF7imap.dst[n] = -1;
        }
        for (n = 0; n < src.length; ++n) {
            UTF7imap.dst[UTF7imap.src[n]] = (byte)n;
        }
    }
}

